/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.metadata.Resources;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.util.CheckedArrayList;
import org.apache.sis.internal.util.CheckedHashSet;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.MetadataCopier;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.StateChanger;
import org.apache.sis.metadata.UnmodifiableMetadataException;
import org.apache.sis.util.collection.CodeListSet;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.CodeList;

@XmlTransient
public abstract class ModifiableMetadata
extends AbstractMetadata {
    private static final byte EDITABLE = 0;
    private static final byte STAGED = 1;
    private static final byte FREEZING = 2;
    private static final byte COMPLETABLE = 3;
    private static final byte FINAL = 4;
    private transient byte state;

    protected ModifiableMetadata() {
    }

    public State state() {
        return State.VALUES[this.state];
    }

    public boolean transitionTo(State state) {
        if (state.code < this.state) {
            throw new UnmodifiableMetadataException(Resources.format((short)1));
        }
        if (state.code == this.state || this.state == 2) {
            return false;
        }
        byte by = this.state;
        try {
            this.state = (byte)2;
            StateChanger.applyTo(state, this);
            by = state.code;
        }
        finally {
            this.state = by;
        }
        return true;
    }

    public ModifiableMetadata deepCopy(State state) {
        MetadataCopier metadataCopier;
        if (state.isUnmodifiable()) {
            if (this.state >= 4) {
                return this;
            }
            metadataCopier = MetadataCopier.forModifiable(this.getStandard());
        } else {
            metadataCopier = new MetadataCopier(this.getStandard());
        }
        ModifiableMetadata modifiableMetadata = (ModifiableMetadata)metadataCopier.copyRecursively(this.getInterface(), this);
        if (state.code > 0) {
            modifiableMetadata.transitionTo(state);
        }
        return modifiableMetadata;
    }

    protected void checkWritePermission(Object object) throws UnmodifiableMetadataException {
        if (this.state != 3) {
            if (this.state == 4) {
                throw new UnmodifiableMetadataException(Resources.format((short)1));
            }
        } else if (object != null) {
            MetadataStandard metadataStandard = object instanceof AbstractMetadata ? ((AbstractMetadata)object).getStandard() : this.getStandard();
            Object object2 = metadataStandard.getTitle(object);
            if (object2 != null) {
                object = object2;
            }
            throw new UnmodifiableMetadataException(Resources.format((short)2, object));
        }
    }

    protected final <E> List<E> writeList(Collection<? extends E> collection, List<E> list, Class<E> clazz) throws UnmodifiableMetadataException {
        return (List)this.write(collection, list, clazz, Boolean.FALSE);
    }

    protected final <E> Set<E> writeSet(Collection<? extends E> collection, Set<E> set, Class<E> clazz) throws UnmodifiableMetadataException {
        return (Set)this.write(collection, set, clazz, Boolean.TRUE);
    }

    protected final <E> Collection<E> writeCollection(Collection<? extends E> collection, Collection<E> collection2, Class<E> clazz) throws UnmodifiableMetadataException {
        return this.write(collection, collection2, clazz, null);
    }

    private <E> Collection<E> write(Collection<? extends E> collection, Collection<E> collection2, Class<E> clazz, Boolean bl) throws UnmodifiableMetadataException {
        if (collection != collection2) {
            if (this.state == 2) {
                assert (bl != null || this.collectionType(clazz).isInstance(collection)) : clazz;
                return collection;
            }
            this.checkWritePermission(MetadataUtilities.valueIfDefined(collection2));
            if (Containers.isNullOrEmpty(collection)) {
                collection2 = null;
            } else {
                if (collection2 != null && this.state != 3) {
                    collection2.clear();
                } else {
                    if (bl == null) {
                        bl = this.useSet(clazz);
                    }
                    collection2 = bl != false ? ModifiableMetadata.createSet(clazz, collection) : ModifiableMetadata.createList(clazz, collection);
                }
                collection2.addAll(collection);
                if (this.state == 3) {
                    collection2 = bl != false ? CollectionsExt.unmodifiableOrCopy((Set)collection2) : CollectionsExt.unmodifiableOrCopy((List)((List)collection2));
                }
            }
        }
        return collection2;
    }

    protected final <K, V> Map<K, V> writeMap(Map<? extends K, ? extends V> map, Map<K, V> map2, Class<K> clazz) throws UnmodifiableMetadataException {
        if (map != map2) {
            if (this.state == 2) {
                return map;
            }
            this.checkWritePermission(map2 == null || map2.isEmpty() ? null : map2);
            if (Containers.isNullOrEmpty(map)) {
                map2 = null;
            } else {
                if (map2 != null && this.state != 3) {
                    map2.clear();
                } else {
                    map2 = ModifiableMetadata.createMap(clazz, map);
                }
                map2.putAll(map);
                if (this.state == 3) {
                    map2 = CollectionsExt.unmodifiableOrCopy(map2);
                }
            }
        }
        return map2;
    }

    protected final <E> List<E> copyList(Collection<? extends E> collection, Class<E> clazz) {
        if (Containers.isNullOrEmpty(collection)) {
            return null;
        }
        List<? extends E> list = ModifiableMetadata.createList(clazz, collection);
        list.addAll(collection);
        return list;
    }

    protected final <E> Set<E> copySet(Collection<? extends E> collection, Class<E> clazz) {
        if (Containers.isNullOrEmpty(collection)) {
            return null;
        }
        Set<? extends E> set = ModifiableMetadata.createSet(clazz, collection);
        set.addAll(collection);
        return set;
    }

    protected final <E> Collection<E> copyCollection(Collection<? extends E> collection, Class<E> clazz) {
        if (Containers.isNullOrEmpty(collection)) {
            return null;
        }
        Collection<E> collection2 = this.useSet(clazz) ? ModifiableMetadata.createSet(clazz, collection) : ModifiableMetadata.createList(clazz, collection);
        collection2.addAll(collection);
        return collection2;
    }

    protected final <K, V> Map<K, V> copyMap(Map<? extends K, ? extends V> map, Class<K> clazz) {
        if (Containers.isNullOrEmpty(map)) {
            return null;
        }
        Map<? extends K, ? extends V> map2 = ModifiableMetadata.createMap(clazz, map);
        map2.putAll(map);
        return map2;
    }

    protected final <E> Collection<E> singleton(E e, Class<E> clazz) {
        if (e == null) {
            return null;
        }
        CheckedArrayList checkedArrayList = this.useSet(clazz) ? ModifiableMetadata.createSet(clazz, null) : new CheckedArrayList(clazz, 1);
        checkedArrayList.add(e);
        return checkedArrayList;
    }

    private static boolean emptyCollectionAsNull() {
        return Semaphores.query((int)1);
    }

    protected final <E> List<E> nonNullList(List<E> list, Class<E> clazz) {
        if (list != null) {
            return list.isEmpty() && ModifiableMetadata.emptyCollectionAsNull() ? null : list;
        }
        if (ModifiableMetadata.emptyCollectionAsNull()) {
            return null;
        }
        if (this.state < 2) {
            return ModifiableMetadata.createList(clazz, list);
        }
        return Collections.emptyList();
    }

    protected final <E> Set<E> nonNullSet(Set<E> set, Class<E> clazz) {
        if (set != null) {
            return set.isEmpty() && ModifiableMetadata.emptyCollectionAsNull() ? null : set;
        }
        if (ModifiableMetadata.emptyCollectionAsNull()) {
            return null;
        }
        if (this.state < 2) {
            return ModifiableMetadata.createSet(clazz, set);
        }
        return Collections.emptySet();
    }

    protected final <E> Collection<E> nonNullCollection(Collection<E> collection, Class<E> clazz) {
        boolean bl;
        if (collection != null) {
            assert (this.collectionType(clazz).isInstance(collection));
            return collection.isEmpty() && ModifiableMetadata.emptyCollectionAsNull() ? null : collection;
        }
        if (ModifiableMetadata.emptyCollectionAsNull()) {
            return null;
        }
        boolean bl2 = bl = this.state < 2;
        if (this.useSet(clazz)) {
            if (bl) {
                return ModifiableMetadata.createSet(clazz, collection);
            }
            return Collections.emptySet();
        }
        if (bl) {
            return ModifiableMetadata.createList(clazz, collection);
        }
        return Collections.emptyList();
    }

    protected final <K, V> Map<K, V> nonNullMap(Map<K, V> map, Class<K> clazz) {
        if (map != null) {
            return map.isEmpty() && ModifiableMetadata.emptyCollectionAsNull() ? null : map;
        }
        if (ModifiableMetadata.emptyCollectionAsNull()) {
            return null;
        }
        if (this.state < 2) {
            return ModifiableMetadata.createMap(clazz, map);
        }
        return Collections.emptyMap();
    }

    private static <E> List<E> createList(Class<E> clazz, Collection<?> collection) {
        if (collection == null) {
            return new CheckedArrayList(clazz);
        }
        return new CheckedArrayList(clazz, collection.size());
    }

    private static <E> Set<E> createSet(Class<E> clazz, Collection<?> collection) {
        if (Enum.class.isAssignableFrom(clazz)) {
            return EnumSet.noneOf(clazz);
        }
        if (CodeList.class.isAssignableFrom(clazz) && Modifier.isFinal(clazz.getModifiers())) {
            return new CodeListSet(clazz);
        }
        return new CheckedHashSet(clazz, collection != null ? Containers.hashMapCapacity((int)collection.size()) : 4);
    }

    private static <K, V> Map<K, V> createMap(Class<K> clazz, Map<?, ?> map) {
        if (Enum.class.isAssignableFrom(clazz)) {
            return new EnumMap(clazz);
        }
        return new LinkedHashMap(map != null ? Containers.hashMapCapacity((int)map.size()) : 4);
    }

    private <E> boolean useSet(Class<E> clazz) {
        Class<Collection<E>> clazz2 = this.collectionType(clazz);
        if (Set.class == clazz2) {
            return true;
        }
        if (List.class == clazz2) {
            return false;
        }
        throw new NoSuchElementException(Errors.format((short)163, clazz2));
    }

    protected <E> Class<? extends Collection<E>> collectionType(Class<E> clazz) {
        return CodeList.class.isAssignableFrom(clazz) || Enum.class.isAssignableFrom(clazz) || Charset.class.isAssignableFrom(clazz) || String.class == clazz || Locale.class == clazz || Currency.class == clazz ? Set.class : List.class;
    }

    public static enum State {
        EDITABLE(0),
        COMPLETABLE(3),
        FINAL(4);

        private static final State[] VALUES;
        final byte code;

        private State(byte by) {
            this.code = by;
        }

        final boolean isUnmodifiable() {
            return this.code >= 4;
        }

        static {
            VALUES = new State[5];
            State.VALUES[0] = EDITABLE;
            State.VALUES[1] = EDITABLE;
            State.VALUES[2] = FINAL;
            State.VALUES[3] = COMPLETABLE;
            State.VALUES[4] = FINAL;
        }
    }
}

