/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateBuilderImpl;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib1.Grib1ParamLevel;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.util.Indent;

public class CoordinateVert
implements Coordinate {
    private final List<VertCoord.Level> levelSorted;
    private final int code;
    private String name;
    private final VertCoord.VertUnit vunit;
    private final boolean isLayer;

    public CoordinateVert(int code, VertCoord.VertUnit vunit, List<VertCoord.Level> levelSorted) {
        this.levelSorted = Collections.unmodifiableList(levelSorted);
        this.code = code;
        this.vunit = vunit;
        this.isLayer = levelSorted.get(0).isLayer();
    }

    public List<VertCoord.Level> getLevelSorted() {
        return this.levelSorted;
    }

    @Override
    public List<? extends Object> getValues() {
        return this.levelSorted;
    }

    @Override
    public int getIndex(Object val) {
        return this.levelSorted.indexOf(val);
    }

    @Override
    public Object getValue(int idx) {
        return this.levelSorted.get(idx);
    }

    @Override
    public int getSize() {
        return this.levelSorted.size();
    }

    @Override
    public Coordinate.Type getType() {
        return Coordinate.Type.vert;
    }

    @Override
    public String getUnit() {
        return this.vunit.getUnits();
    }

    public VertCoord.VertUnit getVertUnit() {
        return this.vunit;
    }

    public boolean isLayer() {
        return this.isLayer;
    }

    public boolean isPositiveUp() {
        return this.vunit.isPositiveUp();
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void showInfo(Formatter info, Indent indent) {
        info.format("%s%s: ", new Object[]{indent, this.getType()});
        for (VertCoord.Level level : this.levelSorted) {
            info.format(" %s", level);
        }
        info.format(" (%d)%n", this.levelSorted.size());
    }

    @Override
    public void showCoords(Formatter info) {
        info.format("Levels: (%s)%n", this.getUnit());
        for (VertCoord.Level level : this.levelSorted) {
            info.format("   %s%n", level);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateVert that = (CoordinateVert)o;
        if (this.code != that.code) {
            return false;
        }
        return this.levelSorted.equals(that.levelSorted);
    }

    public int hashCode() {
        int result = this.levelSorted.hashCode();
        result = 31 * result + this.code;
        return result;
    }

    public static class Builder1
    extends CoordinateBuilderImpl<Grib1Record> {
        int code;
        Grib1Customizer cust;

        public Builder1(Grib1Customizer cust, int code) {
            this.cust = cust;
            this.code = code;
        }

        @Override
        public Object extract(Grib1Record gr) {
            Grib1SectionProductDefinition pds = gr.getPDSsection();
            boolean isLayer = this.cust.isLayer(pds.getLevelType());
            Grib1ParamLevel plevel = this.cust.getParamLevel(pds);
            double level2val = isLayer ? (double)plevel.getValue2() : -9999.0;
            return new VertCoord.Level(plevel.getValue1(), level2val, isLayer);
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            ArrayList<VertCoord.Level> levelSorted = new ArrayList<VertCoord.Level>(values.size());
            for (Object val : values) {
                levelSorted.add((VertCoord.Level)val);
            }
            Collections.sort(levelSorted);
            return new CoordinateVert(this.code, this.cust.getVertUnit(this.code), levelSorted);
        }
    }

    public static class Builder2
    extends CoordinateBuilderImpl<Grib2Record> {
        int code;

        public Builder2(int code) {
            this.code = code;
        }

        @Override
        public Object extract(Grib2Record gr) {
            Grib2Pds pds = gr.getPDS();
            boolean hasLevel2 = pds.getLevelType2() != 255;
            double level2val = hasLevel2 ? pds.getLevelValue2() : -9999.0;
            boolean isLayer = Grib2Utils.isLayer(pds);
            return new VertCoord.Level(pds.getLevelValue1(), level2val, isLayer);
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            ArrayList<VertCoord.Level> levelSorted = new ArrayList<VertCoord.Level>(values.size());
            for (Object val : values) {
                levelSorted.add((VertCoord.Level)val);
            }
            Collections.sort(levelSorted);
            return new CoordinateVert(this.code, Grib2Utils.getLevelUnit(this.code), levelSorted);
        }
    }
}

