/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.IndexInputStream;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.IndexOutputStream;
import org.exoplatform.services.jcr.impl.util.io.DirectoryHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class IndexInfos {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.IndexInfos");
    public static final String DEFALUT_NAME = "indexes";
    private int counter;
    private boolean dirty;
    private List<String> indexes = new ArrayList<String>();
    private Set<String> names = new HashSet<String>();
    private final String name;
    private Directory dir;
    protected MultiIndex multiIndex;

    public IndexInfos() {
        this(DEFALUT_NAME);
    }

    public IndexInfos(String fileName) {
        this.name = fileName;
    }

    public String getFileName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() throws IOException {
        this.dir.listAll();
        this.names.clear();
        this.indexes.clear();
        if (this.dir.fileExists(this.name)) {
            IndexInputStream in = new IndexInputStream(this.dir.openInput(this.name));
            DataInputStream di = null;
            try {
                di = new DataInputStream(in);
                this.counter = di.readInt();
                for (int i = di.readInt(); i > 0; --i) {
                    String indexName = di.readUTF();
                    this.indexes.add(indexName);
                    this.names.add(indexName);
                }
            }
            finally {
                if (di != null) {
                    di.close();
                }
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        if (!this.dirty) {
            return;
        }
        IndexOutputStream out = new IndexOutputStream(this.dir.createOutput(this.name + ".new"));
        DataOutputStream dataOut = null;
        try {
            dataOut = new DataOutputStream(out);
            dataOut.writeInt(this.counter);
            dataOut.writeInt(this.indexes.size());
            for (int i = 0; i < this.indexes.size(); ++i) {
                dataOut.writeUTF(this.getName(i));
            }
        }
        finally {
            if (dataOut != null) {
                dataOut.close();
            }
            ((OutputStream)out).close();
        }
        if (this.dir.fileExists(this.name)) {
            this.dir.deleteFile(this.name);
        }
        this.rename(this.name + ".new", this.name);
        this.dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rename(String from, String to) throws IOException {
        block9: {
            IndexOutputStream out = null;
            IndexInputStream in = null;
            try {
                out = new IndexOutputStream(this.dir.createOutput(to));
                in = new IndexInputStream(this.dir.openInput(from));
                DirectoryHelper.transfer(in, out);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            try {
                if (this.dir.fileExists(from)) {
                    this.dir.deleteFile(from);
                }
            }
            catch (IOException e) {
                if (!LOG.isTraceEnabled()) break block9;
                LOG.trace((Object)("Can't deleted file: " + e.getMessage()));
            }
        }
    }

    public String getName(int i) {
        return this.indexes.get(i);
    }

    public Set<String> getNames() {
        return new HashSet<String>(this.indexes);
    }

    public int size() {
        return this.indexes.size();
    }

    public void addName(String name) {
        if (this.names.contains(name)) {
            throw new IllegalArgumentException("already contains: " + name);
        }
        this.indexes.add(name);
        this.names.add(name);
        this.dirty = true;
    }

    public void removeName(String name) {
        this.indexes.remove(name);
        this.names.remove(name);
        this.dirty = true;
    }

    public void removeName(int i) {
        String name = this.indexes.remove(i);
        this.names.remove(name);
        this.dirty = true;
    }

    public boolean contains(String name) {
        return this.names.contains(name);
    }

    public String newName() {
        this.dirty = true;
        return "_" + Integer.toString(this.counter++, 36);
    }

    public void setDirectory(Directory dir) {
        this.dir = dir;
    }

    protected void setNames(Set<String> names) {
        this.names.clear();
        this.indexes.clear();
        this.names.addAll(names);
        this.indexes.addAll(names);
        this.dirty = false;
    }

    public void setMultiIndex(MultiIndex multiIndex) {
        this.multiIndex = multiIndex;
    }

    public MultiIndex getMultiIndex() {
        return this.multiIndex;
    }

    protected boolean isDirty() {
        return this.dirty;
    }
}

