/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.IdentifierMapAdapter;
import org.apache.sis.internal.jaxb.IdentifierMapEntry;
import org.apache.sis.internal.jaxb.SpecializedIdentifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.ValueConverter;
import org.apache.sis.xml.XLink;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;

public final class ModifiableIdentifierMap
extends IdentifierMapAdapter {
    private static final long serialVersionUID = -80325787192055778L;

    public ModifiableIdentifierMap(Collection<Identifier> collection) {
        super(collection);
    }

    private URI setHRef(URI uRI) {
        Object object;
        URI uRI2 = this.store(IdentifierSpace.HREF, null);
        Identifier identifier = this.getIdentifier(IdentifierSpace.XLINK);
        if (identifier instanceof SpecializedIdentifier && (object = ((SpecializedIdentifier)identifier).value) instanceof XLink) {
            if (uRI2 == null) {
                uRI2 = ((XLink)object).getHRef();
            }
            ((XLink)object).setHRef(uRI);
            return uRI2;
        }
        if (uRI != null) {
            object = new XLink();
            ((XLink)object).setHRef(uRI);
            this.store(IdentifierSpace.XLINK, object);
        }
        return uRI2;
    }

    @Override
    final boolean isModifiable() {
        return true;
    }

    @Override
    public void clear() {
        this.identifiers.clear();
    }

    @Override
    public String remove(Object object) {
        return object instanceof Citation ? this.put((Citation)object, null) : null;
    }

    @Override
    public String put(Citation citation, String string) {
        Context context;
        Object object;
        ArgumentChecks.ensureNonNull((String)"authority", (Object)citation);
        String string2 = null;
        Object object2 = null;
        switch (ModifiableIdentifierMap.specialCase(citation)) {
            case 2: {
                object = null;
                if (string != null) {
                    context = Context.current();
                    ValueConverter valueConverter = Context.converter(context);
                    try {
                        object = valueConverter.toURI((MarshalContext)context, string);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        SpecializedIdentifier.parseFailure(context, string, URI.class, uRISyntaxException);
                        object2 = this.setHRef(null);
                        break;
                    }
                }
                context = this.getIdentifier(citation);
                if ((object = this.setHRef((URI)object)) != null) {
                    string2 = ((URI)object).toString();
                } else if (context != null) {
                    string2 = context.getCode();
                }
                return string2;
            }
        }
        object = this.identifiers.iterator();
        while (object.hasNext()) {
            context = (Identifier)object.next();
            if (context == null) {
                object.remove();
                continue;
            }
            if (!Objects.equals(citation, context.getAuthority())) continue;
            if (string != null && context instanceof IdentifierMapEntry) {
                return ((IdentifierMapEntry)((Object)context)).setValue(string);
            }
            if (string2 == null) {
                string2 = context.getCode();
            }
            object.remove();
        }
        if (string != null) {
            this.identifiers.add(SpecializedIdentifier.parse(citation, string));
        }
        if (string2 == null && object2 != null) {
            string2 = object2.toString();
        }
        return string2;
    }

    @Override
    public <T> T putSpecialized(IdentifierSpace<T> identifierSpace, T t) {
        switch (ModifiableIdentifierMap.specialCase(identifierSpace)) {
            default: {
                return this.store(identifierSpace, t);
            }
            case 2: 
        }
        return (T)this.setHRef((URI)t);
    }

    private <T> T store(IdentifierSpace<T> identifierSpace, T t) {
        ArgumentChecks.ensureNonNull((String)"authority", identifierSpace);
        T t2 = null;
        Iterator iterator = this.identifiers.iterator();
        while (iterator.hasNext()) {
            Identifier identifier = (Identifier)iterator.next();
            if (identifier == null) {
                iterator.remove();
                continue;
            }
            if (!Objects.equals(identifierSpace, identifier.getAuthority())) continue;
            if (identifier instanceof SpecializedIdentifier) {
                SpecializedIdentifier specializedIdentifier = (SpecializedIdentifier)identifier;
                if (t2 == null) {
                    t2 = specializedIdentifier.value;
                }
                if (t != null) {
                    specializedIdentifier.value = t;
                    return t2;
                }
            }
            iterator.remove();
        }
        if (t != null) {
            this.identifiers.add(new SpecializedIdentifier<T>(identifierSpace, t));
        }
        return t2;
    }
}

