/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.table;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.database.DAO;
import org.exoplatform.services.database.DBObject;
import org.exoplatform.services.database.DBObjectMapper;
import org.exoplatform.services.database.DBTableManager;
import org.exoplatform.services.database.ExoDatasource;
import org.exoplatform.services.database.annotation.Table;
import org.exoplatform.services.database.table.ExoLongID;

public class IDGenerator
extends DAO<ExoLongID> {
    private HashMap<Class, IDTracker> idTrackers_ = new HashMap();

    public IDGenerator(ExoDatasource datasource) throws Exception {
        super(datasource, new ExoLongIDMapper());
        DBTableManager tableManager = datasource.getDBTableManager();
        if (tableManager.hasTable(ExoLongID.class)) {
            return;
        }
        tableManager.createTable(ExoLongID.class, true);
    }

    public ExoLongID loadObjectByName(String name) throws Exception {
        Table table = ExoLongID.class.getAnnotation(Table.class);
        StringBuilder builder = new StringBuilder("SELECT EXO_NAME, EXO_START FROM ");
        builder.append(table.name()).append(" WHERE EXO_NAME = '").append(name).append('\'');
        return (ExoLongID)this.loadUnique(builder.toString());
    }

    public <T extends DBObject> long generateLongId(T bean) throws Exception {
        return this.generateLongId(bean.getClass());
    }

    public synchronized <T extends DBObject> long generateLongId(Class<T> type) throws Exception {
        long generatedId;
        IDTracker idTracker = this.idTrackers_.get(type);
        if (idTracker == null) {
            ExoLongID instanceID = this.loadObjectByName(type.getName());
            long currentId = 0L;
            if (instanceID == null) {
                instanceID = new ExoLongID(type.getName(), 3L);
                this.save(instanceID);
            } else {
                currentId = instanceID.getCurrentBlockId();
                instanceID.setNextBlock();
                this.update(instanceID);
            }
            idTracker = new IDTracker(instanceID, currentId);
            this.idTrackers_.put(type, idTracker);
        }
        if ((generatedId = ++idTracker.currentId) > idTracker.blockTracker.getCurrentBlockId() + 3L) {
            idTracker.blockTracker.setNextBlock();
            this.update(idTracker.blockTracker);
        }
        return generatedId;
    }

    public void restartTracker() {
        this.idTrackers_.clear();
    }

    @Override
    public ExoLongID createInstance() throws Exception {
        return new ExoLongID();
    }

    @Override
    public ExoLongID load(long id) throws Exception {
        return null;
    }

    @Override
    public PageList loadAll() throws Exception {
        return null;
    }

    @Override
    public ExoLongID remove(long id) throws Exception {
        return null;
    }

    @Override
    public void remove(ExoLongID bean) throws Exception {
    }

    @Override
    public void save(ExoLongID bean) throws Exception {
    }

    @Override
    public void save(List<ExoLongID> beans) throws Exception {
    }

    @Override
    public void update(ExoLongID bean) throws Exception {
    }

    @Override
    public void update(List<ExoLongID> beans) throws Exception {
    }

    public static class ExoLongIDMapper
    implements DBObjectMapper<ExoLongID> {
        @Override
        public String[][] toParameters(ExoLongID bean) throws Exception {
            return null;
        }

        @Override
        public void mapUpdate(ExoLongID bean, PreparedStatement pstm) throws Exception {
            pstm.setString(1, bean.getName());
            pstm.setLong(2, bean.getCurrentBlockId());
        }

        @Override
        public void mapResultSet(ResultSet res, ExoLongID bean) throws Exception {
            bean.setName(res.getString(1));
            bean.setCurrentBlockId(res.getLong(2));
        }
    }

    private static class IDTracker {
        private ExoLongID blockTracker;
        private long currentId;

        private IDTracker(ExoLongID dbobject, long id) {
            this.blockTracker = dbobject;
            this.currentId = id;
        }
    }
}

