/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.measure.Unit;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.CategoryList;
import org.apache.sis.coverage.SampleRangeFormat;
import org.apache.sis.coverage.ToNaN;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class SampleDimension
implements Serializable {
    private static final long serialVersionUID = -4966135180995819364L;
    private final GenericName name;
    private final Number background;
    private final CategoryList categories;
    private final MathTransform1D transferFunction;
    private final SampleDimension converse;

    private SampleDimension(SampleDimension sampleDimension, Category category) {
        this.converse = sampleDimension;
        this.name = sampleDimension.name;
        this.categories = sampleDimension.categories.converse;
        this.transferFunction = Category.identity();
        this.background = category != null ? (Number)((Number)((Object)category.converse.range.getMinValue())) : (Number)null;
    }

    public SampleDimension(GenericName genericName, Number number, Collection<? extends Category> collection) {
        ArgumentChecks.ensureNonNull((String)"name", (Object)genericName);
        ArgumentChecks.ensureNonNull((String)"categories", collection);
        CategoryList categoryList = collection.isEmpty() ? CategoryList.EMPTY : CategoryList.create(collection.toArray(new Category[collection.size()]), number);
        this.name = genericName;
        this.background = number;
        this.categories = categoryList;
        if (categoryList.converse.range == null) {
            this.transferFunction = null;
            this.converse = null;
        } else if (categoryList == categoryList.converse) {
            this.transferFunction = Category.identity();
            this.converse = this;
        } else {
            assert (!categoryList.isEmpty());
            this.transferFunction = categoryList.getTransferFunction();
            this.converse = new SampleDimension(this, number != null ? categoryList.search(number.doubleValue()) : null);
        }
    }

    private SampleDimension converted() {
        return this.converse != null && !this.transferFunction.isIdentity() ? this.converse : this;
    }

    public GenericName getName() {
        return this.name;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public Optional<Number> getBackground() {
        return Optional.ofNullable(this.background);
    }

    public Set<Number> getNoDataValues() {
        if (this.converse != null) {
            Object object;
            Category category;
            boolean bl = this.transferFunction.isIdentity();
            NumberRange[] numberRangeArray = new NumberRange[this.categories.size()];
            Class clazz = Byte.class;
            int n = 0;
            for (Category category2 : this.categories) {
                category = category2.converted();
                if (!bl && category2 == category || !category.isConvertedQualitative()) continue;
                object = category2.range;
                if (!object.isBounded()) {
                    throw new IllegalStateException(Resources.format((short)6, object));
                }
                clazz = Numbers.widestClass(clazz, (Class)object.getElementType());
                numberRangeArray[n++] = object;
            }
            if (n != 0) {
                TreeSet treeSet = new TreeSet(SampleDimension::compare);
                for (int i = 0; i < n; ++i) {
                    category = numberRangeArray[i];
                    object = (Number)((Object)category.getMinValue());
                    Number number = (Number)((Object)category.getMaxValue());
                    if (category.isMinIncluded()) {
                        treeSet.add(Numbers.cast(object, (Class)clazz));
                    }
                    if (category.isMaxIncluded()) {
                        treeSet.add(Numbers.cast((Number)number, (Class)clazz));
                    }
                    if (Numbers.isInteger((Class)category.getElementType())) {
                        long l = ((Number)object).longValue() + 1L;
                        long l2 = number.longValue() - 1L;
                        while (l <= l2) {
                            treeSet.add(Numbers.wrap((long)l, (Class)clazz));
                        }
                        continue;
                    }
                    if (object.equals(number)) continue;
                    throw new IllegalStateException(Resources.format((short)6, category));
                }
                return treeSet;
            }
        }
        return Collections.emptySet();
    }

    private static int compare(Number number, Number number2) {
        return Category.compare(number.doubleValue(), number2.doubleValue());
    }

    public Optional<NumberRange<?>> getSampleRange() {
        return Optional.ofNullable(this.categories.range);
    }

    public Optional<MeasurementRange<?>> getMeasurementRange() {
        if (this.converse == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((MeasurementRange)this.converted().categories.range);
    }

    public Optional<MathTransform1D> getTransferFunction() {
        return Optional.ofNullable(this.transferFunction);
    }

    public Optional<TransferFunction> getTransferFunctionFormula() {
        MathTransform1D mathTransform1D = null;
        for (Category category : this.categories) {
            Optional<MathTransform1D> optional = category.getTransferFunction();
            if (!optional.isPresent()) continue;
            if (mathTransform1D == null) {
                mathTransform1D = optional.get();
                continue;
            }
            if (mathTransform1D.equals((Object)optional.get())) continue;
            throw new IllegalStateException(Resources.format((short)13));
        }
        if (mathTransform1D == null) {
            return Optional.empty();
        }
        TransferFunction transferFunction = new TransferFunction();
        try {
            transferFunction.setTransform(mathTransform1D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(Resources.format((short)13, illegalArgumentException));
        }
        return Optional.of(transferFunction);
    }

    public Optional<Unit<?>> getUnits() {
        Unit unit = null;
        for (Category category : this.converted().categories) {
            Unit unit2;
            NumberRange<?> numberRange = category.range;
            if (!(numberRange instanceof MeasurementRange) || (unit2 = ((MeasurementRange)numberRange).unit()) == null) continue;
            if (unit == null) {
                unit = unit2;
                continue;
            }
            if (unit.equals((Object)unit2)) continue;
            throw new IllegalStateException();
        }
        return Optional.ofNullable(unit);
    }

    public boolean allowsNaN() {
        return this.categories.allowsNaN();
    }

    public SampleDimension forConvertedValues(boolean bl) {
        if (this.converse != null && this.transferFunction.isIdentity() != bl) {
            return this.converse;
        }
        return this;
    }

    public int hashCode() {
        return this.categories.hashCode() + 31 * this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SampleDimension) {
            SampleDimension sampleDimension = (SampleDimension)object;
            return this.name.equals((Object)sampleDimension.name) && Objects.equals(this.background, sampleDimension.background) && this.categories.equals(sampleDimension.categories);
        }
        return false;
    }

    public String toString() {
        return new SampleRangeFormat(Locale.getDefault()).write(new SampleDimension[]{this});
    }

    public static String toString(Locale locale, SampleDimension ... sampleDimensionArray) {
        ArgumentChecks.ensureNonNull((String)"dimensions", (Object)sampleDimensionArray);
        return new SampleRangeFormat(locale).write(sampleDimensionArray);
    }

    public static class Builder {
        private static final InternationalString DATA = Vocabulary.formatInternational((short)47);
        private static final InternationalString NODATA = Vocabulary.formatInternational((short)140);
        private static final InternationalString FILL_VALUE = Vocabulary.formatInternational((short)83);
        private GenericName dimensionName;
        private Category[] categories = new Category[10];
        private int count;
        private final ToNaN toNaN = new ToNaN();

        public GenericName getName() {
            return this.dimensionName;
        }

        public Builder setName(GenericName genericName) {
            this.dimensionName = genericName;
            return this;
        }

        public Builder setName(CharSequence charSequence) {
            return this.setName(Builder.createLocalName(charSequence));
        }

        public Builder setName(int n) {
            return this.setName((GenericName)Names.createMemberName(null, null, (int)n));
        }

        private static GenericName createLocalName(CharSequence charSequence) {
            return Names.createLocalName(null, null, (CharSequence)charSequence);
        }

        private static NumberRange<?> range(Class<?> clazz, Number number, Number number2) {
            switch (Numbers.getEnumConstant(clazz)) {
                case 3: {
                    return NumberRange.create((byte)number.byteValue(), (boolean)true, (byte)number2.byteValue(), (boolean)true);
                }
                case 4: {
                    return NumberRange.create((short)number.shortValue(), (boolean)true, (short)number2.shortValue(), (boolean)true);
                }
                case 5: {
                    return NumberRange.create((int)number.intValue(), (boolean)true, (int)number2.intValue(), (boolean)true);
                }
                case 6: {
                    return NumberRange.create((long)number.longValue(), (boolean)true, (long)number2.longValue(), (boolean)true);
                }
                case 8: {
                    float f = number.floatValue();
                    float f2 = number2.floatValue();
                    if (!Float.isNaN(f) || !Float.isNaN(f2)) {
                        return NumberRange.create((float)f, (boolean)true, (float)f2, (boolean)true);
                    }
                    if (number.getClass() != Float.class) {
                        number = Float.valueOf(f);
                    }
                    if (number2.getClass() == Float.class) break;
                    number2 = Float.valueOf(f2);
                    break;
                }
                default: {
                    double d = number.doubleValue();
                    double d2 = number2.doubleValue();
                    if (!Double.isNaN(d) || !Double.isNaN(d2)) {
                        return NumberRange.create((double)d, (boolean)true, (double)d2, (boolean)true);
                    }
                    if (number.getClass() != Double.class) {
                        number = d;
                    }
                    if (number2.getClass() == Double.class) break;
                    number2 = d2;
                    break;
                }
            }
            NumberRange numberRange = new NumberRange(clazz, number, true, number2, true);
            return numberRange;
        }

        public Number getBackground() {
            return this.toNaN.background;
        }

        public Builder setBackground(Number number) {
            this.toNaN.background = number;
            return this;
        }

        public Builder setBackground(CharSequence charSequence, Number number) {
            ArgumentChecks.ensureNonNull((String)"sample", (Object)number);
            if (charSequence == null) {
                charSequence = FILL_VALUE;
            }
            NumberRange<?> numberRange = Builder.range(number.getClass(), number, number);
            this.toNaN.background = (Number)((Object)numberRange.getMinValue());
            this.add(new Category(charSequence, numberRange, null, null, this.toNaN));
            return this;
        }

        public Builder addQualitative(CharSequence charSequence, boolean bl) {
            byte by = bl ? (byte)1 : 0;
            return this.addQualitative(charSequence, NumberRange.create((byte)by, (boolean)true, (byte)by, (boolean)true));
        }

        public Builder addQualitative(CharSequence charSequence, byte by) {
            return this.addQualitative(charSequence, NumberRange.create((byte)by, (boolean)true, (byte)by, (boolean)true));
        }

        public Builder addQualitative(CharSequence charSequence, short s) {
            return this.addQualitative(charSequence, NumberRange.create((short)s, (boolean)true, (short)s, (boolean)true));
        }

        public Builder addQualitative(CharSequence charSequence, int n) {
            return this.addQualitative(charSequence, NumberRange.create((int)n, (boolean)true, (int)n, (boolean)true));
        }

        public Builder addQualitative(CharSequence charSequence, float f) {
            NumberRange numberRange;
            if (Float.isNaN(f)) {
                Float f2 = Float.valueOf(f);
                numberRange = new NumberRange(Float.class, (Number)f2, true, (Number)f2, true);
            } else {
                numberRange = NumberRange.create((float)f, (boolean)true, (float)f, (boolean)true);
            }
            return this.addQualitative(charSequence, numberRange);
        }

        public Builder addQualitative(CharSequence charSequence, double d) {
            NumberRange numberRange;
            if (Double.isNaN(d)) {
                Double d2 = d;
                numberRange = new NumberRange(Double.class, (Number)d2, true, (Number)d2, true);
            } else {
                numberRange = NumberRange.create((double)d, (boolean)true, (double)d, (boolean)true);
            }
            return this.addQualitative(charSequence, numberRange);
        }

        public Builder addQualitative(CharSequence charSequence, Number number, Number number2) {
            ArgumentChecks.ensureNonNull((String)"minimum", (Object)number);
            ArgumentChecks.ensureNonNull((String)"maximum", (Object)number2);
            return this.addQualitative(charSequence, Builder.range(Numbers.widestClass((Number)number, (Number)number2), number, number2));
        }

        public Builder addQualitative(CharSequence charSequence, NumberRange<?> numberRange) {
            if (charSequence == null) {
                charSequence = NODATA;
            }
            this.add(new Category(charSequence, numberRange, null, null, this.toNaN));
            return this;
        }

        public Builder mapQualitative(CharSequence charSequence, Number number, float f) {
            ArgumentChecks.ensureNonNull((String)"sample", (Object)number);
            return this.mapQualitative(charSequence, Builder.range(number.getClass(), number, number), f);
        }

        public Builder mapQualitative(CharSequence charSequence, NumberRange<?> numberRange, float f) {
            ArgumentChecks.ensureNonNull((String)"samples", numberRange);
            int n = MathFunctions.toNanOrdinal((float)f);
            if (!this.toNaN.add(n)) {
                throw new IllegalArgumentException(Errors.format((short)164, (Object)("NaN #" + n)));
            }
            if (charSequence == null) {
                charSequence = NODATA;
            }
            this.add(new Category(charSequence, numberRange, null, null, d -> n));
            return this;
        }

        public Builder addQuantitative(CharSequence charSequence, NumberRange<?> numberRange, NumberRange<?> numberRange2) {
            ArgumentChecks.ensureNonNull((String)"samples", numberRange);
            ArgumentChecks.ensureNonNull((String)"converted", numberRange2);
            boolean bl = numberRange.isMinIncluded();
            boolean bl2 = numberRange.isMaxIncluded() && numberRange.getSpan() > 0.0;
            double d = numberRange2.getMinDouble(bl);
            double d2 = numberRange2.getMaxDouble(bl2) - d;
            double d3 = numberRange.getMinDouble(bl);
            double d4 = numberRange.getMaxDouble(bl2) - d3;
            double d5 = d2 / d4;
            TransferFunction transferFunction = new TransferFunction();
            transferFunction.setScale(d5);
            transferFunction.setOffset(d - d5 * d3);
            return this.addQuantitative(charSequence, numberRange, transferFunction.getTransform(), numberRange2 instanceof MeasurementRange ? ((MeasurementRange)numberRange2).unit() : null);
        }

        public Builder addQuantitative(CharSequence charSequence, float f, float f2, Unit<?> unit) {
            return this.addQuantitative(charSequence, (NumberRange<?>)MeasurementRange.create((float)f, (boolean)true, (float)f2, (boolean)true, unit), Category.identity(), unit);
        }

        public Builder addQuantitative(CharSequence charSequence, double d, double d2, Unit<?> unit) {
            return this.addQuantitative(charSequence, (NumberRange<?>)MeasurementRange.create((double)d, (boolean)true, (double)d2, (boolean)true, unit), Category.identity(), unit);
        }

        public Builder addQuantitative(CharSequence charSequence, int n, int n2, double d, double d2, Unit<?> unit) {
            TransferFunction transferFunction = new TransferFunction();
            transferFunction.setScale(d);
            transferFunction.setOffset(d2);
            return this.addQuantitative(charSequence, NumberRange.create((int)n, (boolean)true, (int)n2, (boolean)false), transferFunction.getTransform(), unit);
        }

        public Builder addQuantitative(CharSequence charSequence, NumberRange<?> numberRange, MathTransform1D mathTransform1D, Unit<?> unit) {
            ArgumentChecks.ensureNonNull((String)"toUnits", (Object)mathTransform1D);
            if (charSequence == null) {
                charSequence = DATA;
            }
            this.add(new Category(charSequence, numberRange, mathTransform1D, unit, this.toNaN));
            return this;
        }

        private void add(Category category) {
            if (this.count == this.categories.length) {
                this.categories = Arrays.copyOf(this.categories, this.count * 2);
            }
            this.categories[this.count++] = category;
        }

        public List<Category> categories() {
            return new AbstractList<Category>(){

                @Override
                public int size() {
                    return count;
                }

                @Override
                public Category get(int n) {
                    ArgumentChecks.ensureValidIndex((int)count, (int)n);
                    return categories[n];
                }

                @Override
                public Category remove(int n) {
                    ArgumentChecks.ensureValidIndex((int)count, (int)n);
                    Category category = categories[n];
                    System.arraycopy(categories, n + 1, categories, n, --count - n);
                    ((Builder)this).categories[((Builder)this).count] = null;
                    toNaN.remove(category);
                    return category;
                }
            };
        }

        public SampleDimension build() {
            GenericName genericName;
            block2: {
                genericName = this.dimensionName;
                if (genericName == null) {
                    for (int i = 0; i < this.count; ++i) {
                        if (!this.categories[i].isQuantitative()) continue;
                        genericName = Builder.createLocalName((CharSequence)this.categories[i].name);
                        break block2;
                    }
                    genericName = Builder.createLocalName((CharSequence)Vocabulary.formatInternational((short)210));
                }
            }
            return new SampleDimension(genericName, this.toNaN.background, (Collection<? extends Category>)UnmodifiableArrayList.wrap((Object[])this.categories, (int)0, (int)this.count));
        }

        public void clear() {
            this.dimensionName = null;
            this.count = 0;
            Arrays.fill(this.categories, null);
            this.toNaN.clear();
        }
    }
}

