/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.chain.Chain;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainBase<C extends Context>
implements Chain<C> {
    private Command<C>[] commands;
    private boolean frozen = false;

    public ChainBase() {
        this(Collections.emptyList());
    }

    public ChainBase(Command<C> command) {
        this(Collections.singletonList(command));
    }

    public ChainBase(Command<C>[] commands) {
        this(Arrays.asList(commands));
    }

    public ChainBase(Collection<Command<C>> commands) {
        if (commands == null) {
            throw new IllegalArgumentException();
        }
        Command[] cmds = commands.toArray(new Command[0]);
        this.commands = cmds;
    }

    @Override
    public <CMD extends Command<C>> void addCommand(CMD command) {
        if (command == null) {
            throw new IllegalArgumentException();
        }
        if (this.frozen) {
            throw new IllegalStateException();
        }
        int len = this.commands.length;
        this.commands = Arrays.copyOf(this.commands, len + 1);
        this.commands[len] = command;
    }

    @Override
    public boolean execute(C context) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.frozen = true;
        boolean saveResult = false;
        Exception saveException = null;
        int i = 0;
        int n = this.commands.length;
        for (i = 0; i < n; ++i) {
            try {
                saveResult = this.commands[i].execute(context);
                if (!saveResult) continue;
            }
            catch (Exception e) {
                saveException = e;
            }
            break;
        }
        if (i >= n) {
            --i;
        }
        boolean handled = false;
        boolean result = false;
        for (int j = i; j >= 0; --j) {
            Command<C> command = this.commands[j];
            if (!(command instanceof Filter)) continue;
            try {
                result = ((Filter)command).postprocess(context, saveException);
                if (!result) continue;
                handled = true;
                continue;
            }
            catch (Exception e) {
                Logger logger = LoggerFactory.getLogger(ChainBase.class);
                logger.trace("Filter-postprocessing", (Throwable)e);
            }
        }
        if (saveException != null && !handled) {
            throw saveException;
        }
        return saveResult;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    Command<C>[] getCommands() {
        return this.commands;
    }
}

