/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.Statistics;
import org.apache.sis.math.StatisticsFormat;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.operation.builder.LinearTransformBuilder;
import org.apache.sis.referencing.operation.builder.LocalizationGridException;
import org.apache.sis.referencing.operation.builder.ProjectedTransformTry;
import org.apache.sis.referencing.operation.builder.ResidualGrid;
import org.apache.sis.referencing.operation.builder.TransformBuilder;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.InterpolatedTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class LocalizationGridBuilder
extends TransformBuilder {
    private static final double EPS = 1.0E-13;
    private final LinearTransformBuilder linearBuilder;
    private final int[] gridCoordinates = new int[2];
    private LinearTransform sourceToGrid;
    private double precision;
    private static final double DEFAULT_PRECISION = 1.0E-7;
    private MathTransform transform;
    private double[] periods;

    public LocalizationGridBuilder(int n, int n2) {
        this.linearBuilder = new LinearTransformBuilder(n, n2);
        this.sourceToGrid = MathTransforms.identity(2);
    }

    public LocalizationGridBuilder(Vector vector, Vector vector2) {
        Matrix3 matrix3 = new Matrix3();
        int n = LocalizationGridBuilder.infer(vector, matrix3, 0);
        int n2 = LocalizationGridBuilder.infer(vector2, matrix3, 1);
        this.linearBuilder = new LinearTransformBuilder(n, n2);
        try {
            this.sourceToGrid = MathTransforms.linear(matrix3).inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw (ArithmeticException)new ArithmeticException(noninvertibleTransformException.getLocalizedMessage()).initCause(noninvertibleTransformException);
        }
    }

    public LocalizationGridBuilder(LinearTransformBuilder linearTransformBuilder) {
        ArgumentChecks.ensureNonNull((String)"localizations", (Object)linearTransformBuilder);
        int n = linearTransformBuilder.getGridDimensions();
        if (n != 2) {
            Vector[] vectorArray;
            if (n < 0 && (n = (vectorArray = linearTransformBuilder.sources()).length) == 2) {
                Matrix3 matrix3 = new Matrix3();
                int n2 = LocalizationGridBuilder.infer(vectorArray[0], matrix3, 0);
                int n3 = LocalizationGridBuilder.infer(vectorArray[1], matrix3, 1);
                this.linearBuilder = new LinearTransformBuilder(n2, n3);
                this.linearBuilder.setControlPoints(linearTransformBuilder.getControlPoints());
                try {
                    this.sourceToGrid = MathTransforms.linear(matrix3).inverse();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    throw (ArithmeticException)new ArithmeticException(noninvertibleTransformException.getLocalizedMessage()).initCause(noninvertibleTransformException);
                }
                this.linearBuilder.setLinearizers(linearTransformBuilder);
                return;
            }
            throw new IllegalArgumentException(Errors.format((short)190, (Object)"localizations", (Object)0, (Object)2, (Object)n));
        }
        this.linearBuilder = linearTransformBuilder;
        this.sourceToGrid = MathTransforms.identity(2);
    }

    private static int infer(Vector vector, Matrix matrix, int n) {
        double d;
        NumberRange numberRange = vector.range();
        double d2 = numberRange.getMinDouble(true);
        double d3 = numberRange.getSpan();
        Number number = vector.increment(1.0E-13 * d3);
        if (number != null) {
            d = number.doubleValue();
        } else {
            d = d3;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                double d4;
                double d5 = vector.doubleValue(i) - d2;
                if (!(Math.abs(d5 % d) > 1.0E-13)) continue;
                do {
                    d4 = d % d5;
                    d = d5;
                } while (Math.abs(d5 = d4) > 1.0E-13);
            }
        }
        matrix.setElement(n, n, d);
        matrix.setElement(n, 2, d2);
        double d6 = d3 / d;
        if (d6 >= 0.5 && d6 < (double)vector.size() - 0.5) {
            return (int)Math.round(d6) + 1;
        }
        throw new ArithmeticException(Resources.format((short)75, numberRange));
    }

    private void ensureModifiable() throws IllegalStateException {
        if (!this.linearBuilder.isModifiable()) {
            throw new IllegalStateException(Errors.format((short)153, LocalizationGridBuilder.class));
        }
    }

    public void setDesiredPrecision(double d) {
        this.ensureModifiable();
        ArgumentChecks.ensureStrictlyPositive((String)"precision", (double)d);
        this.precision = d;
    }

    public double getDesiredPrecision() {
        return this.precision;
    }

    public void setSourceToGrid(LinearTransform linearTransform) {
        this.ensureModifiable();
        ArgumentChecks.ensureNonNull((String)"sourceToGrid", (Object)linearTransform);
        int n = 0;
        int n2 = linearTransform.getSourceDimensions();
        if (n2 >= 2) {
            n = 1;
            n2 = linearTransform.getTargetDimensions();
            if (n2 == 2) {
                this.sourceToGrid = linearTransform;
                return;
            }
        }
        throw new MismatchedDimensionException(Errors.format((short)190, (Object)"sourceToGrid", (Object)n, (Object)2, (Object)n2));
    }

    public LinearTransform getSourceToGrid() {
        return this.sourceToGrid;
    }

    public Envelope getSourceEnvelope(boolean bl) throws TransformException {
        Envelope envelope = this.linearBuilder.getSourceEnvelope();
        if (bl) {
            int n = envelope.getDimension();
            while (--n >= 0) {
                GeneralEnvelope generalEnvelope = GeneralEnvelope.castOrCopy(envelope);
                generalEnvelope.setRange(n, generalEnvelope.getLower(n) - 0.5, generalEnvelope.getUpper(n) + 0.5);
                envelope = generalEnvelope;
            }
        }
        return Envelopes.transform(this.sourceToGrid.inverse(), envelope);
    }

    public void setControlPoints(Vector ... vectorArray) {
        this.ensureModifiable();
        ArgumentChecks.ensureNonNull((String)"coordinates", (Object)vectorArray);
        this.linearBuilder.setControlPoints(vectorArray);
    }

    public void setControlPoint(int n, int n2, double ... dArray) {
        this.ensureModifiable();
        this.gridCoordinates[0] = n;
        this.gridCoordinates[1] = n2;
        this.linearBuilder.setControlPoint(this.gridCoordinates, dArray);
    }

    public double[] getControlPoint(int n, int n2) {
        this.gridCoordinates[0] = n;
        this.gridCoordinates[1] = n2;
        return this.linearBuilder.getControlPoint(this.gridCoordinates);
    }

    public Vector getRow(int n, int n2) {
        this.gridCoordinates[0] = 0;
        this.gridCoordinates[1] = n2;
        return this.linearBuilder.getTransect(n, this.gridCoordinates, 0);
    }

    public Vector getColumn(int n, int n2) {
        this.gridCoordinates[0] = n2;
        this.gridCoordinates[1] = 0;
        return this.linearBuilder.getTransect(n, this.gridCoordinates, 1);
    }

    public NumberRange<Double> resolveWraparoundAxis(int n, int n2, double d) {
        this.ensureModifiable();
        ArgumentChecks.ensureBetween((String)"dimension", (int)0, (int)(this.linearBuilder.getTargetDimensions() - 1), (int)n);
        ArgumentChecks.ensureBetween((String)"direction", (int)0, (int)(this.linearBuilder.getSourceDimensions() - 1), (int)n2);
        ArgumentChecks.ensureStrictlyPositive((String)"period", (double)d);
        if (this.periods == null) {
            this.periods = new double[this.linearBuilder.getTargetDimensions()];
        }
        if (this.periods[n] != 0.0) {
            throw new IllegalStateException(Errors.format((short)164, (Object)Strings.bracket((String)"periods", (Object)n)));
        }
        this.periods[n] = d;
        return this.linearBuilder.resolveWraparoundAxis(n, n2, d);
    }

    public void addLinearizers(Map<String, MathTransform> map, boolean bl, int ... nArray) {
        ArgumentChecks.ensureNonNull((String)"projections", map);
        this.ensureModifiable();
        this.linearBuilder.addLinearizers(map, bl, nArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MathTransform create(MathTransformFactory mathTransformFactory) throws FactoryException {
        if (this.transform == null) {
            void var5_12;
            LinearTransform linearTransform = this.linearBuilder.create(mathTransformFactory);
            boolean bl = true;
            boolean bl2 = true;
            for (double d : this.linearBuilder.correlation()) {
                bl &= d == 1.0;
                if (d >= 0.9999) continue;
                bl2 = false;
                break;
            }
            if (bl) {
                MathTransform mathTransform = MathTransforms.concatenate(this.sourceToGrid, linearTransform);
            } else {
                int n = this.linearBuilder.gridSize(0);
                int n2 = this.linearBuilder.gridSize(1);
                float[] fArray = new float[2 * this.linearBuilder.gridLength];
                double[] dArray = new double[2 * n];
                double d = this.precision;
                try {
                    double d2;
                    int n3;
                    Object object;
                    if (d > 0.0 && !this.sourceToGrid.isIdentity()) {
                        object = new double[this.sourceToGrid.getSourceDimensions()];
                        double[] dArray2 = new double[this.sourceToGrid.getTargetDimensions()];
                        double d3 = 0.0;
                        for (n3 = 0; n3 < ((Object)object).length; ++n3) {
                            object[n3] = this.precision;
                            this.sourceToGrid.deltaTransform((double[])object, 0, dArray2, 0, 1);
                            d2 = MathFunctions.magnitude((double[])dArray2);
                            if (d2 > d3) {
                                d3 = d2;
                            }
                            object[n3] = 0.0;
                        }
                        d = d3;
                    }
                    object = linearTransform.inverse();
                    int n4 = 0;
                    for (int i = 0; i < n2; ++i) {
                        this.gridCoordinates[0] = 0;
                        this.gridCoordinates[1] = i;
                        this.linearBuilder.getControlRow(this.gridCoordinates, dArray);
                        object.transform(dArray, 0, dArray, 0, n);
                        int n5 = 0;
                        for (n3 = 0; n3 < n; ++n3) {
                            d2 = dArray[n5++] - (double)n3;
                            double d4 = dArray[n5++] - (double)i;
                            bl2 &= d2 <= d;
                            bl2 &= d4 <= d;
                            fArray[n4++] = (float)d2;
                            fArray[n4++] = (float)d4;
                        }
                    }
                    if (bl2) {
                        MathTransform mathTransform = MathTransforms.concatenate(this.sourceToGrid, linearTransform);
                    } else {
                        ResidualGrid residualGrid = new ResidualGrid(this.sourceToGrid, linearTransform, n, n2, fArray, d > 0.0 ? d : 1.0E-7, this.periods, this.linearBuilder.appliedLinearizer());
                        MathTransform mathTransform = InterpolatedTransform.createGeodeticTransformation(LocalizationGridBuilder.nonNull(mathTransformFactory), residualGrid);
                    }
                }
                catch (TransformException transformException) {
                    throw new LocalizationGridException(transformException);
                }
            }
            ProjectedTransformTry projectedTransformTry = this.linearBuilder.appliedLinearizer();
            if (projectedTransformTry != null && projectedTransformTry.reverseAfterLinearization) {
                try {
                    void var5_10;
                    MathTransform mathTransform = mathTransformFactory.createConcatenatedTransform((MathTransform)var5_10, projectedTransformTry.getValue().inverse());
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    throw new InvalidGeodeticParameterException(Resources.format((short)52, projectedTransformTry.getKey()), noninvertibleTransformException);
                }
            }
            this.transform = var5_12;
        }
        return this.transform;
    }

    public Optional<Map.Entry<String, MathTransform>> linearizer(boolean bl) {
        ProjectedTransformTry projectedTransformTry = this.linearBuilder.appliedLinearizer();
        if (bl && projectedTransformTry != null && projectedTransformTry.reverseAfterLinearization) {
            projectedTransformTry = null;
        }
        return Optional.ofNullable(projectedTransformTry);
    }

    public Statistics[] errors(boolean bl) {
        MathTransform mathTransform;
        MathTransform mathTransform2;
        MathTransform mathTransform3;
        MathTransform mathTransform4 = mathTransform3 = bl ? this.linearBuilder.transform() : this.transform;
        if (mathTransform3 == null) {
            throw new IllegalStateException(Errors.format((short)189, (Object)this.getClass().getSimpleName()));
        }
        int n = mathTransform3.getTargetDimensions();
        double[] dArray = new double[Math.max(n, 2)];
        Statistics[] statisticsArray = new Statistics[n + 2];
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < statisticsArray.length; ++i) {
            stringBuilder.setLength(0);
            stringBuilder.append('\u0394');
            if (i < n) {
                if (i < 3) {
                    stringBuilder.append((char)(120 + i));
                } else {
                    stringBuilder.append('z').append(i - 1);
                }
            } else {
                stringBuilder.append((char)(105 + (i - n)));
            }
            statisticsArray[i] = new Statistics((CharSequence)stringBuilder.toString());
        }
        try {
            ProjectedTransformTry projectedTransformTry = this.linearBuilder.appliedLinearizer();
            mathTransform2 = projectedTransformTry != null && projectedTransformTry.reverseAfterLinearization ? projectedTransformTry.getValue().inverse() : null;
            mathTransform = mathTransform3.inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new IllegalStateException(noninvertibleTransformException);
        }
        int n2 = this.linearBuilder.gridSize(0);
        int n3 = this.linearBuilder.gridSize(1);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n4;
                double[] dArray2;
                block16: {
                    this.gridCoordinates[0] = j;
                    dArray[0] = this.gridCoordinates[0];
                    this.gridCoordinates[1] = i;
                    dArray[1] = this.gridCoordinates[1];
                    try {
                        mathTransform3.transform(dArray, 0, dArray, 0, 1);
                        dArray2 = this.linearBuilder.getControlPoint(this.gridCoordinates);
                        if (mathTransform2 == null) break block16;
                        mathTransform2.transform(dArray2, 0, dArray2, 0, 1);
                    }
                    catch (TransformException transformException) {
                        continue;
                    }
                }
                for (n4 = 0; n4 < n; ++n4) {
                    statisticsArray[n4].accept(dArray[n4] - dArray2[n4]);
                }
                try {
                    mathTransform.transform(dArray2, 0, dArray2, 0, 1);
                }
                catch (TransformException transformException) {
                    continue;
                }
                for (n4 = 0; n4 < 2; ++n4) {
                    statisticsArray[n + n4].accept(dArray2[n4] - (double)this.gridCoordinates[n4]);
                }
            }
        }
        return statisticsArray;
    }

    public String toString(boolean bl, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder(400);
        String string = null;
        try {
            string = this.linearBuilder.appendTo(stringBuilder, this.getClass(), locale, (short)116);
            if (this.transform != null) {
                stringBuilder.append("\u25b6\u00a0");
                Vocabulary vocabulary = Vocabulary.getResources((Locale)locale);
                vocabulary.appendLabel((short)80, (Appendable)stringBuilder);
                stringBuilder.append(string);
                StatisticsFormat statisticsFormat = locale != null ? StatisticsFormat.getInstance((Locale)locale) : StatisticsFormat.getInstance();
                statisticsFormat.format(this.errors(bl), (Appendable)stringBuilder);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Strings.insertLineInLeftMargin((StringBuilder)stringBuilder, string);
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toString(false, null);
    }
}

