/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.acl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.webdav.util.PropertyConstants;
import org.exoplatform.services.security.IdentityConstants;

public class ACLProperties {
    public static final QName ACL = new QName("DAV:", "acl");
    public static final QName ACE = new QName("DAV:", "ace");
    public static final QName PRINCIPAL = new QName("DAV:", "principal");
    public static final QName ALL = new QName("DAV:", "all");
    public static final QName HREF = new QName("DAV:", "href");
    public static final QName PRIVILEGE = new QName("DAV:", "privilege");
    public static final QName GRANT = new QName("DAV:", "grant");
    public static final QName DENY = new QName("DAV:", "deny");
    public static final QName WRITE = new QName("DAV:", "write");
    public static final QName READ = new QName("DAV:", "read");

    public static HierarchicalProperty getACL(NodeImpl node) throws RepositoryException {
        HierarchicalProperty property = new HierarchicalProperty(ACL);
        AccessControlList acl = node.getACL();
        HashMap<String, ArrayList<String>> principals = new HashMap<String, ArrayList<String>>();
        List entryList = acl.getPermissionEntries();
        for (AccessControlEntry entry : entryList) {
            String principal = entry.getIdentity();
            String grant = entry.getPermission();
            ArrayList<String> grantList = (ArrayList<String>)principals.get(principal);
            if (grantList == null) {
                grantList = new ArrayList<String>();
                principals.put(principal, grantList);
            }
            grantList.add(grant);
        }
        Iterator principalIter = principals.keySet().iterator();
        while (principalIter.hasNext()) {
            HierarchicalProperty aceProperty = new HierarchicalProperty(ACE);
            String curPrincipal = (String)principalIter.next();
            aceProperty.addChild(ACLProperties.getPrincipalProperty(curPrincipal));
            aceProperty.addChild(ACLProperties.getGrantProperty((List)principals.get(curPrincipal)));
            property.addChild(aceProperty);
        }
        return property;
    }

    public static HierarchicalProperty getOwner(NodeImpl node) throws RepositoryException {
        HierarchicalProperty ownerProperty = new HierarchicalProperty(PropertyConstants.OWNER);
        HierarchicalProperty href = new HierarchicalProperty(new QName("DAV:", "href"));
        href.setValue(node.getACL().getOwner());
        ownerProperty.addChild(href);
        return ownerProperty;
    }

    private static HierarchicalProperty getPrincipalProperty(String principal) {
        HierarchicalProperty principalProperty = new HierarchicalProperty(PRINCIPAL);
        if (IdentityConstants.ANY.equals(principal)) {
            HierarchicalProperty all = new HierarchicalProperty(ALL);
            principalProperty.addChild(all);
        } else {
            HierarchicalProperty href = new HierarchicalProperty(HREF);
            href.setValue(principal);
            principalProperty.addChild(href);
        }
        return principalProperty;
    }

    private static HierarchicalProperty getGrantProperty(List<String> grantList) {
        HierarchicalProperty privilege;
        HierarchicalProperty grant = new HierarchicalProperty(GRANT);
        if (grantList.contains("add_node") || grantList.contains("set_property") || grantList.contains("remove")) {
            privilege = new HierarchicalProperty(PRIVILEGE);
            privilege.addChild(new HierarchicalProperty(WRITE));
            grant.addChild(privilege);
        }
        if (grantList.contains("read")) {
            privilege = new HierarchicalProperty(PRIVILEGE);
            privilege.addChild(new HierarchicalProperty(READ));
            grant.addChild(privilege);
        }
        return grant;
    }
}

