/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.util;

public class StringNumberParser {
    public static long parseLong(String longText) throws NumberFormatException {
        return StringNumberParser.parseNumber(longText).longValue();
    }

    public static String serializeLong(long longValue) throws NumberFormatException {
        return StringNumberParser.serializeNumber(longValue);
    }

    public static int parseInt(String integerText) throws NumberFormatException {
        return StringNumberParser.parseNumber(integerText).intValue();
    }

    public static String serializeInt(int integerValue) throws NumberFormatException {
        return StringNumberParser.serializeNumber(integerValue);
    }

    public static double parseDouble(String doubleText) throws NumberFormatException {
        return StringNumberParser.parseNumber(doubleText).doubleValue();
    }

    public static Number parseNumber(String numberText) throws NumberFormatException {
        String text = numberText.toLowerCase().toUpperCase();
        if (text.endsWith("K")) {
            return Double.valueOf(text.substring(0, text.length() - 1)) * 1024.0;
        }
        if (text.endsWith("KB")) {
            return Double.valueOf(text.substring(0, text.length() - 2)) * 1024.0;
        }
        if (text.endsWith("M")) {
            return Double.valueOf(text.substring(0, text.length() - 1)) * 1048576.0;
        }
        if (text.endsWith("MB")) {
            return Double.valueOf(text.substring(0, text.length() - 2)) * 1048576.0;
        }
        if (text.endsWith("G")) {
            return Double.valueOf(text.substring(0, text.length() - 1)) * 1.073741824E9;
        }
        if (text.endsWith("GB")) {
            return Double.valueOf(text.substring(0, text.length() - 2)) * 1.073741824E9;
        }
        if (text.endsWith("T")) {
            return Double.valueOf(text.substring(0, text.length() - 1)) * 1.099511627776E12;
        }
        if (text.endsWith("TB")) {
            return Double.valueOf(text.substring(0, text.length() - 2)) * 1.099511627776E12;
        }
        return Double.valueOf(text);
    }

    public static String serializeNumber(long number) throws NumberFormatException {
        if (number >= 0x10000000000L && number % 0x10000000000L == 0L) {
            return String.valueOf(number / 0x10000000000L) + "TB";
        }
        if (number >= 0x40000000L && number % 0x40000000L == 0L) {
            return String.valueOf(number / 0x40000000L) + "GB";
        }
        if (number >= 0x100000L && number % 0x100000L == 0L) {
            return String.valueOf(number / 0x100000L) + "MB";
        }
        if (number >= 1024L && number % 1024L == 0L) {
            return String.valueOf(number / 1024L) + "KB";
        }
        return String.valueOf(number);
    }

    public static long parseTime(String text) throws NumberFormatException {
        if (text.endsWith("ms")) {
            return Long.valueOf(text.substring(0, text.length() - 2));
        }
        if (text.endsWith("s")) {
            return Long.valueOf(text.substring(0, text.length() - 1)) * 1000L;
        }
        if (text.endsWith("m")) {
            return Long.valueOf(text.substring(0, text.length() - 1)) * 60000L;
        }
        if (text.endsWith("h")) {
            return Long.valueOf(text.substring(0, text.length() - 1)) * 3600000L;
        }
        if (text.endsWith("d")) {
            return Long.valueOf(text.substring(0, text.length() - 1)) * 86400000L;
        }
        if (text.endsWith("w")) {
            return Long.valueOf(text.substring(0, text.length() - 1)) * 604800000L;
        }
        return Long.valueOf(text) * 1000L;
    }

    public static String serializeTime(long millisecondTime) throws NumberFormatException {
        if (millisecondTime >= 604800000L && millisecondTime % 604800000L == 0L) {
            return String.valueOf(millisecondTime / 604800000L) + "w";
        }
        if (millisecondTime >= 86400000L && millisecondTime % 86400000L == 0L) {
            return String.valueOf(millisecondTime / 86400000L) + "d";
        }
        if (millisecondTime >= 3600000L && millisecondTime % 3600000L == 0L) {
            return String.valueOf(millisecondTime / 3600000L) + "h";
        }
        if (millisecondTime >= 60000L && millisecondTime % 60000L == 0L) {
            return String.valueOf(millisecondTime / 60000L) + "m";
        }
        if (millisecondTime >= 1000L && millisecondTime % 1000L == 0L) {
            return String.valueOf(millisecondTime / 1000L) + "s";
        }
        return String.valueOf(millisecondTime) + "ms";
    }
}

