/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Objects;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureFormat;
import org.apache.sis.feature.FeatureType;
import org.apache.sis.feature.Field;
import org.apache.sis.feature.FieldType;
import org.apache.sis.feature.LinkOperation;
import org.apache.sis.feature.Property;
import org.apache.sis.feature.PropertyView;
import org.apache.sis.feature.Validator;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.CheckedArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;

public abstract class AbstractFeature
implements Serializable {
    private static final long serialVersionUID = -5637918246427380190L;
    static final Object MISSING = new Object();
    final DefaultFeatureType type;
    private static final ThreadLocal<IdentityHashMap<AbstractFeature, Boolean>> COMPARING = ThreadLocal.withInitial(IdentityHashMap::new);

    protected AbstractFeature(DefaultFeatureType defaultFeatureType) {
        ArgumentChecks.ensureNonNull((String)"type", (Object)defaultFeatureType);
        this.type = defaultFeatureType;
    }

    final String getName() {
        return String.valueOf(this.type.getName());
    }

    public DefaultFeatureType getType() {
        return this.type;
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        return PropertyView.create(this, this.type.getProperty(string));
    }

    public void setProperty(Object object) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull((String)"property", (Object)object);
        String string = ((Property)object).getName().toString();
        this.verifyPropertyType(string, (Property)object);
        if (object instanceof AbstractAttribute && !Containers.isNullOrEmpty(((AbstractAttribute)object).characteristics())) {
            throw new IllegalArgumentException(Resources.format((short)2, string));
        }
        this.setPropertyValue(string, ((Property)object).getValue());
    }

    final Property createProperty(String string, Object object) {
        AbstractIdentifiedType abstractIdentifiedType = this.type.getProperty(string);
        if (abstractIdentifiedType instanceof DefaultAttributeType) {
            return AbstractAttribute.create((DefaultAttributeType)abstractIdentifiedType, object);
        }
        if (abstractIdentifiedType instanceof DefaultAssociationRole) {
            return AbstractAssociation.create((DefaultAssociationRole)abstractIdentifiedType, object);
        }
        throw new CorruptedObjectException(Errors.format((short)149, (Object)abstractIdentifiedType));
    }

    final Property createProperty(String string) throws IllegalArgumentException {
        AbstractIdentifiedType abstractIdentifiedType = this.type.getProperty(string);
        if (abstractIdentifiedType instanceof DefaultAttributeType) {
            return ((DefaultAttributeType)abstractIdentifiedType).newInstance();
        }
        if (abstractIdentifiedType instanceof DefaultAssociationRole) {
            return ((DefaultAssociationRole)abstractIdentifiedType).newInstance();
        }
        throw new IllegalArgumentException(AbstractFeature.unsupportedPropertyType(abstractIdentifiedType.getName()));
    }

    final Object getOperationResult(String string) {
        assert (DefaultFeatureType.OPERATION_INDEX.equals(this.type.indices().get(string))) : string;
        return ((AbstractOperation)this.type.getProperty(string)).apply(this, null);
    }

    final Object getDefaultValue(String string) throws IllegalArgumentException {
        AbstractIdentifiedType abstractIdentifiedType = this.type.getProperty(string);
        if (abstractIdentifiedType instanceof DefaultAttributeType) {
            return AbstractFeature.getDefaultValue((DefaultAttributeType)abstractIdentifiedType);
        }
        if (abstractIdentifiedType instanceof DefaultAssociationRole) {
            int n = ((DefaultAssociationRole)abstractIdentifiedType).getMaximumOccurs();
            return n > 1 ? Collections.EMPTY_LIST : null;
        }
        throw new IllegalArgumentException(AbstractFeature.unsupportedPropertyType(abstractIdentifiedType.getName()));
    }

    private static <V> Object getDefaultValue(DefaultAttributeType<V> defaultAttributeType) {
        V v = defaultAttributeType.getDefaultValue();
        if (Field.isSingleton(defaultAttributeType.getMaximumOccurs())) {
            return v;
        }
        return v != null ? Collections.singletonList(v) : Collections.emptyList();
    }

    public abstract Object getPropertyValue(String var1) throws IllegalArgumentException;

    public abstract void setPropertyValue(String var1, Object var2) throws IllegalArgumentException;

    public abstract Object getValueOrFallback(String var1, Object var2);

    protected Object getOperationValue(String string) {
        AbstractOperation abstractOperation = (AbstractOperation)this.type.getProperty(string);
        if (abstractOperation instanceof LinkOperation) {
            return this.getPropertyValue(((LinkOperation)abstractOperation).referentName);
        }
        Object object = abstractOperation.apply(this, null);
        if (object instanceof AbstractAttribute) {
            return AbstractFeature.getAttributeValue((AbstractAttribute)object);
        }
        if (object instanceof AbstractAssociation) {
            return AbstractFeature.getAssociationValue((AbstractAssociation)object);
        }
        return null;
    }

    protected void setOperationValue(String string, Object object) {
        AbstractOperation abstractOperation = (AbstractOperation)this.type.getProperty(string);
        if (abstractOperation instanceof LinkOperation) {
            this.setPropertyValue(((LinkOperation)abstractOperation).referentName, object);
        } else {
            Object object2 = abstractOperation.apply(this, null);
            if (object2 instanceof Property) {
                AbstractFeature.setPropertyValue((Property)object2, object);
            } else {
                throw new IllegalStateException(Resources.format((short)12, string));
            }
        }
    }

    static Object getAttributeValue(AbstractAttribute<?> abstractAttribute) {
        return Field.isSingleton(abstractAttribute.getType().getMaximumOccurs()) ? abstractAttribute.getValue() : abstractAttribute.getValues();
    }

    static Object getAssociationValue(AbstractAssociation abstractAssociation) {
        return Field.isSingleton(abstractAssociation.getRole().getMaximumOccurs()) ? abstractAssociation.getValue() : abstractAssociation.getValues();
    }

    static void setPropertyValue(Property property, Object object) {
        if (property instanceof AbstractAttribute) {
            AbstractFeature.setAttributeValue((AbstractAttribute)property, object);
        } else if (property instanceof AbstractAssociation) {
            AbstractFeature.setAssociationValue((AbstractAssociation)property, object);
        } else {
            throw new IllegalArgumentException(AbstractFeature.unsupportedPropertyType(property.getName()));
        }
    }

    private static <V> void setAttributeValue(AbstractAttribute<V> abstractAttribute, Object object) {
        DefaultAttributeType<V> defaultAttributeType;
        Class<V> clazz;
        if (object != null && !(clazz = (defaultAttributeType = abstractAttribute.getType()).getValueClass()).isInstance(object)) {
            Object object2 = object;
            if (object instanceof Collection) {
                Iterator iterator = ((Collection)object).iterator();
                do {
                    if (iterator.hasNext()) continue;
                    abstractAttribute.setValues((Collection)object);
                    return;
                } while ((object2 = iterator.next()) == null || clazz.isInstance(object2));
            }
            throw new ClassCastException(AbstractFeature.illegalValueClass(defaultAttributeType, clazz, object2));
        }
        abstractAttribute.setValue(object);
    }

    private static void setAssociationValue(AbstractAssociation abstractAssociation, Object object) {
        if (object != null) {
            DefaultAssociationRole defaultAssociationRole = abstractAssociation.getRole();
            DefaultFeatureType defaultFeatureType = defaultAssociationRole.getValueType();
            if (object instanceof AbstractFeature) {
                DefaultFeatureType defaultFeatureType2 = ((AbstractFeature)object).getType();
                if (defaultFeatureType != defaultFeatureType2 && !DefaultFeatureType.maybeAssignableFrom(defaultFeatureType, defaultFeatureType2)) {
                    throw new IllegalArgumentException(AbstractFeature.illegalFeatureType(defaultAssociationRole, defaultFeatureType, defaultFeatureType2));
                }
            } else {
                if (object instanceof Collection) {
                    AbstractFeature.verifyAssociationValues(defaultAssociationRole, (Collection)object);
                    abstractAssociation.setValues((Collection)object);
                    return;
                }
                throw new ClassCastException(AbstractFeature.illegalValueClass(defaultAssociationRole, AbstractFeature.class, object));
            }
        }
        abstractAssociation.setValue((AbstractFeature)object);
    }

    static boolean canSkipVerification(Object object, Object object2) {
        if (object != null) {
            if (object2 == null) {
                return true;
            }
            if (object.getClass() == object2.getClass() && !(object2 instanceof AbstractFeature)) {
                return true;
            }
        }
        return false;
    }

    final void verifyPropertyType(String string, Property property) {
        FieldType fieldType;
        AbstractIdentifiedType abstractIdentifiedType = this.type.getProperty(string);
        if (property instanceof AbstractAttribute) {
            fieldType = ((AbstractAttribute)property).getType();
        } else if (property instanceof AbstractAssociation) {
            fieldType = ((AbstractAssociation)property).getRole();
        } else {
            throw new IllegalArgumentException(Resources.format((short)29, abstractIdentifiedType.getName(), property.getClass()));
        }
        if (fieldType != abstractIdentifiedType) {
            if (abstractIdentifiedType == null) {
                throw new IllegalArgumentException(Resources.format((short)59, this.getName(), string));
            }
            throw new IllegalArgumentException(Resources.format((short)45, string));
        }
    }

    final Object verifyPropertyValue(String string, Object object) {
        AbstractIdentifiedType abstractIdentifiedType = this.type.getProperty(string);
        if (abstractIdentifiedType instanceof DefaultAttributeType) {
            if (object != null) {
                return AbstractFeature.verifyAttributeValue((DefaultAttributeType)abstractIdentifiedType, object);
            }
        } else if (abstractIdentifiedType instanceof DefaultAssociationRole) {
            if (object != null) {
                return AbstractFeature.verifyAssociationValue((DefaultAssociationRole)abstractIdentifiedType, object);
            }
        } else {
            throw new IllegalArgumentException(AbstractFeature.unsupportedPropertyType(abstractIdentifiedType.getName()));
        }
        return object;
    }

    private static <T> Object verifyAttributeValue(DefaultAttributeType<T> defaultAttributeType, Object collection) {
        Class<T> clazz = defaultAttributeType.getValueClass();
        boolean bl = Field.isSingleton(defaultAttributeType.getMaximumOccurs());
        if (clazz.isInstance(collection)) {
            return bl ? collection : AbstractFeature.singletonList(clazz, defaultAttributeType.getMinimumOccurs(), collection);
        }
        if (!bl && collection instanceof Collection) {
            return CheckedArrayList.castOrCopy(collection, clazz);
        }
        throw new ClassCastException(AbstractFeature.illegalValueClass(defaultAttributeType, clazz, collection));
    }

    private static Object verifyAssociationValue(DefaultAssociationRole defaultAssociationRole, Object collection) {
        boolean bl = Field.isSingleton(defaultAssociationRole.getMaximumOccurs());
        if (collection instanceof AbstractFeature) {
            DefaultFeatureType defaultFeatureType = ((AbstractFeature)((Object)collection)).getType();
            DefaultFeatureType defaultFeatureType2 = defaultAssociationRole.getValueType();
            if (defaultFeatureType2 == defaultFeatureType || DefaultFeatureType.maybeAssignableFrom(defaultFeatureType2, defaultFeatureType)) {
                return bl ? collection : AbstractFeature.singletonList(AbstractFeature.class, defaultAssociationRole.getMinimumOccurs(), collection);
            }
            throw new IllegalArgumentException(AbstractFeature.illegalFeatureType(defaultAssociationRole, defaultFeatureType2, defaultFeatureType));
        }
        if (!bl && collection instanceof Collection) {
            AbstractFeature.verifyAssociationValues(defaultAssociationRole, collection);
            return CheckedArrayList.castOrCopy((Collection)collection, AbstractFeature.class);
        }
        throw new ClassCastException(AbstractFeature.illegalValueClass(defaultAssociationRole, AbstractFeature.class, collection));
    }

    private static void verifyAssociationValues(DefaultAssociationRole defaultAssociationRole, Collection<?> collection) {
        DefaultFeatureType defaultFeatureType = defaultAssociationRole.getValueType();
        int n = 0;
        for (Object obj : collection) {
            ArgumentChecks.ensureNonNullElement((String)"values", (int)n, obj);
            if (!(obj instanceof AbstractFeature)) {
                throw new ClassCastException(AbstractFeature.illegalValueClass(defaultAssociationRole, AbstractFeature.class, obj));
            }
            DefaultFeatureType defaultFeatureType2 = ((AbstractFeature)obj).getType();
            if (defaultFeatureType != defaultFeatureType2 && !DefaultFeatureType.maybeAssignableFrom(defaultFeatureType, defaultFeatureType2)) {
                throw new IllegalArgumentException(AbstractFeature.illegalFeatureType(defaultAssociationRole, defaultFeatureType, defaultFeatureType2));
            }
            ++n;
        }
    }

    private static <V> Collection<V> singletonList(Class<V> clazz, int n, Object object) {
        CheckedArrayList checkedArrayList = new CheckedArrayList(clazz, Math.max(n, 4));
        checkedArrayList.add(object);
        return checkedArrayList;
    }

    static String propertyNotFound(FeatureType featureType, Object object, String string) {
        GenericName genericName = null;
        for (AbstractIdentifiedType abstractIdentifiedType : featureType.getProperties(true)) {
            GenericName genericName2;
            GenericName genericName3 = genericName2 = abstractIdentifiedType.getName();
            do {
                if (!string.equalsIgnoreCase(genericName3.toString())) continue;
                if (genericName == null) {
                    genericName = genericName2;
                    continue;
                }
                return Errors.format((short)1, (Object)genericName, (Object)genericName2, (Object)string);
            } while (genericName3 instanceof ScopedName && (genericName3 = ((ScopedName)genericName3).tail()) != null);
        }
        return Resources.format((short)59, object, string);
    }

    static String unsupportedPropertyType(GenericName genericName) {
        return Resources.format((short)7, genericName);
    }

    private static String illegalValueClass(AbstractIdentifiedType abstractIdentifiedType, Class<?> clazz, Object object) {
        return Resources.format((short)30, abstractIdentifiedType.getName(), clazz, object.getClass());
    }

    private static String illegalFeatureType(DefaultAssociationRole defaultAssociationRole, FeatureType featureType, FeatureType featureType2) {
        return Resources.format((short)26, defaultAssociationRole.getName(), featureType.getName(), featureType2.getName());
    }

    public DataQuality quality() {
        Validator validator = new Validator(ScopeCode.FEATURE);
        validator.validate(this.type, this);
        return validator.quality;
    }

    public String toString() {
        return FeatureFormat.sharedFormat(this);
    }

    final boolean comparisonStart() {
        return COMPARING.get().put(this, Boolean.TRUE) == null;
    }

    final void comparisonEnd() {
        if (COMPARING.get().remove(this) != Boolean.TRUE) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int n = this.type.hashCode() * 37;
        if (this.comparisonStart()) {
            try {
                for (AbstractIdentifiedType abstractIdentifiedType : this.type.getProperties(true)) {
                    Object object;
                    String string = abstractIdentifiedType.getName().toString();
                    if (string == null || (object = this.getPropertyValue(string)) == null) continue;
                    n += string.hashCode() ^ object.hashCode();
                }
            }
            finally {
                this.comparisonEnd();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object != this) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            AbstractFeature abstractFeature = (AbstractFeature)object;
            if (!this.type.equals(abstractFeature.type)) {
                return false;
            }
            if (this.comparisonStart()) {
                try {
                    for (AbstractIdentifiedType abstractIdentifiedType : this.type.getProperties(true)) {
                        String string = abstractIdentifiedType.getName().toString();
                        if (Objects.equals(this.getPropertyValue(string), abstractFeature.getPropertyValue(string))) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    this.comparisonEnd();
                }
            }
        }
        return true;
    }
}

