/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.Set;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupJob;
import org.exoplatform.services.jcr.ext.backup.BackupJobListener;

public abstract class AbstractBackupJob
implements BackupJob {
    protected volatile int state = 0;
    protected int id;
    protected BackupConfig config;
    protected ManageableRepository repository;
    protected String workspaceName;
    protected Calendar timeStamp;
    protected URL url;
    private Set<BackupJobListener> listeners = new LinkedHashSet<BackupJobListener>();

    protected abstract URL createStorage() throws FileNotFoundException, IOException;

    @Override
    public final URL getStorageURL() {
        return this.url;
    }

    @Override
    public final int getState() {
        return this.state;
    }

    @Override
    public final int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(BackupJobListener listener) {
        if (listener != null) {
            Set<BackupJobListener> set = this.listeners;
            synchronized (set) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(BackupJobListener listener) {
        if (listener != null) {
            Set<BackupJobListener> set = this.listeners;
            synchronized (set) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners() {
        Set<BackupJobListener> set = this.listeners;
        synchronized (set) {
            NotifyThread notifier = new NotifyThread(this, this.listeners.toArray(new BackupJobListener[this.listeners.size()]), this);
            notifier.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyError(String message, Throwable error) {
        Set<BackupJobListener> set = this.listeners;
        synchronized (set) {
            ErrorNotifyThread notifier = new ErrorNotifyThread(this, this.listeners.toArray(new BackupJobListener[this.listeners.size()]), this, message, error);
            notifier.start();
        }
    }

    class NotifyThread
    extends Thread {
        protected final BackupJobListener[] listeners;
        protected final BackupJob job;

        NotifyThread(AbstractBackupJob this$0, BackupJobListener[] listeners, BackupJob job) {
            super("NotifyThread");
            super.setDaemon(true);
            this.listeners = listeners;
            this.job = job;
        }

        @Override
        public void run() {
            for (BackupJobListener l : this.listeners) {
                l.onStateChanged(this.job);
            }
        }
    }

    class ErrorNotifyThread
    extends NotifyThread {
        private final Throwable error;
        private final String message;

        ErrorNotifyThread(AbstractBackupJob this$0, BackupJobListener[] listeners, BackupJob job, String message, Throwable error) {
            super(this$0, listeners, job);
            this.setName("ErrorNotifyThread");
            this.error = error;
            this.message = message;
        }

        @Override
        public void run() {
            for (BackupJobListener l : this.listeners) {
                l.onError(this.job, this.message, this.error);
            }
        }
    }
}

