/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentLinkedBlockingQueue2<T>
extends ConcurrentLinkedQueue<T>
implements BlockingQueue<T> {
    private static final long serialVersionUID = 2539983016900218313L;
    protected final int capacity;
    protected final AtomicInteger count = new AtomicInteger(0);
    protected final Lock not_empty_lock = new ReentrantLock();
    protected final Condition not_empty = this.not_empty_lock.newCondition();
    int not_empty_awaits = 0;

    public ConcurrentLinkedBlockingQueue2(int capacity) {
        this.capacity = capacity;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("** num_awaits=" + ConcurrentLinkedBlockingQueue2.this.not_empty_awaits);
            }
        });
    }

    @Override
    public boolean offer(T t) {
        boolean retval = super.offer(t);
        if (retval) {
            this.count.incrementAndGet();
        }
        return retval;
    }

    @Override
    public T take() throws InterruptedException {
        Object val = super.poll();
        if (val != null) {
            this.decrCount();
            return (T)val;
        }
        this.waitForNotEmpty();
        val = super.poll();
        if (val != null) {
            this.decrCount();
        }
        return (T)val;
    }

    @Override
    public T poll() {
        Object val = super.poll();
        if (val != null) {
            this.decrCount();
        }
        return (T)val;
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        return null;
    }

    @Override
    public boolean remove(Object o) {
        boolean retval = super.remove(o);
        if (retval) {
            this.decrCount();
        }
        return retval;
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.size();
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        T el;
        int cnt = 0;
        if (c == null) {
            return cnt;
        }
        while ((el = this.poll()) != null) {
            c.add(el);
            ++cnt;
        }
        this.count.set(0);
        return cnt;
    }

    @Override
    public void put(T t) throws InterruptedException {
        if (super.offer(t)) {
            this.incrCount();
        }
    }

    @Override
    public boolean offer(T t, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(t);
    }

    @Override
    public int size() {
        return this.count.get();
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        return this.drainTo(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForNotEmpty() throws InterruptedException {
        while (this.count.get() == 0) {
            this.not_empty_lock.lock();
            try {
                if (this.count.get() > 0) {
                    return;
                }
                ++this.not_empty_awaits;
                this.not_empty.await();
            }
            finally {
                this.not_empty_lock.unlock();
            }
        }
    }

    protected void decrCount() {
        this.count.getAndDecrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrCount() {
        int prev_count = this.count.getAndIncrement();
        if (prev_count == 0) {
            this.not_empty_lock.lock();
            try {
                this.not_empty.signal();
            }
            finally {
                this.not_empty_lock.unlock();
            }
        }
    }
}

