/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.statistics;

import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;

public class Statistics {
    private final Statistics parent;
    private final String description;
    private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong max = new AtomicLong(-1L);
    private final AtomicLong total = new AtomicLong();
    private final AtomicLong times = new AtomicLong();
    private final ThreadLocal<Queue<Long>> currentTime = new ThreadLocal<Queue<Long>>(this){

        @Override
        protected Queue<Long> initialValue() {
            return new LinkedList<Long>();
        }
    };

    public Statistics(Statistics parent, String description) {
        this.parent = parent;
        this.description = description.replace(',', ';');
    }

    public void begin() {
        if (this.parent != null) {
            this.parent.onBegin();
        }
        this.onBegin();
    }

    private void onBegin() {
        Queue<Long> q = this.currentTime.get();
        q.add(System.currentTimeMillis());
    }

    public void end() {
        this.onEnd();
        if (this.parent != null) {
            this.parent.onEnd();
        }
    }

    private void onEnd() {
        long result = System.currentTimeMillis() - this.currentTime.get().poll();
        this.times.incrementAndGet();
        if (result < this.min.get()) {
            this.min.set(result);
        }
        if (this.max.get() < result) {
            this.max.set(result);
        }
        this.total.addAndGet(result);
    }

    public void printHeader(PrintWriter pw) {
        pw.print(this.description);
        pw.print("-Min,");
        pw.print(this.description);
        pw.print("-Max,");
        pw.print(this.description);
        pw.print("-Total,");
        pw.print(this.description);
        pw.print("-Avg,");
        pw.print(this.description);
        pw.print("-Times");
    }

    public void printData(PrintWriter pw) {
        long lmin = this.min.get();
        if (lmin == Long.MAX_VALUE) {
            lmin = -1L;
        }
        long lmax = this.max.get();
        long ltotal = this.total.get();
        long ltimes = this.times.get();
        float favg = ltimes == 0L ? 0.0f : (float)ltotal / (float)ltimes;
        pw.print(lmin);
        pw.print(',');
        pw.print(lmax);
        pw.print(',');
        pw.print(ltotal);
        pw.print(',');
        pw.print(favg);
        pw.print(',');
        pw.print(ltimes);
    }

    public long getMin() {
        long lmin = this.min.get();
        if (lmin == Long.MAX_VALUE) {
            lmin = -1L;
        }
        return lmin;
    }

    public long getMax() {
        return this.max.get();
    }

    public long getTotal() {
        return this.total.get();
    }

    public long getTimes() {
        return this.times.get();
    }

    public float getAvg() {
        long ltotal = this.total.get();
        long ltimes = this.times.get();
        float favg = ltimes == 0L ? 0.0f : (float)ltotal / (float)ltimes;
        return favg;
    }

    public void reset() {
        this.min.set(Long.MAX_VALUE);
        this.max.set(0L);
        this.total.set(0L);
        this.times.set(0L);
    }
}

