/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web;

import java.util.Map;
import java.util.Objects;

public class MapEntry<T>
implements Map.Entry<String, T> {
    private final String key;
    private T value;
    private final boolean modifiable;

    public MapEntry(String key, T value, boolean modifiable) {
        this.key = key;
        this.value = value;
        this.modifiable = modifiable;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public T setValue(T val) {
        if (this.modifiable) {
            T oldVal = this.value;
            this.value = val;
            return oldVal;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapEntry other = (MapEntry)o;
        return Objects.equals(this.key, other.key) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.getValue());
    }
}

