/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.config.AbstractRepositoryServiceConfiguration;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

@Managed
@NameTemplate(value={@Property(key="service", value="RepositoryServiceConfiguration")})
public class RepositoryServiceConfiguration
extends AbstractRepositoryServiceConfiguration
implements IUnmarshallable,
IMarshallable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.RepositoryServiceConfiguration");
    public static final String JiBX_bindingList = "|org.exoplatform.services.jcr.config.JiBX_bindingFactory|";

    public RepositoryServiceConfiguration() {
    }

    public RepositoryServiceConfiguration(String defaultRepositoryName, List<RepositoryEntry> repositoryEntries) {
        this.defaultRepositoryName = defaultRepositoryName;
        this.repositoryConfigurations = repositoryEntries;
    }

    public final RepositoryEntry getRepositoryConfiguration(String name) throws RepositoryConfigurationException {
        for (int i = 0; i < this.getRepositoryConfigurations().size(); ++i) {
            RepositoryEntry conf = this.getRepositoryConfigurations().get(i);
            if (!conf.getName().equals(name)) continue;
            return conf;
        }
        throw new RepositoryConfigurationException("Repository not configured " + name);
    }

    protected final void init(InputStream is) throws RepositoryConfigurationException {
        try {
            IBindingFactory factory = BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
            IUnmarshallingContext uctx = factory.createUnmarshallingContext();
            RepositoryServiceConfiguration conf = (RepositoryServiceConfiguration)uctx.unmarshalDocument(is, null);
            this.defaultRepositoryName = conf.getDefaultRepositoryName();
            this.repositoryConfigurations = conf.getRepositoryConfigurations();
        }
        catch (JiBXException e) {
            throw new RepositoryConfigurationException("Error in config initialization " + String.valueOf((Object)e), e);
        }
    }

    protected final void merge(InputStream is) throws RepositoryConfigurationException {
        try {
            List<RepositoryEntry> repositoryEntries;
            IBindingFactory factory = BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
            IUnmarshallingContext uctx = factory.createUnmarshallingContext();
            RepositoryServiceConfiguration conf = (RepositoryServiceConfiguration)uctx.unmarshalDocument(is, null);
            if (this.defaultRepositoryName == null) {
                this.defaultRepositoryName = conf.getDefaultRepositoryName();
            }
            if ((repositoryEntries = conf.getRepositoryConfigurations()) == null || repositoryEntries.isEmpty()) {
                return;
            }
            if (this.repositoryConfigurations == null || this.repositoryConfigurations.isEmpty()) {
                this.repositoryConfigurations = repositoryEntries;
                return;
            }
            LinkedHashMap<String, RepositoryEntry> mapRepoEntries = new LinkedHashMap<String, RepositoryEntry>();
            for (RepositoryEntry entry : this.repositoryConfigurations) {
                mapRepoEntries.put(entry.getName(), entry);
            }
            for (RepositoryEntry entry : repositoryEntries) {
                RepositoryEntry currentEntry = (RepositoryEntry)mapRepoEntries.get(entry.getName());
                if (currentEntry == null) {
                    mapRepoEntries.put(entry.getName(), entry);
                    continue;
                }
                currentEntry.merge(entry);
            }
            this.getRepositoryConfigurations().clear();
            this.getRepositoryConfigurations().addAll(mapRepoEntries.values());
        }
        catch (JiBXException e) {
            throw new RepositoryConfigurationException("Error in config initialization " + String.valueOf((Object)e), e);
        }
    }

    @Override
    public boolean isRetainable() {
        return false;
    }

    public void retain() throws RepositoryException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    @ManagedDescription(value="The configuration of all the repositories in XML format.")
    public String getConfigurationXML() {
        StringWriter sw = new StringWriter();
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.setIndent(2);
            mctx.marshalDocument((Object)this, "UTF-8", null, (Writer)sw);
        }
        catch (JiBXException e) {
            LOG.warn((Object)"Cannot convert the configuration to XML format", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            block12: {
                try {
                    sw.close();
                }
                catch (IOException ignore) {
                    if (!LOG.isTraceEnabled()) break block12;
                    LOG.trace((Object)("An exception occurred: " + ignore.getMessage()));
                }
            }
        }
        return sw.toString();
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller("org.exoplatform.services.jcr.config.RepositoryServiceConfiguration").unmarshal((Object)this, arg1);
    }

    public /* synthetic */ String JiBX_getName() {
        return "org.exoplatform.services.jcr.config.RepositoryServiceConfiguration";
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller("org.exoplatform.services.jcr.config.RepositoryServiceConfiguration").marshal((Object)this, arg1);
    }
}

