/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeRepository;
import org.exoplatform.services.jcr.impl.core.value.ValueConstraintsValidator;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NodeTypeDataValidator {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.NodeTypeDataValidator");
    protected final NodeTypeRepository hierarchy;
    protected final ValueFactoryImpl valueFactory;

    public NodeTypeDataValidator(LocationFactory locationFactory, NodeTypeRepository hierarchy, FileCleanerHolder cleanerHolder) {
        this.hierarchy = hierarchy;
        this.valueFactory = new ValidatorValueFactory(this, locationFactory, cleanerHolder);
    }

    public void validateNodeType(List<NodeTypeData> nodeTypeDataList) throws RepositoryException {
        for (NodeTypeData nodeTypeData : nodeTypeDataList) {
            this.validateNodeType(nodeTypeData);
        }
        this.checkCyclicDependencies(nodeTypeDataList);
    }

    private void checkCyclicDependencies(List<NodeTypeData> nodeTypeDataList) throws RepositoryException {
        HashSet<InternalQName> unresolvedDependecies = new HashSet<InternalQName>();
        HashSet<InternalQName> resolvedDependecies = new HashSet<InternalQName>();
        for (NodeTypeData nodeTypeData : nodeTypeDataList) {
            int i;
            resolvedDependecies.add(nodeTypeData.getName());
            unresolvedDependecies.remove((Object)nodeTypeData.getName());
            for (i = 0; i < nodeTypeData.getDeclaredSupertypeNames().length; ++i) {
                InternalQName superName = nodeTypeData.getDeclaredSupertypeNames()[i];
                if (this.hierarchy.getNodeType(superName) != null || resolvedDependecies.contains((Object)superName)) continue;
                unresolvedDependecies.add(superName);
            }
            for (i = 0; i < nodeTypeData.getDeclaredChildNodeDefinitions().length; ++i) {
                NodeDefinitionData childnodeDefinitionData = nodeTypeData.getDeclaredChildNodeDefinitions()[i];
                for (int j = 0; j < childnodeDefinitionData.getRequiredPrimaryTypes().length; ++j) {
                    InternalQName requiredPrimaryTypeName = childnodeDefinitionData.getRequiredPrimaryTypes()[j];
                    if (this.hierarchy.getNodeType(requiredPrimaryTypeName) != null || resolvedDependecies.contains((Object)requiredPrimaryTypeName)) continue;
                    unresolvedDependecies.add(requiredPrimaryTypeName);
                }
                if (childnodeDefinitionData.getDefaultPrimaryType() == null || this.hierarchy.getNodeType(childnodeDefinitionData.getDefaultPrimaryType()) != null || resolvedDependecies.contains((Object)childnodeDefinitionData.getDefaultPrimaryType())) continue;
                unresolvedDependecies.add(childnodeDefinitionData.getDefaultPrimaryType());
            }
        }
        if (unresolvedDependecies.size() > 0) {
            StringBuilder msg = new StringBuilder("Fail. Unresolved cyclic dependecy for :");
            for (InternalQName internalQName : resolvedDependecies) {
                msg.append(" ").append(internalQName.getAsString());
            }
            msg.append(" Unresolved ");
            for (InternalQName internalQName : unresolvedDependecies) {
                msg.append(" ").append(internalQName.getAsString());
            }
            throw new RepositoryException(msg.toString());
        }
    }

    private void validateNodeType(NodeTypeData nodeType) throws RepositoryException {
        if (nodeType == null) {
            throw new RepositoryException("NodeType object " + String.valueOf(nodeType) + " is null");
        }
        if (nodeType.getName() == null) {
            throw new RepositoryException("NodeType implementation class " + nodeType.getClass().getName() + " is not supported in this method");
        }
        for (InternalQName internalQName : nodeType.getDeclaredSupertypeNames()) {
            if (nodeType.getName().equals((Object)Constants.NT_BASE) || !nodeType.getName().equals((Object)internalQName)) continue;
            throw new RepositoryException("Invalid super type name" + internalQName.getAsString());
        }
        for (PropertyDefinitionData propertyDefinitionData : nodeType.getDeclaredPropertyDefinitions()) {
            if (!propertyDefinitionData.getDeclaringNodeType().equals((Object)nodeType.getName())) {
                throw new RepositoryException("Invalid declared node type in property definitions with name " + propertyDefinitionData.getName().getAsString() + " not registred");
            }
            try {
                this.validateValueDefaults(propertyDefinitionData.getRequiredType(), propertyDefinitionData.getDefaultValues());
            }
            catch (ValueFormatException e) {
                throw new ValueFormatException("Default value is incompatible with Property type " + PropertyType.nameFromValue((int)propertyDefinitionData.getRequiredType()) + " of " + propertyDefinitionData.getName().getAsString() + " in nodetype " + nodeType.getName().getAsString(), (Throwable)e);
            }
            try {
                this.validateValueConstraints(propertyDefinitionData.getRequiredType(), propertyDefinitionData.getValueConstraints());
            }
            catch (ValueFormatException e) {
                throw new ValueFormatException("Constraints is incompatible with Property type " + PropertyType.nameFromValue((int)propertyDefinitionData.getRequiredType()) + " of " + propertyDefinitionData.getName().getAsString() + " in nodetype " + nodeType.getName().getAsString(), (Throwable)e);
            }
        }
        for (NodeDefinitionData nodeDefinitionData : nodeType.getDeclaredChildNodeDefinitions()) {
            if (nodeDefinitionData.getDeclaringNodeType().equals((Object)nodeType.getName())) continue;
            throw new RepositoryException("Invalid declared node type in child node definitions with name " + nodeDefinitionData.getName().getAsString() + " not registred");
        }
    }

    private void validateValueDefaults(int requiredType, String[] defValues) throws ValueFormatException {
        if (requiredType != 1 && requiredType != 0 && requiredType != 2) {
            for (String dv : defValues) {
                this.valueFactory.createValue(dv, requiredType);
            }
        }
    }

    private void validateValueConstraints(int requiredType, String[] constraints) throws ValueFormatException {
        ValueConstraintsValidator validator = new ValueConstraintsValidator(constraints);
        validator.validateFor(requiredType);
    }

    protected class ValidatorValueFactory
    extends ValueFactoryImpl {
        ValidatorValueFactory(NodeTypeDataValidator this$0, LocationFactory locationFactory, FileCleanerHolder cleanerHolder) {
            super(locationFactory, cleanerHolder);
        }

        @Override
        public Value createValue(String value, int type) throws ValueFormatException {
            if (type == 2) {
                LOG.warn((Object)"Not supported Value type: BINARY");
                return null;
            }
            return super.createValue(value, type);
        }

        @Override
        public Value createValue(InputStream value) {
            LOG.warn((Object)"Not supported Value type: BINARY");
            return null;
        }

        @Override
        public Value loadValue(ValueData data, int type) throws RepositoryException {
            if (type == 2) {
                LOG.warn((Object)"Not supported Value type: BINARY");
                return null;
            }
            return super.loadValue(data, type);
        }
    }
}

