/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.sis.internal.netcdf.Linearizer;
import org.apache.sis.referencing.operation.builder.LocalizationGridBuilder;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

final class GridCacheValue {
    final MathTransform gridToCRS;
    final Linearizer.Type linearizationType;
    final SingleCRS linearizationTarget;
    final boolean axisSwap;

    GridCacheValue(Set<Linearizer> set, LocalizationGridBuilder localizationGridBuilder, MathTransformFactory mathTransformFactory) throws FactoryException {
        this.gridToCRS = localizationGridBuilder.create(mathTransformFactory);
        Optional optional = localizationGridBuilder.linearizer(true);
        if (optional.isPresent()) {
            String string = (String)((Map.Entry)optional.get()).getKey();
            for (Linearizer linearizer : set) {
                if (!string.equals(linearizer.name())) continue;
                this.linearizationType = linearizer.type;
                this.linearizationTarget = linearizer.getTargetCRS();
                this.axisSwap = linearizer.axisSwap();
                return;
            }
        }
        this.linearizationType = null;
        this.linearizationTarget = null;
        this.axisSwap = false;
    }
}

