/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop.store;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.NonstopConfiguration;
import net.sf.ehcache.config.TimeoutBehaviorConfiguration;
import net.sf.ehcache.constructs.nonstop.ClusterOperation;
import net.sf.ehcache.constructs.nonstop.NonstopActiveDelegateHolder;
import net.sf.ehcache.constructs.nonstop.NonstopThread;
import net.sf.ehcache.constructs.nonstop.concurrency.ExplicitLockingContextThreadLocal;
import net.sf.ehcache.constructs.nonstop.concurrency.NonstopCacheLockProvider;
import net.sf.ehcache.constructs.nonstop.store.ExecutorServiceStore;
import net.sf.ehcache.constructs.nonstop.store.NonstopStore;
import net.sf.ehcache.constructs.nonstop.store.NonstopTimeoutBehaviorStoreResolver;
import net.sf.ehcache.constructs.nonstop.store.RejoinAwareNonstopStore;
import net.sf.ehcache.constructs.nonstop.store.TransactionalExecutorServiceStore;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.StoreListener;
import net.sf.ehcache.store.StoreQuery;
import net.sf.ehcache.store.TerracottaStore;
import net.sf.ehcache.transaction.manager.TransactionManagerLookup;
import net.sf.ehcache.writer.CacheWriterManager;

public class NonstopStoreImpl
implements NonstopTimeoutBehaviorStoreResolver,
RejoinAwareNonstopStore {
    private final NonstopActiveDelegateHolder nonstopActiveDelegateHolder;
    private final NonstopConfiguration nonstopConfig;
    private final ConcurrentMap<TimeoutBehaviorConfiguration.TimeoutBehaviorType, NonstopStore> timeoutBehaviors;
    private final ExecutorServiceStore executorServiceStore;
    private final ExplicitLockingContextThreadLocal explicitLockingContextThreadLocal;
    private final CacheLockProvider nonstopCacheLockProvider;

    public NonstopStoreImpl(NonstopActiveDelegateHolder nonstopActiveDelegateHolder, CacheCluster cacheCluster, NonstopConfiguration nonstopConfig, CacheConfiguration.TransactionalMode transactionalMode, TransactionManagerLookup transactionManagerLookup) {
        this.nonstopActiveDelegateHolder = nonstopActiveDelegateHolder;
        this.nonstopConfig = nonstopConfig;
        this.explicitLockingContextThreadLocal = new ExplicitLockingContextThreadLocal();
        this.timeoutBehaviors = new ConcurrentHashMap<TimeoutBehaviorConfiguration.TimeoutBehaviorType, NonstopStore>();
        this.executorServiceStore = transactionalMode.equals((Object)CacheConfiguration.TransactionalMode.XA_STRICT) ? new TransactionalExecutorServiceStore(nonstopActiveDelegateHolder, nonstopConfig, this, cacheCluster, transactionManagerLookup, this.explicitLockingContextThreadLocal) : new ExecutorServiceStore(nonstopActiveDelegateHolder, nonstopConfig, this, cacheCluster, this.explicitLockingContextThreadLocal);
        this.nonstopCacheLockProvider = new NonstopCacheLockProvider(this, nonstopActiveDelegateHolder, this.explicitLockingContextThreadLocal, nonstopConfig);
    }

    @Override
    public NonstopStore resolveTimeoutBehaviorStore() {
        NonstopStore prev;
        TimeoutBehaviorConfiguration.TimeoutBehaviorType timeoutBehaviorType = this.nonstopConfig.getTimeoutBehavior().getTimeoutBehaviorType();
        NonstopStore timeoutStore = (NonstopStore)this.timeoutBehaviors.get((Object)timeoutBehaviorType);
        if (timeoutStore == null && (prev = this.timeoutBehaviors.putIfAbsent(timeoutBehaviorType, timeoutStore = this.nonstopConfig.getTimeoutBehavior().getNonstopTimeoutBehaviorFactory().createNonstopTimeoutBehaviorStore(this.nonstopActiveDelegateHolder))) != null) {
            timeoutStore = prev;
        }
        return timeoutStore;
    }

    TerracottaStore getUnderlyingStore() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore();
    }

    @Override
    public Object getInternalContext() {
        return this.nonstopCacheLockProvider;
    }

    @Override
    public void waitUntilClusterCoherent() throws InterruptedException {
        this.executorServiceStore.waitUntilClusterCoherent();
    }

    @Override
    public boolean bufferFull() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().bufferFull();
    }

    @Override
    public boolean containsKeyOffHeap(Object key) {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().containsKeyOffHeap(key);
    }

    @Override
    public boolean containsKeyOnDisk(Object key) {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().containsKeyOnDisk(key);
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getInMemoryEvictionPolicy();
    }

    @Override
    public Object getMBean() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getMBean();
    }

    @Override
    public int getOffHeapSize() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getOffHeapSize();
    }

    @Override
    public long getOffHeapSizeInBytes() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getOffHeapSizeInBytes();
    }

    @Override
    public int getOnDiskSize() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getOnDiskSize();
    }

    @Override
    public long getOnDiskSizeInBytes() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getOnDiskSizeInBytes();
    }

    @Override
    public boolean hasAbortedSizeOf() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().hasAbortedSizeOf();
    }

    @Override
    public Status getStatus() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getStatus();
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
        this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().setInMemoryEvictionPolicy(policy);
    }

    @Override
    public void expireElements() {
        this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().expireElements();
    }

    private boolean isCurrentThreadNonstopThread() {
        return NonstopThread.isCurrentThreadNonstopThread();
    }

    @Override
    public void unpinAll() {
        if (this.isCurrentThreadNonstopThread()) {
            this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().unpinAll();
        } else {
            this.executorServiceStore.unpinAll();
        }
    }

    @Override
    public boolean isPinned(Object key) {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().isPinned(key);
        }
        return this.executorServiceStore.isPinned(key);
    }

    @Override
    public void setPinned(Object key, boolean pinned) {
        if (this.isCurrentThreadNonstopThread()) {
            this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().setPinned(key, pinned);
        } else {
            this.executorServiceStore.setPinned(key, pinned);
        }
    }

    @Override
    public void addStoreListener(StoreListener listener) {
        if (this.isCurrentThreadNonstopThread()) {
            this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().addStoreListener(listener);
        } else {
            this.executorServiceStore.addStoreListener(listener);
        }
    }

    @Override
    public void removeStoreListener(StoreListener listener) {
        if (this.isCurrentThreadNonstopThread()) {
            this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().removeStoreListener(listener);
        } else {
            this.executorServiceStore.removeStoreListener(listener);
        }
    }

    @Override
    public void setAttributeExtractors(Map<String, AttributeExtractor> extractors) {
        this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().setAttributeExtractors(extractors);
    }

    @Override
    public boolean isCacheCoherent() {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().isCacheCoherent();
        }
        return this.executorServiceStore.isCacheCoherent();
    }

    @Override
    public boolean isClusterCoherent() {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().isClusterCoherent();
        }
        return this.executorServiceStore.isClusterCoherent();
    }

    @Override
    public boolean isNodeCoherent() {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().isNodeCoherent();
        }
        return this.executorServiceStore.isNodeCoherent();
    }

    @Override
    public void setNodeCoherent(boolean coherent) throws UnsupportedOperationException {
        if (this.isCurrentThreadNonstopThread()) {
            this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().setNodeCoherent(coherent);
        } else {
            this.executorServiceStore.setNodeCoherent(coherent);
        }
    }

    @Override
    public void dispose() {
        if (this.isCurrentThreadNonstopThread()) {
            this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().dispose();
        } else {
            this.executorServiceStore.dispose();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().containsKey(key);
        }
        return this.executorServiceStore.containsKey(key);
    }

    @Override
    public boolean containsKeyInMemory(Object key) {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().containsKeyInMemory(key);
        }
        return this.executorServiceStore.containsKeyInMemory(key);
    }

    @Override
    public Results executeQuery(StoreQuery query) {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().executeQuery(query);
        }
        return this.executorServiceStore.executeQuery(query);
    }

    @Override
    public <T> Attribute<T> getSearchAttribute(String attributeName) {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getSearchAttribute(attributeName);
        }
        return this.executorServiceStore.getSearchAttribute(attributeName);
    }

    @Override
    public void flush() throws IOException {
        if (this.isCurrentThreadNonstopThread()) {
            this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().flush();
        } else {
            this.executorServiceStore.flush();
        }
    }

    @Override
    public Element get(Object key) {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().get(key);
        }
        return this.executorServiceStore.get(key);
    }

    @Override
    public int getInMemorySize() {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getInMemorySize();
        }
        return this.executorServiceStore.getInMemorySize();
    }

    @Override
    public long getInMemorySizeInBytes() {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getInMemorySizeInBytes();
        }
        return this.executorServiceStore.getInMemorySizeInBytes();
    }

    @Override
    public List getKeys() {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getKeys();
        }
        return this.executorServiceStore.getKeys();
    }

    @Override
    public Element getQuiet(Object key) {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getQuiet(key);
        }
        return this.executorServiceStore.getQuiet(key);
    }

    @Override
    public Map<Object, Element> getAllQuiet(Collection<?> keys) {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getAllQuiet(keys);
        }
        return this.executorServiceStore.getAllQuiet(keys);
    }

    @Override
    public Map<Object, Element> getAll(Collection<?> keys) {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getAll(keys);
        }
        return this.executorServiceStore.getAll(keys);
    }

    @Override
    public int getSize() {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getSize();
        }
        return this.executorServiceStore.getSize();
    }

    @Override
    public int getTerracottaClusteredSize() {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getTerracottaClusteredSize();
        }
        return this.executorServiceStore.getTerracottaClusteredSize();
    }

    @Override
    public boolean put(Element element) throws CacheException {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().put(element);
        }
        return this.executorServiceStore.put(element);
    }

    @Override
    public void putAll(Collection<Element> elements) throws CacheException {
        if (this.isCurrentThreadNonstopThread()) {
            this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().putAll(elements);
        } else {
            this.executorServiceStore.putAll(elements);
        }
    }

    @Override
    public Element putIfAbsent(Element element) throws NullPointerException {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().putIfAbsent(element);
        }
        return this.executorServiceStore.putIfAbsent(element);
    }

    @Override
    public boolean putWithWriter(Element element, CacheWriterManager writerManager) throws CacheException {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().putWithWriter(element, writerManager);
        }
        return this.executorServiceStore.putWithWriter(element, writerManager);
    }

    @Override
    public Element remove(Object key) {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().remove(key);
        }
        return this.executorServiceStore.remove(key);
    }

    @Override
    public void removeAll(Collection<?> keys) {
        if (this.isCurrentThreadNonstopThread()) {
            this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().removeAll(keys);
        } else {
            this.executorServiceStore.removeAll(keys);
        }
    }

    @Override
    public void removeAll() throws CacheException {
        if (this.isCurrentThreadNonstopThread()) {
            this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().removeAll();
        } else {
            this.executorServiceStore.removeAll();
        }
    }

    @Override
    public Element removeElement(Element element, ElementValueComparator comparator) throws NullPointerException {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().removeElement(element, comparator);
        }
        return this.executorServiceStore.removeElement(element, comparator);
    }

    @Override
    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().removeWithWriter(key, writerManager);
        }
        return this.executorServiceStore.removeWithWriter(key, writerManager);
    }

    @Override
    public boolean replace(Element old, Element element, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().replace(old, element, comparator);
        }
        return this.executorServiceStore.replace(old, element, comparator);
    }

    @Override
    public Element replace(Element element) throws NullPointerException {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().replace(element);
        }
        return this.executorServiceStore.replace(element);
    }

    @Override
    public Set getLocalKeys() {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getLocalKeys();
        }
        return this.executorServiceStore.getLocalKeys();
    }

    @Override
    public CacheConfiguration.TransactionalMode getTransactionalMode() {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getTransactionalMode();
        }
        return this.executorServiceStore.getTransactionalMode();
    }

    @Override
    public Element unlockedGet(Object key) {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().unlockedGet(key);
        }
        return this.executorServiceStore.unlockedGet(key);
    }

    @Override
    public Element unlockedGetQuiet(Object key) {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().unlockedGetQuiet(key);
        }
        return this.executorServiceStore.unlockedGetQuiet(key);
    }

    @Override
    public Element unsafeGet(Object key) {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().unsafeGet(key);
        }
        return this.executorServiceStore.unsafeGet(key);
    }

    @Override
    public Element unsafeGetQuiet(Object key) {
        if (this.isCurrentThreadNonstopThread()) {
            return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().unsafeGetQuiet(key);
        }
        return this.executorServiceStore.unsafeGetQuiet(key);
    }

    @Override
    public <V> V executeClusterOperation(ClusterOperation<V> operation) {
        if (this.isCurrentThreadNonstopThread()) {
            try {
                return operation.performClusterOperation();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.executorServiceStore.executeClusterOperation(operation);
    }

    @Override
    public void clusterRejoined() {
        this.executorServiceStore.clusterRejoined();
    }

    @Override
    public void recalculateSize(Object key) {
        throw new UnsupportedOperationException();
    }
}

