/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.checker;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.checker.InconsistencyRepair;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.WorkspaceStorageConnectionFactory;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class AbstractInconsistencyRepair
implements InconsistencyRepair {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.AbstractInconsistencyRepair");
    private final WorkspaceStorageConnectionFactory connFactory;

    AbstractInconsistencyRepair(WorkspaceStorageConnectionFactory connFactory, JDBCDataContainerConfig containerConfig) {
        this.connFactory = connFactory;
    }

    @Override
    public final void doRepair(ResultSet resultSet) throws SQLException {
        WorkspaceStorageConnection conn = null;
        try {
            conn = this.connFactory.openConnection(false);
            if (!(conn instanceof JDBCStorageConnection)) {
                throw new SQLException("Connection is instance of " + String.valueOf(conn.getClass()));
            }
            this.repairRow((JDBCStorageConnection)conn, resultSet);
            conn.commit();
        }
        catch (RepositoryException e) {
            this.rollback(conn);
            throw new SQLException(e);
        }
        catch (SQLException e) {
            this.rollback(conn);
            throw e;
        }
    }

    abstract void repairRow(JDBCStorageConnection var1, ResultSet var2) throws SQLException;

    protected void rollback(WorkspaceStorageConnection conn) {
        try {
            if (conn != null) {
                conn.rollback();
            }
        }
        catch (IllegalStateException e) {
            LOG.error((Object)"Can not rollback connection", (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Can not rollback connection", (Throwable)e);
        }
    }

    protected String getIdentifier(ResultSet resultSet, String column) throws SQLException {
        String containerName;
        block2: {
            containerName = "";
            try {
                containerName = resultSet.getString("CONTAINER_NAME");
            }
            catch (SQLException e) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace((Object)("Can't get container name: " + e.getMessage()));
            }
        }
        return resultSet.getString(column).substring(containerName.length());
    }

    protected QPathEntry getQPathEntry(ResultSet resultSet) throws SQLException, IllegalNameException {
        return new QPathEntry(InternalQName.parse(resultSet.getString("NAME")), resultSet.getInt("I_INDEX"));
    }
}

