/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.statistics;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ACLHolder;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ChangedSizeHandler;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainer;
import org.exoplatform.services.jcr.statistics.JCRStatisticsManager;
import org.exoplatform.services.jcr.statistics.Statistics;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;

public class StatisticsJDBCStorageConnection
implements WorkspaceStorageConnection {
    public static final String CATEGORY = "JDBCStorageConnection";
    private static final String UPDATE_PROPERTY_DATA_DESCR = "updatePropertyData";
    private static final String UPDATE_NODE_DATA_DESCR = "updateNodeData";
    private static final String ROLLBACK_DESCR = "rollback";
    private static final String PREPARE_DESCR = "prepare";
    private static final String RENAME_NODE_DATA_DESCR = "renameNodeData";
    public static final String LIST_CHILD_PROPERTIES_DATA_DESCR = "listChildPropertiesData";
    private static final String GET_CHILD_NODES_DATA_BY_PAGE_DESCR = "getChildNodesDataByPage";
    private static final String IS_OPENED_DESCR = "isOpened";
    private static final String GET_REFERENCES_DATA_DESCR = "getReferencesData";
    public static final String GET_ITEM_DATA_BY_ID_DESCR = "getItemDataById";
    public static final String GET_ITEM_DATA_BY_NODE_DATA_NQ_PATH_ENTRY_DESCR = "getItemDataByNodeDataNQPathEntry";
    public static final String GET_CHILD_PROPERTIES_DATA_DESCR = "getChildPropertiesData";
    public static final String GET_CHILD_PROPERTIES_DATA_PATTERN_DESCR = "getChildPropertiesDataPattern";
    private static final String GET_CHILD_NODES_DATA_DESCR = "getChildNodesData";
    private static final String GET_CHILD_NODES_DATA_PATTERN_DESCR = "getChildNodesDataPattern";
    private static final String GET_CHILD_NODES_COUNT_DESCR = "getChildNodesCount";
    private static final String GET_LAST_ORDER_NUMBER_DESCR = "getLastOrderNumber";
    private static final String GET_ACL_HOLDERS = "getACLHolders";
    private static final String DELETE_PROPERTY_DATA_DESCR = "deletePropertyData";
    private static final String DELETE_NODE_DATA_DESCR = "deleteNodeData";
    private static final String COMMIT_DESCR = "commit";
    private static final String CLOSE_DESCR = "close";
    private static final String ADD_PROPERTY_DATA_DESCR = "addPropertyData";
    private static final String ADD_NODE_DATA_DESCR = "addNodeData";
    private static final String NODES_COUNT = "getNodesCount";
    private static final String HAS_ITEM_DATA_DESCR = "hasItemData";
    private static final String GET_WORKSPACE_DATA_SIZE = "getWorkspaceDataSize";
    private static final String GET_NODE_DATA_SIZE = "getNodeDataSize";
    private static final Statistics GLOBAL_STATISTICS = new Statistics(null, "global");
    private static final Map<String, Statistics> ALL_STATISTICS = new LinkedHashMap<String, Statistics>();
    private final WorkspaceStorageConnection wcs;

    public StatisticsJDBCStorageConnection(WorkspaceStorageConnection wcs) {
        this.wcs = wcs;
    }

    public WorkspaceStorageConnection getNestedWorkspaceStorageConnection() {
        return this.wcs;
    }

    @Override
    public void add(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(ADD_NODE_DATA_DESCR);
        try {
            s.begin();
            this.wcs.add(data);
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(PropertyData data, ChangedSizeHandler sizeHandler) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(ADD_PROPERTY_DATA_DESCR);
        try {
            s.begin();
            this.wcs.add(data, sizeHandler);
        }
        finally {
            s.end();
        }
    }

    @Override
    public void close() throws IllegalStateException, RepositoryException {
        Statistics s = ALL_STATISTICS.get(CLOSE_DESCR);
        try {
            s.begin();
            this.wcs.close();
        }
        finally {
            s.end();
        }
    }

    @Override
    public void commit() throws IllegalStateException, RepositoryException {
        Statistics s = ALL_STATISTICS.get(COMMIT_DESCR);
        try {
            s.begin();
            this.wcs.commit();
        }
        finally {
            s.end();
        }
    }

    @Override
    public void delete(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(DELETE_NODE_DATA_DESCR);
        try {
            s.begin();
            this.wcs.delete(data);
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(PropertyData data, ChangedSizeHandler sizeHandler) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(DELETE_PROPERTY_DATA_DESCR);
        try {
            s.begin();
            this.wcs.delete(data, sizeHandler);
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLastOrderNumber(NodeData parent) throws RepositoryException {
        Statistics s = ALL_STATISTICS.get(GET_LAST_ORDER_NUMBER_DESCR);
        try {
            s.begin();
            int n = this.wcs.getLastOrderNumber(parent);
            return n;
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChildNodesCount(NodeData parent) throws RepositoryException {
        Statistics s = ALL_STATISTICS.get(GET_CHILD_NODES_COUNT_DESCR);
        try {
            s.begin();
            int n = this.wcs.getChildNodesCount(parent);
            return n;
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(GET_CHILD_NODES_DATA_DESCR);
        try {
            s.begin();
            List<NodeData> list = this.wcs.getChildNodesData(parent);
            return list;
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData parent, List<QPathEntryFilter> pattern) throws RepositoryException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(GET_CHILD_NODES_DATA_PATTERN_DESCR);
        try {
            s.begin();
            List<NodeData> list = this.wcs.getChildNodesData(parent, pattern);
            return list;
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(GET_CHILD_PROPERTIES_DATA_DESCR);
        try {
            s.begin();
            List<PropertyData> list = this.wcs.getChildPropertiesData(parent);
            return list;
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent, List<QPathEntryFilter> pattern) throws RepositoryException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(GET_CHILD_PROPERTIES_DATA_PATTERN_DESCR);
        try {
            s.begin();
            List<PropertyData> list = this.wcs.getChildPropertiesData(parent, pattern);
            return list;
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name, ItemType itemType) throws RepositoryException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(GET_ITEM_DATA_BY_NODE_DATA_NQ_PATH_ENTRY_DESCR);
        try {
            s.begin();
            ItemData itemData = this.wcs.getItemData(parentData, name, itemType);
            return itemData;
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemData getItemData(String identifier) throws RepositoryException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(GET_ITEM_DATA_BY_ID_DESCR);
        try {
            s.begin();
            ItemData itemData = this.wcs.getItemData(identifier);
            return itemData;
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getReferencesData(String nodeIdentifier) throws RepositoryException, IllegalStateException, UnsupportedOperationException {
        Statistics s = ALL_STATISTICS.get(GET_REFERENCES_DATA_DESCR);
        try {
            s.begin();
            List<PropertyData> list = this.wcs.getReferencesData(nodeIdentifier);
            return list;
        }
        finally {
            s.end();
        }
    }

    @Override
    public boolean isOpened() {
        Statistics s = ALL_STATISTICS.get(IS_OPENED_DESCR);
        try {
            s.begin();
            boolean bl = this.wcs.isOpened();
            return bl;
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> listChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(LIST_CHILD_PROPERTIES_DATA_DESCR);
        try {
            s.begin();
            List<PropertyData> list = this.wcs.listChildPropertiesData(parent);
            return list;
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getChildNodesDataByPage(NodeData parent, int fromOrderNum, int offset, int pageSize, List<NodeData> childs) throws RepositoryException {
        Statistics s = ALL_STATISTICS.get(GET_CHILD_NODES_DATA_BY_PAGE_DESCR);
        try {
            s.begin();
            boolean bl = this.wcs.getChildNodesDataByPage(parent, fromOrderNum, offset, pageSize, childs);
            return bl;
        }
        finally {
            s.end();
        }
    }

    @Override
    public void rename(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(RENAME_NODE_DATA_DESCR);
        try {
            s.begin();
            this.wcs.rename(data);
        }
        finally {
            s.end();
        }
    }

    @Override
    public void prepare() throws IllegalStateException, RepositoryException {
        Statistics s = ALL_STATISTICS.get(PREPARE_DESCR);
        try {
            s.begin();
            this.wcs.prepare();
        }
        finally {
            s.end();
        }
    }

    @Override
    public void rollback() throws IllegalStateException, RepositoryException {
        Statistics s = ALL_STATISTICS.get(ROLLBACK_DESCR);
        try {
            s.begin();
            this.wcs.rollback();
        }
        finally {
            s.end();
        }
    }

    @Override
    public void update(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(UPDATE_NODE_DATA_DESCR);
        try {
            s.begin();
            this.wcs.update(data);
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(PropertyData data, ChangedSizeHandler sizeHandler) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(UPDATE_PROPERTY_DATA_DESCR);
        try {
            s.begin();
            this.wcs.update(data, sizeHandler);
        }
        finally {
            s.end();
        }
    }

    @Override
    public List<ACLHolder> getACLHolders() throws RepositoryException, IllegalStateException, UnsupportedOperationException {
        Statistics s = ALL_STATISTICS.get(GET_ACL_HOLDERS);
        try {
            s.begin();
            List<ACLHolder> list = this.wcs.getACLHolders();
            return list;
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNodesCount() throws RepositoryException {
        Statistics s = ALL_STATISTICS.get(NODES_COUNT);
        try {
            s.begin();
            long l = this.wcs.getNodesCount();
            return l;
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasItemData(NodeData parentData, QPathEntry name, ItemType itemType) throws RepositoryException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(HAS_ITEM_DATA_DESCR);
        try {
            s.begin();
            boolean bl = this.wcs.hasItemData(parentData, name, itemType);
            return bl;
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getWorkspaceDataSize() throws RepositoryException {
        Statistics s = ALL_STATISTICS.get(GET_WORKSPACE_DATA_SIZE);
        try {
            s.begin();
            long l = this.wcs.getWorkspaceDataSize();
            return l;
        }
        finally {
            s.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNodeDataSize(String parentId) throws RepositoryException {
        Statistics s = ALL_STATISTICS.get(GET_NODE_DATA_SIZE);
        try {
            s.begin();
            long l = this.wcs.getWorkspaceDataSize();
            return l;
        }
        finally {
            s.end();
        }
    }

    static {
        ALL_STATISTICS.put(HAS_ITEM_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, HAS_ITEM_DATA_DESCR));
        ALL_STATISTICS.put(GET_ITEM_DATA_BY_ID_DESCR, new Statistics(GLOBAL_STATISTICS, GET_ITEM_DATA_BY_ID_DESCR));
        ALL_STATISTICS.put(GET_ITEM_DATA_BY_NODE_DATA_NQ_PATH_ENTRY_DESCR, new Statistics(GLOBAL_STATISTICS, GET_ITEM_DATA_BY_NODE_DATA_NQ_PATH_ENTRY_DESCR));
        ALL_STATISTICS.put(GET_CHILD_NODES_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, GET_CHILD_NODES_DATA_DESCR));
        ALL_STATISTICS.put(GET_CHILD_NODES_DATA_BY_PAGE_DESCR, new Statistics(GLOBAL_STATISTICS, GET_CHILD_NODES_DATA_BY_PAGE_DESCR));
        ALL_STATISTICS.put(GET_CHILD_NODES_DATA_PATTERN_DESCR, new Statistics(GLOBAL_STATISTICS, GET_CHILD_NODES_DATA_PATTERN_DESCR));
        ALL_STATISTICS.put(GET_CHILD_NODES_COUNT_DESCR, new Statistics(GLOBAL_STATISTICS, GET_CHILD_NODES_COUNT_DESCR));
        ALL_STATISTICS.put(GET_LAST_ORDER_NUMBER_DESCR, new Statistics(GLOBAL_STATISTICS, GET_LAST_ORDER_NUMBER_DESCR));
        ALL_STATISTICS.put(GET_CHILD_PROPERTIES_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, GET_CHILD_PROPERTIES_DATA_DESCR));
        ALL_STATISTICS.put(GET_CHILD_PROPERTIES_DATA_PATTERN_DESCR, new Statistics(GLOBAL_STATISTICS, GET_CHILD_PROPERTIES_DATA_PATTERN_DESCR));
        ALL_STATISTICS.put(LIST_CHILD_PROPERTIES_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, LIST_CHILD_PROPERTIES_DATA_DESCR));
        ALL_STATISTICS.put(GET_REFERENCES_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, GET_REFERENCES_DATA_DESCR));
        ALL_STATISTICS.put(GET_ACL_HOLDERS, new Statistics(GLOBAL_STATISTICS, GET_ACL_HOLDERS));
        ALL_STATISTICS.put(NODES_COUNT, new Statistics(GLOBAL_STATISTICS, NODES_COUNT));
        ALL_STATISTICS.put(COMMIT_DESCR, new Statistics(GLOBAL_STATISTICS, COMMIT_DESCR));
        ALL_STATISTICS.put(ADD_NODE_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, ADD_NODE_DATA_DESCR));
        ALL_STATISTICS.put(ADD_PROPERTY_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, ADD_PROPERTY_DATA_DESCR));
        ALL_STATISTICS.put(UPDATE_NODE_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, UPDATE_NODE_DATA_DESCR));
        ALL_STATISTICS.put(UPDATE_PROPERTY_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, UPDATE_PROPERTY_DATA_DESCR));
        ALL_STATISTICS.put(DELETE_NODE_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, DELETE_NODE_DATA_DESCR));
        ALL_STATISTICS.put(DELETE_PROPERTY_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, DELETE_PROPERTY_DATA_DESCR));
        ALL_STATISTICS.put(RENAME_NODE_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, RENAME_NODE_DATA_DESCR));
        ALL_STATISTICS.put(ROLLBACK_DESCR, new Statistics(GLOBAL_STATISTICS, ROLLBACK_DESCR));
        ALL_STATISTICS.put(PREPARE_DESCR, new Statistics(GLOBAL_STATISTICS, PREPARE_DESCR));
        ALL_STATISTICS.put(IS_OPENED_DESCR, new Statistics(null, IS_OPENED_DESCR));
        ALL_STATISTICS.put(CLOSE_DESCR, new Statistics(null, CLOSE_DESCR));
        ALL_STATISTICS.put(GET_WORKSPACE_DATA_SIZE, new Statistics(null, GET_WORKSPACE_DATA_SIZE));
        ALL_STATISTICS.put(GET_NODE_DATA_SIZE, new Statistics(null, GET_NODE_DATA_SIZE));
        if (JDBCWorkspaceDataContainer.STATISTICS_ENABLED) {
            JCRStatisticsManager.registerStatistics(CATEGORY, GLOBAL_STATISTICS, ALL_STATISTICS);
        }
    }
}

