/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.event;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreResource;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;

public class StoreListeners
implements Localized {
    private final StoreListeners parent;
    private final Resource source;
    private volatile ForType<?> listeners;
    private volatile Set<Class<? extends StoreEvent>> permittedEventTypes;
    private static final Set<Class<? extends StoreEvent>> WARNING_EVENT_TYPE = Collections.singleton(WarningEvent.class);

    public StoreListeners(StoreListeners storeListeners, Resource resource) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)resource);
        this.source = resource;
        this.parent = storeListeners;
        if (storeListeners != null) {
            this.permittedEventTypes = storeListeners.permittedEventTypes;
        }
    }

    public Resource getSource() {
        return this.source;
    }

    private static DataStore getDataStore(StoreListeners storeListeners) {
        do {
            DataStore dataStore;
            Resource resource;
            if ((resource = storeListeners.source) instanceof DataStore) {
                return (DataStore)resource;
            }
            if (!(resource instanceof StoreResource) || (dataStore = ((StoreResource)resource).getOriginator()) == null) continue;
            return dataStore;
        } while ((storeListeners = storeListeners.parent) != null);
        return null;
    }

    public String getSourceName() {
        DataStore dataStore = StoreListeners.getDataStore(this);
        if (dataStore != null) {
            String string = dataStore.getDisplayName();
            if (string != null) {
                return string;
            }
            DataStoreProvider dataStoreProvider = dataStore.getProvider();
            if (dataStoreProvider != null && (string = dataStoreProvider.getShortName()) != null) {
                return string;
            }
        }
        return Vocabulary.getResources((Locale)this.getLocale()).getString((short)208);
    }

    public Locale getLocale() {
        DataStore dataStore = StoreListeners.getDataStore(this);
        return dataStore != null ? dataStore.getLocale() : null;
    }

    public Logger getLogger() {
        Resource resource = this.source;
        DataStore dataStore = StoreListeners.getDataStore(this);
        if (dataStore != null) {
            Logger logger;
            DataStoreProvider dataStoreProvider = dataStore.getProvider();
            if (dataStoreProvider != null && (logger = dataStoreProvider.getLogger()) != null) {
                return logger;
            }
            resource = dataStore;
        }
        return Logging.getLogger(resource.getClass());
    }

    public synchronized void useWarningEventsOnly() {
        Set<Class<? extends StoreEvent>> set = this.permittedEventTypes;
        if (set == null) {
            this.permittedEventTypes = WARNING_EVENT_TYPE;
        } else if (!WARNING_EVENT_TYPE.equals(set)) {
            throw this.illegalEventType(WarningEvent.class);
        }
        ForType.removeUnreachables(this.listeners, WARNING_EVENT_TYPE);
    }

    public void warning(String string) {
        ArgumentChecks.ensureNonNull((String)"message", (Object)string);
        this.warning(Level.WARNING, string, null);
    }

    public void warning(Exception exception) {
        ArgumentChecks.ensureNonNull((String)"exception", (Object)exception);
        this.warning(Level.WARNING, null, exception);
    }

    public void warning(String string, Exception exception) {
        this.warning(Level.WARNING, string, exception);
    }

    public void warning(Level level, String string, Exception exception) {
        LogRecord logRecord;
        StackTraceElement[] stackTraceElementArray;
        ArgumentChecks.ensureNonNull((String)"level", (Object)level);
        if (exception != null) {
            stackTraceElementArray = exception.getStackTrace();
            string = Exceptions.formatChainedMessages((Locale)this.getLocale(), (String)string, (Throwable)exception);
            if (string == null) {
                string = exception.toString();
            }
            logRecord = new LogRecord(level, string);
            logRecord.setThrown(exception);
        } else {
            ArgumentChecks.ensureNonEmpty((String)"message", (CharSequence)string);
            stackTraceElementArray = Thread.currentThread().getStackTrace();
            logRecord = new LogRecord(level, string);
        }
        try {
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (StoreListeners.setPublicSource(logRecord, Class.forName(stackTraceElement.getClassName()), stackTraceElement.getMethodName())) break;
            }
        }
        catch (ClassNotFoundException | SecurityException exception2) {
            Logging.ignorableException((Logger)StoreUtilities.LOGGER, StoreListeners.class, (String)"warning", (Throwable)exception2);
        }
        this.warning(logRecord, StoreUtilities.removeStackTraceInLogs());
    }

    private static boolean setPublicSource(LogRecord logRecord, Class<?> clazz, String string) {
        if (Resource.class.isAssignableFrom(clazz)) {
            logRecord.setSourceClassName(clazz.getCanonicalName());
            logRecord.setSourceMethodName(string);
            for (Method method : clazz.getMethods()) {
                if (!string.equals(method.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public void warning(LogRecord logRecord) {
        this.warning(logRecord, null);
    }

    public void warning(LogRecord logRecord, Filter filter) {
        if (!this.fire(new WarningEvent(this.source, logRecord), WarningEvent.class) && (filter == null || filter.isLoggable(logRecord))) {
            Logger logger;
            String string = logRecord.getLoggerName();
            if (string != null) {
                logger = Logging.getLogger((String)string);
            } else {
                logger = this.getLogger();
                logRecord.setLoggerName(logger.getName());
            }
            logger.log(logRecord);
        }
    }

    public <T extends StoreEvent> boolean fire(T t, Class<T> clazz) {
        ArgumentChecks.ensureNonNull((String)"event", t);
        ArgumentChecks.ensureNonNull((String)"eventType", clazz);
        Set<Class<? extends StoreEvent>> set = this.permittedEventTypes;
        if (set != null && !set.contains(clazz)) {
            throw this.illegalEventType(clazz);
        }
        Map<StoreListener<?>, Boolean> map = null;
        StoreListeners storeListeners = this;
        do {
            ForType<?> forType = storeListeners.listeners;
            while (forType != null) {
                if (forType.type.isAssignableFrom(clazz)) {
                    map = forType.eventOccured(t, map);
                }
                forType = forType.next;
            }
        } while ((storeListeners = storeListeners.parent) != null);
        return map != null && !map.isEmpty();
    }

    private IllegalArgumentException illegalEventType(Class<?> clazz) {
        return new IllegalArgumentException(Resources.forLocale(this.getLocale()).getString((short)65, clazz));
    }

    private static boolean isPossibleEvent(Set<Class<? extends StoreEvent>> set, Class<?> clazz) {
        if (set == null) {
            return true;
        }
        for (Class<? extends StoreEvent> clazz2 : set) {
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return true;
        }
        return false;
    }

    public synchronized <T extends StoreEvent> void addListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        ArgumentChecks.ensureNonNull((String)"listener", storeListener);
        ArgumentChecks.ensureNonNull((String)"eventType", clazz);
        if (StoreListeners.isPossibleEvent(this.permittedEventTypes, clazz)) {
            ForType<Object> forType = null;
            ForType<?> forType2 = this.listeners;
            while (forType2 != null) {
                if (forType2.type.equals(clazz)) {
                    forType = forType2;
                    break;
                }
                forType2 = forType2.next;
            }
            if (forType == null) {
                forType = new ForType<T>(clazz, this.listeners);
                this.listeners = forType;
            }
            forType.add(storeListener);
        }
    }

    public synchronized <T extends StoreEvent> void removeListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        ArgumentChecks.ensureNonNull((String)"listener", storeListener);
        ArgumentChecks.ensureNonNull((String)"eventType", clazz);
        ForType<?> forType = this.listeners;
        while (forType != null) {
            if (forType.type.equals(clazz)) {
                forType.remove(storeListener);
                break;
            }
            forType = forType.next;
        }
    }

    public boolean hasListeners(Class<? extends StoreEvent> clazz) {
        ArgumentChecks.ensureNonNull((String)"eventType", clazz);
        StoreListeners storeListeners = this;
        do {
            ForType<?> forType = storeListeners.listeners;
            while (forType != null) {
                if (clazz.isAssignableFrom(forType.type) && forType.hasListeners()) {
                    return true;
                }
                forType = forType.next;
            }
        } while ((storeListeners = storeListeners.parent) != null);
        return false;
    }

    public synchronized void setUsableEventTypes(Class<?> ... classArray) {
        ArgumentChecks.ensureNonEmpty((String)"permitted", (Object[])classArray);
        Set<Class<? extends StoreEvent>> set = this.permittedEventTypes;
        HashSet<Class<? extends StoreEvent>> hashSet = new HashSet<Class<? extends StoreEvent>>(Containers.hashMapCapacity((int)classArray.length));
        for (Class<?> clazz : classArray) {
            if (!(set != null ? set.contains(clazz) : StoreEvent.class.isAssignableFrom(clazz))) {
                throw this.illegalEventType(clazz);
            }
            hashSet.add(clazz);
        }
        this.permittedEventTypes = WARNING_EVENT_TYPE.equals(hashSet) ? WARNING_EVENT_TYPE : CollectionsExt.compact(hashSet);
        ForType.removeUnreachables(this.listeners, hashSet);
    }

    private static final class ForType<T extends StoreEvent> {
        final Class<T> type;
        private volatile StoreListener<? super T>[] listeners;
        final ForType<?> next;

        ForType(Class<T> clazz, ForType<?> forType) {
            this.type = clazz;
            this.next = forType;
        }

        final void add(StoreListener<? super T> storeListener) {
            StoreListener<? super T>[] storeListenerArray = this.listeners;
            int n = storeListenerArray != null ? storeListenerArray.length : 0;
            StoreListener[] storeListenerArray2 = new StoreListener[n + 1];
            if (storeListenerArray != null) {
                System.arraycopy(storeListenerArray, 0, storeListenerArray2, 0, n);
            }
            storeListenerArray2[n] = storeListener;
            this.listeners = storeListenerArray2;
        }

        final void remove(StoreListener<? super T> storeListener) {
            Object object = this.listeners;
            if (object != null) {
                int n = ((StoreListener<? super T>[])object).length;
                while (--n >= 0) {
                    if (object[n] != storeListener) continue;
                    object = ((StoreListener<? super T>[])object).length == 1 ? null : (StoreListener[])ArraysExt.remove((Object[])object, (int)n, (int)1);
                    this.listeners = object;
                    break;
                }
            }
        }

        static void removeUnreachables(ForType<?> forType, Set<Class<? extends StoreEvent>> set) {
            while (forType != null) {
                if (!StoreListeners.isPossibleEvent(set, forType.type)) {
                    forType.listeners = null;
                }
                forType = forType.next;
            }
        }

        final boolean hasListeners() {
            return this.listeners != null;
        }

        final Map<StoreListener<?>, Boolean> eventOccured(T t, Map<StoreListener<?>, Boolean> map) {
            StoreListener<? super T>[] storeListenerArray = this.listeners;
            if (storeListenerArray != null) {
                if (map == null) {
                    map = new IdentityHashMap(storeListenerArray.length);
                }
                for (StoreListener<T> storeListener : storeListenerArray) {
                    if (map.put(storeListener, Boolean.TRUE) != null) continue;
                    storeListener.eventOccured(t);
                }
            }
            return map;
        }
    }
}

