/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web.jakarta.internal;

import jakarta.servlet.http.Cookie;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.chain.web.MapEntry;
import org.apache.commons.chain.web.ParameterMap;

public class CookieMap<P>
extends ParameterMap<P, Cookie> {
    private final Supplier<Cookie[]> cookiesSupplier;

    public CookieMap(P request, Supplier<Cookie[]> cookiesSupplier) {
        super(request, null, null);
        this.cookiesSupplier = cookiesSupplier;
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        for (Cookie cookie : this.values()) {
            if (!cookie.equals(value)) continue;
            return true;
        }
        return false;
    }

    public Set<Map.Entry<String, Cookie>> entrySet() {
        HashSet<Map.Entry<String, Cookie>> set = new HashSet<Map.Entry<String, Cookie>>();
        for (Cookie cookie : this.values()) {
            set.add((Map.Entry<String, Cookie>)new MapEntry(cookie.getName(), (Object)cookie, false));
        }
        return set;
    }

    public Cookie get(Object key) {
        Collection<Cookie> cookies = this.values();
        if (!cookies.isEmpty()) {
            String skey = CookieMap.key((Object)key);
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(skey)) continue;
                return cookie;
            }
        }
        return null;
    }

    public boolean isEmpty() {
        Cookie[] cookies = this.cookiesSupplier.get();
        return cookies == null || cookies.length == 0;
    }

    public Set<String> keySet() {
        Collection<Cookie> cookies = this.values();
        HashSet<String> set = new HashSet<String>(Math.max((int)((float)cookies.size() / 0.75f) + 1, 16));
        for (Cookie cookie : cookies) {
            set.add(cookie.getName());
        }
        return set;
    }

    public int size() {
        Cookie[] cookies = this.cookiesSupplier.get();
        return cookies == null ? 0 : cookies.length;
    }

    public Collection<Cookie> values() {
        Cookie[] cookies = this.cookiesSupplier.get();
        return cookies == null ? Collections.emptyList() : Arrays.asList(cookies);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

