/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.image.ImagingOpException;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.apache.sis.image.ErrorHandler;
import org.apache.sis.util.logging.Logging;

enum ErrorAction implements ErrorHandler
{
    THROW,
    LOG;


    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(ErrorHandler.Report report) {
        ErrorHandler.Report report2 = report;
        synchronized (report2) {
            LogRecord logRecord = report.getDescription();
            if (logRecord != null) {
                if (this == LOG) {
                    String string = logRecord.getLoggerName();
                    if (string == null) {
                        string = "org.apache.sis.raster";
                        logRecord.setLoggerName(string);
                    }
                    Logging.getLogger((String)string).log(logRecord);
                } else {
                    Throwable throwable = logRecord.getThrown();
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    if (throwable instanceof ImagingOpException) {
                        throw (ImagingOpException)throwable;
                    }
                    String string = new SimpleFormatter().formatMessage(logRecord);
                    throw (ImagingOpException)new ImagingOpException(string).initCause(throwable);
                }
            }
        }
    }
}

