/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.script.groovy.jarjar;

import java.util.List;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.exoplatform.services.script.groovy.jarjar.Package;

class JarJarExpressionTransformer
extends ClassCodeExpressionTransformer {
    private final SourceUnit source;
    private final Package root;

    JarJarExpressionTransformer(SourceUnit source, Package root) {
        this.source = source;
        this.root = root;
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    public Expression transform(Expression expression) {
        PropertyExpression mce_pe;
        Expression expr;
        MethodCallExpression mce;
        if (expression instanceof MethodCallExpression && (mce = (MethodCallExpression)expression).getObjectExpression() instanceof PropertyExpression && (expr = this.bilto((Expression)(mce_pe = (PropertyExpression)mce.getObjectExpression()))) != null) {
            mce.setObjectExpression(expr);
        }
        return super.transform(expression);
    }

    private Expression bilto(Expression exp) {
        String s = exp.getText();
        List<String> ss = this.root.map2(exp);
        if (ss != null) {
            System.out.println(s + " -> " + String.valueOf(ss));
            return JarJarExpressionTransformer.createExpr(ss);
        }
        return null;
    }

    private static Expression createExpr(List<String> packageName) {
        if (packageName.isEmpty()) {
            throw new IllegalStateException("Root does not have prefix");
        }
        if (packageName.size() == 1) {
            String name = packageName.get(0);
            ClassNode objectCN = JarJarExpressionTransformer.getClassNode(Object.class);
            return new VariableExpression(name, objectCN);
        }
        Expression left = JarJarExpressionTransformer.createExpr(packageName.subList(0, packageName.size() - 1));
        ConstantExpression right = new ConstantExpression((Object)packageName.get(packageName.size() - 1));
        return new PropertyExpression(left, (Expression)right);
    }

    private static ClassNode getClassNode(Class<?> clazz) {
        return ClassHelper.make(clazz);
    }
}

