/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.ToStringUtils;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.OffsetCharSequence;
import org.exoplatform.services.jcr.impl.core.query.lucene.RangeScan;
import org.exoplatform.services.jcr.impl.core.query.lucene.TransformConstants;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

abstract class CaseTermQuery
extends MultiTermQuery
implements TransformConstants {
    private static final long serialVersionUID = -4178467977221437090L;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.CaseTermQuery");
    protected final int transform;
    private final Term term;

    CaseTermQuery(Term term, int transform) {
        this.term = term;
        this.transform = transform;
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new CaseTermEnum(this, reader);
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(':');
        }
        buffer.append(this.term.text());
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    private final class CaseTermEnum
    extends FilteredTermEnum {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CaseTermEnum(final CaseTermQuery caseTermQuery, IndexReader reader) throws IOException {
            final LinkedHashMap<Term, Integer> orderedTerms = new LinkedHashMap<Term, Integer>();
            ArrayList<RangeScan> rangeScans = new ArrayList<RangeScan>(2);
            int nameLength = FieldNames.getNameLength(caseTermQuery.term.text());
            String propName = caseTermQuery.term.text().substring(0, nameLength);
            OffsetCharSequence termText = new OffsetCharSequence(nameLength, caseTermQuery.term.text());
            OffsetCharSequence currentTerm = new OffsetCharSequence(nameLength, caseTermQuery.term.text(), caseTermQuery.transform);
            try {
                if (caseTermQuery.term.text().length() > nameLength) {
                    Object lowerLimit = new StringBuilder(propName);
                    String string = termText.toString();
                    String upperTermStr = string.toUpperCase();
                    String lowerTermStr = string.toLowerCase();
                    ((StringBuilder)lowerLimit).append(upperTermStr);
                    ((StringBuilder)lowerLimit).setCharAt(nameLength, Character.toLowerCase(((StringBuilder)lowerLimit).charAt(nameLength)));
                    StringBuilder upperLimit = new StringBuilder(propName);
                    upperLimit.append(lowerTermStr);
                    rangeScans.add(new RangeScan(reader, new Term(caseTermQuery.term.field(), ((StringBuilder)lowerLimit).toString()), new Term(caseTermQuery.term.field(), upperLimit.toString())));
                    lowerLimit = new StringBuilder(propName);
                    ((StringBuilder)lowerLimit).append(upperTermStr);
                    upperLimit = new StringBuilder(propName);
                    upperLimit.append(lowerTermStr);
                    upperLimit.setCharAt(nameLength, Character.toUpperCase(upperLimit.charAt(nameLength)));
                    rangeScans.add(new RangeScan(reader, new Term(caseTermQuery.term.field(), ((StringBuilder)lowerLimit).toString()), new Term(caseTermQuery.term.field(), upperLimit.toString())));
                } else {
                    rangeScans.add(new RangeScan(reader, caseTermQuery.term, caseTermQuery.term));
                }
                block7: for (TermEnum termEnum : rangeScans) {
                    Term t;
                    while ((t = termEnum.term()) != null) {
                        currentTerm.setBase(t.text());
                        int compare = currentTerm.compareTo(termText);
                        if (compare == 0) {
                            orderedTerms.put(t, termEnum.docFreq());
                        } else if (compare < 0) {
                            // empty if block
                        }
                        if (termEnum.next()) continue;
                        continue block7;
                    }
                }
            }
            finally {
                for (TermEnum termEnum : rangeScans) {
                    try {
                        termEnum.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
            final Iterator it = orderedTerms.keySet().iterator();
            this.setEnum(new TermEnum(this){
                private Term current;
                {
                    this.getNext();
                }

                public boolean next() {
                    this.getNext();
                    return this.current != null;
                }

                public Term term() {
                    return this.current;
                }

                public int docFreq() {
                    Integer docFreq = (Integer)orderedTerms.get(this.current);
                    return docFreq != null ? docFreq : 0;
                }

                public void close() {
                }

                private void getNext() {
                    this.current = it.hasNext() ? (Term)it.next() : null;
                }
            });
        }

        protected boolean termCompare(Term term) {
            return true;
        }

        public float difference() {
            return 1.0f;
        }

        protected boolean endEnum() {
            return false;
        }
    }

    static final class Lower
    extends CaseTermQuery {
        private static final long serialVersionUID = -2496607808944458354L;

        Lower(Term term) {
            super(term, 1);
        }
    }

    static final class Upper
    extends CaseTermQuery {
        private static final long serialVersionUID = 4125411301640753714L;

        Upper(Term term) {
            super(term, 2);
        }
    }
}

