/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.lucene.search.Query;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.query.lucene.ExcerptProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SimpleExcerptProvider
implements ExcerptProvider {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.SimpleExcerptProvider");
    private ItemDataConsumer ism;

    @Override
    public void init(Query query, SearchIndex index) throws IOException {
        this.ism = index.getContext().getItemStateManager();
    }

    @Override
    public String getExcerpt(String id, int maxFragments, int maxFragmentSize) throws IOException {
        StringBuilder text = new StringBuilder();
        try {
            ItemData node = this.ism.getItemData(id);
            String separator = "";
            List<PropertyData> childs = this.ism.getChildPropertiesData((NodeData)node);
            for (PropertyData property : childs) {
                if (property.getType() != 1) continue;
                text.append(separator);
                separator = " ... ";
                List<ValueData> values = property.getValues();
                for (int i = 0; i < values.size(); ++i) {
                    text.append(ValueDataUtil.getString(values.get(i)));
                }
            }
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getLocalizedMessage());
        }
        if (text.length() > maxFragmentSize) {
            int lastSpace = text.lastIndexOf(" ", maxFragmentSize);
            if (lastSpace != -1) {
                text.setLength(lastSpace);
            } else {
                text.setLength(maxFragmentSize);
            }
            text.append(" ...");
        }
        return "<excerpt><fragment>" + text.toString() + "</fragment></excerpt>";
    }
}

