/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.RepositoryException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.services.ispn.DistributedCacheManager;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.config.CacheEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedNodeData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.dataflow.persistent.WorkspaceStorageCache;
import org.exoplatform.services.jcr.dataflow.persistent.WorkspaceStorageCacheListener;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.NullItemData;
import org.exoplatform.services.jcr.datamodel.NullNodeData;
import org.exoplatform.services.jcr.datamodel.NullPropertyData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.DataRestoreContext;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.SpoolConfig;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CleanableFilePersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.SimplePersistedSize;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.BufferedISPNCache;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CacheId;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CacheNodesByPageId;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CacheNodesId;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CachePatternNodesId;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CachePatternPropsId;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CachePropsId;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CacheQPath;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CacheRefsId;
import org.exoplatform.services.jcr.infinispan.AbstractMapper;
import org.exoplatform.services.jcr.infinispan.CacheKey;
import org.exoplatform.services.jcr.infinispan.ISPNCacheFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.transaction.ActionNonTxAware;
import org.exoplatform.services.transaction.TransactionService;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.picocontainer.Startable;

public class ISPNCacheWorkspaceStorageCache
implements WorkspaceStorageCache,
Backupable,
Startable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ISPNCacheWorkspaceStorageCache");
    private static final String CACHE_NAME = "JCRCache";
    protected final String ownerId;
    private final boolean enabled;
    private final long lifespan;
    protected final BufferedISPNCache cache;
    private final GlobalOperationCaller caller;
    private final List<WorkspaceStorageCacheListener> listeners = new CopyOnWriteArrayList<WorkspaceStorageCacheListener>();
    private final CacheActionNonTxAware<Void, Void> commitTransaction = new CacheActionNonTxAware<Void, Void>(){

        @Override
        protected Void execute(Void arg) {
            ISPNCacheWorkspaceStorageCache.this.cache.commitTransaction();
            return null;
        }
    };
    private final CacheActionNonTxAware<ItemData, String> getFromCacheById = new CacheActionNonTxAware<ItemData, String>(){

        @Override
        protected ItemData execute(String id) {
            return id == null ? null : (ItemData)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheId(ISPNCacheWorkspaceStorageCache.this.getOwnerId(), id));
        }
    };
    private final CacheActionNonTxAware<ItemData, String> getFromBufferedCacheById = new CacheActionNonTxAware<ItemData, String>(){

        @Override
        protected ItemData execute(String id) {
            return id == null ? null : (ItemData)ISPNCacheWorkspaceStorageCache.this.cache.getFromBuffer(new CacheId(ISPNCacheWorkspaceStorageCache.this.getOwnerId(), id));
        }
    };
    private final CacheActionNonTxAware<List<NodeData>, NodeData> getChildNodes = new CacheActionNonTxAware<List<NodeData>, NodeData>(){

        @Override
        protected List<NodeData> execute(NodeData parent) {
            Set set = (Set)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheNodesId(ISPNCacheWorkspaceStorageCache.this.getOwnerId(), parent.getIdentifier()));
            if (set != null) {
                if (set instanceof FakeValueSet) {
                    return null;
                }
                ArrayList<NodeData> childs = new ArrayList<NodeData>();
                for (String childId : set) {
                    NodeData child = (NodeData)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheId(ISPNCacheWorkspaceStorageCache.this.getOwnerId(), childId));
                    if (child == null) {
                        return null;
                    }
                    childs.add(child);
                }
                Collections.sort(childs, new NodesOrderComparator(ISPNCacheWorkspaceStorageCache.this));
                return childs;
            }
            return null;
        }
    };
    private final CacheActionNonTxAware<ItemData, Object> getFromCacheByPath = new CacheActionNonTxAware<ItemData, Object>(){

        @Override
        protected ItemData execute(Object ... args) {
            String parentIdentifier = (String)args[0];
            QPathEntry name = (QPathEntry)args[1];
            ItemType itemType = (ItemType)((Object)args[2]);
            String itemId = null;
            if (itemType == ItemType.UNKNOWN) {
                String propId;
                itemId = (String)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheQPath(ISPNCacheWorkspaceStorageCache.this.getOwnerId(), parentIdentifier, name, ItemType.NODE));
                if ((itemId == null || itemId.equals("_null_id")) && (propId = (String)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheQPath(ISPNCacheWorkspaceStorageCache.this.getOwnerId(), parentIdentifier, name, ItemType.PROPERTY))) != null) {
                    itemId = propId;
                }
            } else {
                itemId = itemType == ItemType.NODE ? (String)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheQPath(ISPNCacheWorkspaceStorageCache.this.getOwnerId(), parentIdentifier, name, ItemType.NODE)) : (String)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheQPath(ISPNCacheWorkspaceStorageCache.this.getOwnerId(), parentIdentifier, name, ItemType.PROPERTY));
            }
            if (itemId != null) {
                if (itemId.equals("_null_id")) {
                    if (itemType == ItemType.UNKNOWN || itemType == ItemType.NODE) {
                        return new NullNodeData();
                    }
                    return new NullPropertyData();
                }
                return ISPNCacheWorkspaceStorageCache.this.get(itemId);
            }
            return null;
        }
    };
    private final CacheActionNonTxAware<Integer, NodeData> getChildNodesCount = new CacheActionNonTxAware<Integer, NodeData>(){

        @Override
        protected Integer execute(NodeData parent) {
            Set list = (Set)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheNodesId(ISPNCacheWorkspaceStorageCache.this.getOwnerId(), parent.getIdentifier()));
            return list != null ? list.size() : -1;
        }
    };
    private final CacheActionNonTxAware<List<PropertyData>, Object> getChildProps = new CacheActionNonTxAware<List<PropertyData>, Object>(){

        @Override
        protected List<PropertyData> execute(Object ... args) {
            String parentId = (String)args[0];
            boolean withValue = (Boolean)args[1];
            Set set = (Set)ISPNCacheWorkspaceStorageCache.this.cache.get(new CachePropsId(ISPNCacheWorkspaceStorageCache.this.getOwnerId(), parentId));
            if (set != null) {
                ArrayList<PropertyData> childs = new ArrayList<PropertyData>();
                for (String childId : set) {
                    PropertyData child = (PropertyData)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheId(ISPNCacheWorkspaceStorageCache.this.getOwnerId(), childId));
                    if (child == null) {
                        return null;
                    }
                    if (withValue && child.getValues().size() <= 0) {
                        return null;
                    }
                    childs.add(child);
                }
                return childs;
            }
            return null;
        }
    };
    private final CacheActionNonTxAware<List<PropertyData>, String> getReferencedProperties = new CacheActionNonTxAware<List<PropertyData>, String>(){

        @Override
        protected List<PropertyData> execute(String identifier) {
            Set set = (Set)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheRefsId(ISPNCacheWorkspaceStorageCache.this.getOwnerId(), identifier));
            if (set != null) {
                ArrayList<PropertyData> props = new ArrayList<PropertyData>();
                for (String childId : set) {
                    PropertyData prop = (PropertyData)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheId(ISPNCacheWorkspaceStorageCache.this.getOwnerId(), childId));
                    if (prop == null || prop instanceof NullItemData) {
                        return null;
                    }
                    List<ValueData> lData = prop.getValues();
                    int length = lData.size();
                    for (int i = 0; i < length; ++i) {
                        ValueData vdata = lData.get(i);
                        try {
                            if (!ValueDataUtil.getString(vdata).equals(identifier)) continue;
                            props.add(prop);
                            continue;
                        }
                        catch (IllegalStateException e) {
                            return null;
                        }
                        catch (RepositoryException e) {
                            return null;
                        }
                    }
                }
                return props;
            }
            return null;
        }
    };
    private final CacheActionNonTxAware<Long, Void> getSize = new CacheActionNonTxAware<Long, Void>(){

        @Override
        protected Long execute(Void arg) {
            return ISPNCacheWorkspaceStorageCache.this.caller.getCacheSize();
        }
    };

    public ISPNCacheWorkspaceStorageCache(WorkspaceEntry wsConfig, ConfigurationManager cfm) throws RepositoryException, RepositoryConfigurationException {
        this(null, wsConfig, cfm, null, null);
    }

    public ISPNCacheWorkspaceStorageCache(ExoContainerContext ctx, WorkspaceEntry wsConfig, ConfigurationManager cfm, TransactionService ts) throws RepositoryException, RepositoryConfigurationException {
        this(ctx, wsConfig, cfm, null, ts);
    }

    public ISPNCacheWorkspaceStorageCache(ExoContainerContext ctx, WorkspaceEntry wsConfig, ConfigurationManager cfm, DistributedCacheManager dcm) throws RepositoryException, RepositoryConfigurationException {
        this(ctx, wsConfig, cfm, dcm, null);
    }

    public ISPNCacheWorkspaceStorageCache(ExoContainerContext ctx, WorkspaceEntry wsConfig, ConfigurationManager cfm, DistributedCacheManager dcm, TransactionService ts) throws RepositoryException, RepositoryConfigurationException {
        Cache parentCache;
        if (wsConfig.getCache() == null) {
            throw new RepositoryConfigurationException("Cache configuration not found");
        }
        this.enabled = wsConfig.getCache().isEnabled();
        this.lifespan = SpoolConfig.liveTime;
        ISPNCacheFactory factory = new ISPNCacheFactory(cfm, ts == null ? null : ts.getTransactionManager());
        CacheEntry cacheEntry = wsConfig.getCache();
        boolean useDistributedCache = cacheEntry.getParameterBoolean("use-distributed-cache", false);
        if (useDistributedCache) {
            if (dcm == null) {
                throw new IllegalArgumentException("The DistributedCacheManager has not been defined in the configuration, please configure it at root container level if you want to use a distributed cache.");
            }
            parentCache = dcm.getCache(CACHE_NAME);
            this.ownerId = ctx.getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The distributed cache has been enabled for the workspace whose unique id is " + this.ownerId));
            }
        } else {
            parentCache = factory.createCache("Data_" + wsConfig.getUniqueName(), cacheEntry);
            Configuration config = parentCache.getCacheConfiguration();
            if (config.clustering().cacheMode() == CacheMode.DIST_SYNC || config.clustering().cacheMode() == CacheMode.DIST_ASYNC) {
                throw new IllegalArgumentException("Cache configuration not allowed, if you want to use the distributed cache please enable the parameter 'use-distributed-cache' and configure the DistributedCacheManager.");
            }
            this.ownerId = null;
        }
        Boolean allowLocalChanges = useDistributedCache ? cacheEntry.getParameterBoolean("allow-local-changes", Boolean.TRUE) : Boolean.TRUE;
        this.cache = new BufferedISPNCache(parentCache, allowLocalChanges);
        if (useDistributedCache) {
            this.caller = new DistributedOperationCaller();
        } else {
            this.caller = new GlobalOperationCaller();
            this.cache.addListener(new CacheEventListener());
        }
        this.cache.start();
    }

    private boolean isDistributedMode() {
        return this.ownerId != null;
    }

    private String getOwnerId() {
        return this.ownerId;
    }

    public TransactionManager getTransactionManager() {
        return this.cache.getTransactionManager();
    }

    @Override
    public void put(ItemData item) {
        if (item instanceof NullItemData) {
            this.putNullItem((NullItemData)item);
            return;
        }
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            if (item.isNode()) {
                this.putNode((NodeData)item, ModifyChildOption.NOT_MODIFY);
            } else {
                this.putProperty((PropertyData)item, ModifyChildOption.NOT_MODIFY);
            }
        }
        finally {
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
    }

    @Override
    public void remove(ItemData item) {
        this.removeItem(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String identifier, ItemData item) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            this.cache.remove(new CacheId(this.getOwnerId(), identifier), item);
        }
        finally {
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSaveItems(ItemStateChangesLog itemStates) {
        boolean rollback = true;
        try {
            ItemState lastDelete = null;
            this.cache.beginTransaction();
            Set<String> idsToSkip = null;
            List<ItemState> states = itemStates.getAllStates();
            int length = states.size();
            for (int i = 0; i < length; ++i) {
                ItemState state = states.get(i);
                if (state.isAdded()) {
                    if (state.isPersisted()) {
                        this.putItem(state.getData());
                    }
                } else if (state.isUpdated()) {
                    if (state.isPersisted()) {
                        ItemData prevItem = this.putItemInBufferedCache(state.getData());
                        if (state.isNode() && (prevItem != null || state.getOldPath() != null)) {
                            ItemState nextState;
                            idsToSkip = this.updateInBuffer((NodeData)state.getData(), prevItem != null ? prevItem.getQPath() : state.getOldPath(), idsToSkip);
                            if (!(i + 1 >= length || (nextState = states.get(i + 1)).isUpdated() && nextState.isNode() && nextState.isPersisted())) {
                                idsToSkip = null;
                            }
                        }
                    }
                } else if (state.isDeleted()) {
                    if (state.isPersisted()) {
                        this.removeItem(state.getData());
                    }
                } else if (state.isRenamed()) {
                    this.renameItem(state, lastDelete);
                } else if (state.isPathChanged()) {
                    this.updateTreePath(state.getOldPath(), state.getData().getQPath(), null);
                } else if (state.isMixinChanged() && state.isPersisted()) {
                    this.updateMixin((NodeData)state.getData());
                }
                if (!state.isDeleted()) continue;
                lastDelete = state;
            }
            this.cache.commitTransaction();
            rollback = false;
        }
        finally {
            if (rollback) {
                this.cache.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildNodesByPage(NodeData parent, List<NodeData> childs, int fromOrderNum) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            CacheNodesByPageId cacheId = new CacheNodesByPageId(this.getOwnerId(), parent.getIdentifier());
            HashMap pages = (HashMap)this.cache.get(cacheId);
            if (pages == null) {
                pages = new HashMap();
            }
            HashSet<String> set = new HashSet<String>();
            for (NodeData child : childs) {
                this.putNode(child, ModifyChildOption.NOT_MODIFY);
                set.add(child.getIdentifier());
            }
            pages.put(fromOrderNum, set);
            this.cache.put(cacheId, pages);
        }
        finally {
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildNodes(NodeData parent, List<NodeData> childs) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            HashSet<String> set = new HashSet<String>();
            for (NodeData child : childs) {
                this.putNode(child, ModifyChildOption.NOT_MODIFY);
                set.add(child.getIdentifier());
            }
            this.cache.putIfAbsent(new CacheNodesId(this.getOwnerId(), parent.getIdentifier()), set);
        }
        finally {
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildNodes(NodeData parent, QPathEntryFilter pattern, List<NodeData> childs) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            HashSet<String> set = new HashSet<String>();
            for (NodeData child : childs) {
                this.putNode(child, ModifyChildOption.NOT_MODIFY);
                set.add(child.getIdentifier());
            }
            CachePatternNodesId cacheId = new CachePatternNodesId(this.getOwnerId(), parent.getIdentifier());
            HashMap patterns = (HashMap)this.cache.get(cacheId);
            if (patterns == null) {
                patterns = new HashMap();
            }
            patterns.put(pattern, set);
            this.cache.put(cacheId, patterns);
        }
        finally {
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildProperties(NodeData parent, List<PropertyData> childs) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            if (childs.size() > 0) {
                HashSet<String> set = new HashSet<String>();
                for (PropertyData child : childs) {
                    this.putProperty(child, ModifyChildOption.NOT_MODIFY);
                    set.add(child.getIdentifier());
                }
                this.cache.putIfAbsent(new CachePropsId(this.getOwnerId(), parent.getIdentifier()), set);
            } else {
                LOG.warn((Object)("Empty properties list cached " + String.valueOf(parent != null ? parent.getQPath().getAsString() : parent)));
            }
        }
        finally {
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildProperties(NodeData parent, QPathEntryFilter pattern, List<PropertyData> childs) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            if (childs.size() > 0) {
                HashSet<String> set = new HashSet<String>();
                for (PropertyData child : childs) {
                    this.putProperty(child, ModifyChildOption.NOT_MODIFY);
                    set.add(child.getIdentifier());
                }
                CachePatternPropsId cacheId = new CachePatternPropsId(this.getOwnerId(), parent.getIdentifier());
                HashMap patterns = (HashMap)this.cache.get(cacheId);
                if (patterns == null) {
                    patterns = new HashMap();
                }
                patterns.put(pattern, set);
                this.cache.put(cacheId, patterns);
            }
        }
        finally {
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
    }

    @Override
    public void addChildPropertiesList(NodeData parent, List<PropertyData> childProperties) {
    }

    @Override
    public ItemData get(String parentIdentifier, QPathEntry name, ItemType itemType) {
        return (ItemData)this.getFromCacheByPath.run(new Object[]{parentIdentifier, name, itemType});
    }

    @Override
    public ItemData get(String id) {
        return (ItemData)this.getFromCacheById.run(id);
    }

    @Override
    public List<NodeData> getChildNodes(NodeData parent) {
        return (List)this.getChildNodes.run(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildNodesCount(NodeData parent, int count) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            this.cache.putIfAbsent(new CacheNodesId(this.getOwnerId(), parent.getIdentifier()), (Object)new FakeValueSet(count));
        }
        finally {
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
    }

    @Override
    public List<NodeData> getChildNodesByPage(NodeData parent, int fromOrderNum) {
        Map pages = (Map)this.cache.get(new CacheNodesByPageId(this.getOwnerId(), parent.getIdentifier()));
        if (pages == null) {
            return null;
        }
        Set set = (Set)pages.get(fromOrderNum);
        if (set == null) {
            return null;
        }
        ArrayList<NodeData> childs = new ArrayList<NodeData>();
        for (String childId : set) {
            NodeData child = (NodeData)this.cache.get(new CacheId(this.getOwnerId(), childId));
            if (child == null) {
                return null;
            }
            childs.add(child);
        }
        Collections.sort(childs, new NodesOrderComparator(this));
        return childs;
    }

    @Override
    public List<NodeData> getChildNodes(NodeData parent, QPathEntryFilter pattern) {
        Map patterns = (Map)this.cache.get(new CachePatternNodesId(this.getOwnerId(), parent.getIdentifier()));
        if (patterns == null) {
            return null;
        }
        Set set = (Set)patterns.get(pattern);
        if (set == null) {
            return null;
        }
        ArrayList<NodeData> childs = new ArrayList<NodeData>();
        for (String childId : set) {
            NodeData child = (NodeData)this.cache.get(new CacheId(this.getOwnerId(), childId));
            if (child == null) {
                return null;
            }
            childs.add(child);
        }
        Collections.sort(childs, new NodesOrderComparator(this));
        return childs;
    }

    @Override
    public int getChildNodesCount(NodeData parent) {
        return (Integer)this.getChildNodesCount.run(parent);
    }

    @Override
    public List<PropertyData> getChildProperties(NodeData parent) {
        return this.getChildProps(parent.getIdentifier(), true);
    }

    @Override
    public List<PropertyData> getChildProperties(NodeData parent, QPathEntryFilter pattern) {
        Map patterns = (Map)this.cache.get(new CachePatternPropsId(this.getOwnerId(), parent.getIdentifier()));
        if (patterns == null) {
            return null;
        }
        Set set = (Set)patterns.get(pattern);
        if (set == null) {
            return null;
        }
        ArrayList<PropertyData> childs = new ArrayList<PropertyData>();
        for (String childId : set) {
            PropertyData child = (PropertyData)this.cache.get(new CacheId(this.getOwnerId(), childId));
            if (child == null) {
                return null;
            }
            if (child.getValues().size() <= 0) {
                return null;
            }
            childs.add(child);
        }
        return childs;
    }

    @Override
    public List<PropertyData> listChildProperties(NodeData parent) {
        return this.getChildProps(parent.getIdentifier(), false);
    }

    protected List<PropertyData> getChildProps(String parentId, boolean withValue) {
        return (List)this.getChildProps.run(parentId, withValue);
    }

    @Override
    public long getSize() {
        return (Long)this.getSize.run();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isPatternSupported() {
        return true;
    }

    @Override
    public boolean isChildNodesByPageSupported() {
        return true;
    }

    protected ItemData putItem(ItemData item) {
        if (item.isNode()) {
            return this.putNode((NodeData)item, ModifyChildOption.MODIFY);
        }
        return this.putProperty((PropertyData)item, ModifyChildOption.MODIFY);
    }

    protected ItemData putItemInBufferedCache(ItemData item) {
        if (item.isNode()) {
            return this.putNodeInBufferedCache((NodeData)item, ModifyChildOption.MODIFY);
        }
        return this.putProperty((PropertyData)item, ModifyChildOption.MODIFY);
    }

    protected ItemData putNode(NodeData node, ModifyChildOption modifyListsOfChild) {
        if (node.getParentIdentifier() != null) {
            if (modifyListsOfChild == ModifyChildOption.NOT_MODIFY) {
                this.cache.putIfAbsent(new CacheQPath(this.getOwnerId(), node.getParentIdentifier(), node.getQPath(), ItemType.NODE), (Object)node.getIdentifier());
            } else {
                this.cache.put(new CacheQPath(this.getOwnerId(), node.getParentIdentifier(), node.getQPath(), ItemType.NODE), (Object)node.getIdentifier());
            }
            if (modifyListsOfChild != ModifyChildOption.NOT_MODIFY) {
                this.cache.addToPatternList(new CachePatternNodesId(this.getOwnerId(), node.getParentIdentifier()), node);
                this.cache.addToList(new CacheNodesId(this.getOwnerId(), node.getParentIdentifier()), node.getIdentifier(), modifyListsOfChild == ModifyChildOption.FORCE_MODIFY);
                this.cache.remove(new CacheNodesByPageId(this.getOwnerId(), node.getParentIdentifier()));
            }
        }
        if (modifyListsOfChild == ModifyChildOption.NOT_MODIFY) {
            return (ItemData)this.cache.putIfAbsent(new CacheId(this.getOwnerId(), node.getIdentifier()), (Object)node);
        }
        return (ItemData)this.cache.put(new CacheId(this.getOwnerId(), node.getIdentifier()), node, true);
    }

    protected ItemData putNodeInBufferedCache(NodeData node, ModifyChildOption modifyListsOfChild) {
        ItemData itemData;
        if (node.getParentIdentifier() != null) {
            this.cache.put(new CacheQPath(this.getOwnerId(), node.getParentIdentifier(), node.getQPath(), ItemType.NODE), (Object)node.getIdentifier());
            if (modifyListsOfChild != ModifyChildOption.NOT_MODIFY) {
                this.cache.addToList(new CacheNodesId(this.getOwnerId(), node.getParentIdentifier()), node.getIdentifier(), modifyListsOfChild == ModifyChildOption.FORCE_MODIFY);
            }
        }
        return (itemData = (ItemData)this.cache.putInBuffer(new CacheId(this.getOwnerId(), node.getIdentifier()), node)) instanceof NullItemData ? null : itemData;
    }

    protected void putNullItem(NullItemData item) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            if (!item.getIdentifier().equals("_null_id")) {
                this.cache.putIfAbsent(new CacheId(this.getOwnerId(), item.getIdentifier()), (Object)item);
            } else if (item.getName() != null && item.getParentIdentifier() != null) {
                this.cache.putIfAbsent(new CacheQPath(this.getOwnerId(), item.getParentIdentifier(), item.getName(), ItemType.getItemType(item)), (Object)"_null_id");
            }
        }
        finally {
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
    }

    protected PropertyData putProperty(PropertyData prop, ModifyChildOption modifyListsOfChild) {
        boolean forceLifespan;
        boolean bl = forceLifespan = this.lifespan > 0L && prop.getValues() != null && prop.getValues().size() > 0 && (prop.getValues().get(0) instanceof CleanableFilePersistedValueData || prop.getValues().get(0) instanceof StreamPersistedValueData);
        if (modifyListsOfChild != ModifyChildOption.NOT_MODIFY) {
            this.cache.addToPatternList(new CachePatternPropsId(this.getOwnerId(), prop.getParentIdentifier()), prop);
            this.cache.addToList(new CachePropsId(this.getOwnerId(), prop.getParentIdentifier()), prop.getIdentifier(), modifyListsOfChild == ModifyChildOption.FORCE_MODIFY);
        }
        if (modifyListsOfChild == ModifyChildOption.NOT_MODIFY) {
            this.cache.putIfAbsent(new CacheQPath(this.getOwnerId(), prop.getParentIdentifier(), prop.getQPath(), ItemType.PROPERTY), (Object)prop.getIdentifier());
        } else {
            this.cache.put(new CacheQPath(this.getOwnerId(), prop.getParentIdentifier(), prop.getQPath(), ItemType.PROPERTY), (Object)prop.getIdentifier());
        }
        if (modifyListsOfChild != ModifyChildOption.NOT_MODIFY && prop.getType() == 9) {
            List<ValueData> lData = prop.getValues();
            int length = lData.size();
            for (int i = 0; i < length; ++i) {
                String nodeIdentifier;
                block9: {
                    ValueData vdata = lData.get(i);
                    nodeIdentifier = null;
                    try {
                        nodeIdentifier = ValueDataUtil.getString(vdata);
                    }
                    catch (IllegalStateException e) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                        }
                    }
                    catch (RepositoryException e) {
                        if (!LOG.isTraceEnabled()) break block9;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
                this.cache.addToList(new CacheRefsId(this.getOwnerId(), nodeIdentifier), prop.getIdentifier(), modifyListsOfChild == ModifyChildOption.FORCE_MODIFY);
            }
        }
        ItemData returnedData = modifyListsOfChild == ModifyChildOption.NOT_MODIFY ? (forceLifespan ? (ItemData)this.cache.putIfAbsent(new CacheId(this.getOwnerId(), prop.getIdentifier()), prop, this.lifespan) : (ItemData)this.cache.putIfAbsent(new CacheId(this.getOwnerId(), prop.getIdentifier()), (Object)prop)) : (forceLifespan ? (ItemData)this.cache.put((CacheKey)new CacheId(this.getOwnerId(), prop.getIdentifier()), (Object)prop, true, this.lifespan) : (ItemData)this.cache.put(new CacheId(this.getOwnerId(), prop.getIdentifier()), prop, true));
        return returnedData instanceof NullItemData ? null : (PropertyData)returnedData;
    }

    protected void removeItem(ItemData item) {
        this.cache.remove(new CacheId(this.getOwnerId(), item.getIdentifier()));
        this.cache.remove(new CacheQPath(this.getOwnerId(), item.getParentIdentifier(), item.getQPath(), ItemType.getItemType(item)));
        if (item.isNode()) {
            if (item.getParentIdentifier() != null) {
                this.cache.removeFromPatternList(new CachePatternNodesId(this.getOwnerId(), item.getParentIdentifier()), item);
                this.cache.removeFromList(new CacheNodesId(this.getOwnerId(), item.getParentIdentifier()), item.getIdentifier());
                this.cache.remove(new CacheNodesByPageId(this.getOwnerId(), item.getParentIdentifier()));
            }
            this.cache.remove(new CacheNodesId(this.getOwnerId(), item.getIdentifier()));
            this.cache.remove(new CachePropsId(this.getOwnerId(), item.getIdentifier()));
            this.cache.remove(new CacheNodesByPageId(this.getOwnerId(), item.getIdentifier()));
            this.cache.remove(new CachePatternNodesId(this.getOwnerId(), item.getIdentifier()));
            this.cache.remove(new CachePatternPropsId(this.getOwnerId(), item.getIdentifier()));
            this.cache.remove(new CacheRefsId(this.getOwnerId(), item.getIdentifier()));
        } else {
            this.cache.removeFromPatternList(new CachePatternPropsId(this.getOwnerId(), item.getParentIdentifier()), item);
            this.cache.removeFromList(new CachePropsId(this.getOwnerId(), item.getParentIdentifier()), item.getIdentifier());
        }
    }

    protected void updateMixin(NodeData node) {
        NodeData prevData = (NodeData)this.cache.put(new CacheId(this.getOwnerId(), node.getIdentifier()), node, true);
        if (!(prevData instanceof NullNodeData)) {
            if (prevData != null) {
                if (prevData.getACL() == null || !prevData.getACL().equals(node.getACL())) {
                    this.updateChildsACL(node.getIdentifier(), node.getACL());
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Previous NodeData not found for mixin update " + node.getQPath().getAsString()));
            }
        }
    }

    protected Set<String> updateInBuffer(NodeData node, QPath prevPath, Set<String> idsToSkip) {
        int prevNodeIndex;
        int nodeIndex;
        CacheQPath prevKey = new CacheQPath(this.getOwnerId(), node.getParentIdentifier(), prevPath, ItemType.NODE);
        if (node.getIdentifier().equals(this.cache.getFromBuffer(prevKey))) {
            this.cache.remove(prevKey);
        }
        if ((nodeIndex = node.getQPath().getEntries()[node.getQPath().getEntries().length - 1].getIndex()) != (prevNodeIndex = prevPath.getEntries()[prevPath.getEntries().length - 1].getIndex())) {
            return this.updateTreePath(prevPath, node.getQPath(), idsToSkip);
        }
        return null;
    }

    protected Set<String> updateTreePath(QPath prevRootPath, QPath newRootPath, Set<String> idsToSkip) {
        return this.caller.updateTreePath(prevRootPath, newRootPath, idsToSkip);
    }

    protected void renameItem(ItemState state, ItemState lastDelete) {
        ItemData data = state.getData();
        ItemData prevData = (ItemData)this.getFromBufferedCacheById.run(data.getIdentifier());
        if (data.isNode()) {
            if (state.isPersisted()) {
                this.removeItem(lastDelete.getData());
                this.putItem(state.getData());
            } else {
                this.cache.put(new CacheId(this.getOwnerId(), data.getIdentifier()), data, false);
            }
        } else {
            PropertyData prop = (PropertyData)data;
            if (prevData != null && !(prevData instanceof NullItemData)) {
                PersistedPropertyData newProp = new PersistedPropertyData(prop.getIdentifier(), prop.getQPath(), prop.getParentIdentifier(), prop.getPersistedVersion(), prop.getType(), prop.isMultiValued(), ((PropertyData)prevData).getValues(), new SimplePersistedSize(((PersistedPropertyData)prevData).getPersistedSize()));
                this.cache.put(new CacheId(this.getOwnerId(), newProp.getIdentifier()), newProp, false);
            } else {
                this.cache.remove(new CacheId(this.getOwnerId(), data.getIdentifier()));
            }
        }
    }

    protected void updateChildsACL(String parentId, AccessControlList acl) {
        this.caller.updateChildsACL(parentId, acl);
    }

    @Override
    public void beginTransaction() {
        this.cache.beginTransaction();
    }

    @Override
    public void commitTransaction() {
        this.cache.commitTransaction();
    }

    @Override
    public void rollbackTransaction() {
        this.cache.rollbackTransaction();
    }

    @Override
    public boolean isTXAware() {
        return true;
    }

    private void dedicatedTxCommit() {
        this.commitTransaction.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReferencedProperties(String identifier, List<PropertyData> refProperties) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            HashSet<String> set = new HashSet<String>();
            for (PropertyData prop : refProperties) {
                this.putProperty(prop, ModifyChildOption.NOT_MODIFY);
                set.add(prop.getIdentifier());
            }
            this.cache.putIfAbsent(new CacheRefsId(this.getOwnerId(), identifier), set);
        }
        finally {
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
    }

    @Override
    public List<PropertyData> getReferencedProperties(String identifier) {
        return (List)this.getReferencedProperties.run(identifier);
    }

    @Override
    public void backup(File storageDir) throws BackupException {
    }

    @Override
    @Managed
    @ManagedDescription(value="Remove all the existing items from the cache")
    public void clean() throws BackupException {
        LOG.info((Object)"Start to clean all the existing items from ISPN cache");
        if (this.cache.getStatus() == ComponentStatus.RUNNING) {
            this.caller.clearCache();
        }
    }

    @Override
    public DataRestore getDataRestorer(DataRestoreContext context) throws BackupException {
        return new DataRestore(){

            @Override
            public void clean() throws BackupException {
                LOG.info((Object)"Start to clean all the existing items from ISPN cache");
                ISPNCacheWorkspaceStorageCache.this.caller.clearCache();
            }

            @Override
            public void restore() throws BackupException {
            }

            @Override
            public void commit() throws BackupException {
            }

            @Override
            public void rollback() throws BackupException {
            }

            @Override
            public void close() throws BackupException {
            }
        };
    }

    @Override
    public void addListener(WorkspaceStorageCacheListener listener) {
        if (this.isDistributedMode()) {
            throw new UnsupportedOperationException("The cache listeners are not supported by the ISPNCacheWorkspaceStorageCache in case of the distributed mode");
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(WorkspaceStorageCacheListener listener) {
        if (this.isDistributedMode()) {
            throw new UnsupportedOperationException("The cache listeners are not supported by the ISPNCacheWorkspaceStorageCache in case of the distributed mode");
        }
        this.listeners.remove(listener);
    }

    private void onCacheEntryUpdated(ItemData data) {
        if (data == null || data instanceof NullItemData) {
            return;
        }
        for (WorkspaceStorageCacheListener listener : this.listeners) {
            try {
                listener.onCacheEntryUpdated(data);
            }
            catch (RuntimeException e) {
                LOG.warn((Object)("The method onCacheEntryUpdated fails for the listener " + String.valueOf(listener.getClass())), (Throwable)e);
            }
        }
    }

    private static boolean updateTreePath(Cache<CacheKey, Object> cache, String ownerId, ItemData data, QPath prevRootPath, QPath newRootPath) {
        if (data == null) {
            return false;
        }
        QPath nodeQPath = data.getQPath();
        if (nodeQPath != null && nodeQPath.isDescendantOf(prevRootPath)) {
            QPathEntry[] relativePath;
            block7: {
                relativePath = null;
                try {
                    relativePath = nodeQPath.getRelPath(nodeQPath.getDepth() - prevRootPath.getDepth());
                }
                catch (IllegalPathException e) {
                    if (!LOG.isTraceEnabled()) break block7;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
            if (relativePath == null) {
                LOG.error((Object)("Could not get the relative path of the node " + String.valueOf(nodeQPath) + " with " + (nodeQPath.getDepth() - prevRootPath.getDepth()) + " as relative degree"));
                return false;
            }
            QPath newPath = QPath.makeChildPath(newRootPath, relativePath);
            if (data.isNode()) {
                NodeData prevNode = (NodeData)data;
                PersistedNodeData newNode = new PersistedNodeData(prevNode.getIdentifier(), newPath, prevNode.getParentIdentifier(), prevNode.getPersistedVersion(), prevNode.getOrderNumber(), prevNode.getPrimaryTypeName(), prevNode.getMixinTypeNames(), prevNode.getACL());
                cache.put((Object)new CacheId(ownerId, newNode.getIdentifier()), (Object)newNode);
            } else {
                PropertyData prevProp = (PropertyData)data;
                PersistedPropertyData newProp = new PersistedPropertyData(prevProp.getIdentifier(), newPath, prevProp.getParentIdentifier(), prevProp.getPersistedVersion(), prevProp.getType(), prevProp.isMultiValued(), prevProp.getValues(), new SimplePersistedSize(((PersistedPropertyData)prevProp).getPersistedSize()));
                cache.put((Object)new CacheId(ownerId, newProp.getIdentifier()), (Object)newProp);
            }
            return true;
        }
        return false;
    }

    public void start() {
    }

    public void stop() {
        this.cache.stop();
    }

    protected abstract class CacheActionNonTxAware<R, A>
    extends ActionNonTxAware<R, A, RuntimeException> {
        protected CacheActionNonTxAware() {
        }

        @Override
        protected TransactionManager getTransactionManager() {
            return ISPNCacheWorkspaceStorageCache.this.getTransactionManager();
        }
    }

    private class DistributedOperationCaller
    extends GlobalOperationCaller {
        private DistributedOperationCaller() {
        }

        @Override
        protected int getCacheSize() {
            MapReduceTask task = new MapReduceTask((Cache)ISPNCacheWorkspaceStorageCache.this.cache);
            task.mappedWith((Mapper)new GetSizeMapper(ISPNCacheWorkspaceStorageCache.this.getOwnerId())).reducedWith(new GetSizeReducer());
            Map map = task.execute();
            int sum = 0;
            for (Integer i : map.values()) {
                sum += i.intValue();
            }
            return sum;
        }

        @Override
        protected void clearCache() {
            MapReduceTask task = new MapReduceTask((Cache)ISPNCacheWorkspaceStorageCache.this.cache);
            task.mappedWith((Mapper)new ClearCacheMapper(ISPNCacheWorkspaceStorageCache.this.getOwnerId())).reducedWith((Reducer)new IdentityReducer());
            task.execute();
        }

        @Override
        protected Set<String> updateTreePath(final QPath prevRootPath, final QPath newRootPath, Set<String> idsToSkip) {
            HashSet<String> result;
            block3: {
                result = new HashSet<String>();
                final TransactionManager tm = ISPNCacheWorkspaceStorageCache.this.getTransactionManager();
                if (tm != null) {
                    try {
                        tm.getTransaction().registerSynchronization(new Synchronization(){

                            public void beforeCompletion() {
                            }

                            public void afterCompletion(int status) {
                                if (status == 3) {
                                    try {
                                        tm.suspend();
                                        DistributedOperationCaller.this._updateTreePath(prevRootPath, newRootPath);
                                    }
                                    catch (SystemException e) {
                                        LOG.warn((Object)"Cannot suspend the transaction", (Throwable)e);
                                    }
                                }
                            }
                        });
                        return result;
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) break block3;
                        LOG.debug((Object)"Cannot register the synchronization to the current transaction in order to update the path out of the transaction", (Throwable)e);
                    }
                }
            }
            this._updateTreePath(prevRootPath, newRootPath);
            return result;
        }

        private void _updateTreePath(QPath prevRootPath, QPath newRootPath) {
            MapReduceTask task = new MapReduceTask((Cache)ISPNCacheWorkspaceStorageCache.this.cache);
            task.mappedWith((Mapper)new UpdateTreePathMapper(ISPNCacheWorkspaceStorageCache.this.getOwnerId(), prevRootPath, newRootPath)).reducedWith((Reducer)new IdentityReducer());
            task.execute();
        }

        @Override
        protected void updateChildsACL(String parentId, AccessControlList acl) {
            ItemData parentItem = ISPNCacheWorkspaceStorageCache.this.get(parentId);
            if (!(parentItem instanceof NodeData)) {
                return;
            }
            QPath parentPath = ((NodeData)parentItem).getQPath();
            MapReduceTask task = new MapReduceTask((Cache)ISPNCacheWorkspaceStorageCache.this.cache);
            task.mappedWith((Mapper)new UpdateChildsACLMapper(ISPNCacheWorkspaceStorageCache.this.getOwnerId(), parentPath, acl)).reducedWith((Reducer)new IdentityReducer());
            task.execute();
        }
    }

    private class GlobalOperationCaller {
        private GlobalOperationCaller() {
        }

        protected int getCacheSize() {
            return ISPNCacheWorkspaceStorageCache.this.cache.size();
        }

        protected void clearCache() {
            ISPNCacheWorkspaceStorageCache.this.cache.clear();
        }

        protected void updateChildsACL(String parentId, AccessControlList acl) {
            ChildNodesIterator iter = new ChildNodesIterator(ISPNCacheWorkspaceStorageCache.this, parentId);
            block0: while (iter.hasNext()) {
                NodeData prevNode = (NodeData)iter.next();
                boolean hasExoPrivilegeable = false;
                boolean hasExoOwneable = false;
                for (InternalQName mixin : prevNode.getMixinTypeNames()) {
                    if (mixin.equals((Object)Constants.EXO_PRIVILEGEABLE)) {
                        hasExoPrivilegeable = true;
                        if (!hasExoOwneable) continue;
                        continue block0;
                    }
                    if (!mixin.equals((Object)Constants.EXO_OWNEABLE)) continue;
                    hasExoOwneable = true;
                    if (hasExoPrivilegeable) continue block0;
                }
                AccessControlList newAcl = null;
                if (hasExoOwneable) {
                    newAcl = new AccessControlList(prevNode.getACL().getOwner(), acl.getPermissionEntries());
                } else if (hasExoPrivilegeable) {
                    newAcl = new AccessControlList(acl.getOwner(), prevNode.getACL().getPermissionEntries());
                }
                if (newAcl != null) {
                    if (newAcl.equals(prevNode.getACL())) continue;
                    acl = newAcl;
                }
                PersistedNodeData newNode = new PersistedNodeData(prevNode.getIdentifier(), prevNode.getQPath(), prevNode.getParentIdentifier(), prevNode.getPersistedVersion(), prevNode.getOrderNumber(), prevNode.getPrimaryTypeName(), prevNode.getMixinTypeNames(), acl);
                ISPNCacheWorkspaceStorageCache.this.cache.put(new CacheId(ISPNCacheWorkspaceStorageCache.this.getOwnerId(), newNode.getIdentifier()), (Object)newNode);
                this.updateChildsACL(newNode.getIdentifier(), acl);
            }
        }

        protected Set<String> updateTreePath(QPath prevRootPath, QPath newRootPath, Set<String> idsToSkip) {
            ItemData data;
            HashSet<String> result = new HashSet<String>();
            Map<CacheKey, Object> changes = ISPNCacheWorkspaceStorageCache.this.cache.getLastChanges();
            for (CacheKey key : changes.keySet()) {
                if (!(key instanceof CacheId) || (data = (ItemData)changes.get(key)) == null || idsToSkip != null && idsToSkip.contains(data.getIdentifier()) || !ISPNCacheWorkspaceStorageCache.updateTreePath(ISPNCacheWorkspaceStorageCache.this.cache, ISPNCacheWorkspaceStorageCache.this.getOwnerId(), data, prevRootPath, newRootPath)) continue;
                result.add(data.getIdentifier());
            }
            for (CacheKey key : ISPNCacheWorkspaceStorageCache.this.cache.keySet()) {
                if (!(key instanceof CacheId) || changes.containsKey(key)) continue;
                data = (ItemData)ISPNCacheWorkspaceStorageCache.this.cache.get(key);
                if (!ISPNCacheWorkspaceStorageCache.updateTreePath(ISPNCacheWorkspaceStorageCache.this.cache, ISPNCacheWorkspaceStorageCache.this.getOwnerId(), data, prevRootPath, newRootPath)) continue;
                result.add(data.getIdentifier());
            }
            return result;
        }
    }

    @Listener
    public class CacheEventListener {
        @CacheEntryModified
        public void cacheEntryModified(CacheEntryModifiedEvent evt) {
            if (!evt.isPre() && evt.getKey() instanceof CacheId) {
                ItemData value = (ItemData)evt.getValue();
                ISPNCacheWorkspaceStorageCache.this.onCacheEntryUpdated(value);
            }
        }
    }

    private static enum ModifyChildOption {
        NOT_MODIFY,
        MODIFY,
        FORCE_MODIFY;

    }

    public static class FakeValueSet
    extends HashSet<String> {
        private static final long serialVersionUID = 6163005084471981227L;

        public FakeValueSet() {
        }

        public FakeValueSet(int size) {
            for (int i = 0; i < size; ++i) {
                this.add(Integer.toString(i));
            }
        }
    }

    class NodesOrderComparator<N extends NodeData>
    implements Comparator<NodeData> {
        NodesOrderComparator(ISPNCacheWorkspaceStorageCache this$0) {
        }

        @Override
        public int compare(NodeData n1, NodeData n2) {
            return n1.getOrderNumber() - n2.getOrderNumber();
        }
    }

    public static class UpdateChildsACLMapper
    extends AbstractMapper<Void, Void> {
        private QPath parentPath;
        private AccessControlList acl;

        public UpdateChildsACLMapper() {
        }

        public UpdateChildsACLMapper(String ownerId, QPath parentPath, AccessControlList acl) {
            super(ownerId);
            this.parentPath = parentPath;
            this.acl = acl;
        }

        @Override
        protected boolean isValid(CacheKey key) {
            return super.isValid(key) && key instanceof CacheId;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            byte[] buf = this.parentPath.getAsString().getBytes("UTF-8");
            out.writeInt(buf.length);
            out.write(buf);
            out.writeBoolean(this.acl != null);
            if (this.acl != null) {
                this.acl.writeExternal(out);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            try {
                byte[] buf = new byte[in.readInt()];
                in.readFully(buf);
                String sQPath = new String(buf, "UTF-8");
                this.parentPath = QPath.parse(sQPath);
            }
            catch (IllegalPathException e) {
                throw new IOException("Deserialization error. ", (Throwable)((Object)e));
            }
            if (in.readBoolean()) {
                this.acl = new AccessControlList();
                this.acl.readExternal(in);
            }
        }

        protected void _map(CacheKey key, Object value, Collector<Void, Void> collector) {
            if (!(value instanceof NodeData)) {
                return;
            }
            NodeData prevNode = (NodeData)value;
            QPath nodeQPath = prevNode.getQPath();
            if (nodeQPath == null || !nodeQPath.isDescendantOf(this.parentPath)) {
                return;
            }
            boolean hasExoPrivilegeable = false;
            boolean hasExoOwneable = false;
            for (InternalQName mixin : prevNode.getMixinTypeNames()) {
                if (mixin.equals((Object)Constants.EXO_PRIVILEGEABLE)) {
                    hasExoPrivilegeable = true;
                    if (!hasExoOwneable) continue;
                    return;
                }
                if (!mixin.equals((Object)Constants.EXO_OWNEABLE)) continue;
                hasExoOwneable = true;
                if (!hasExoPrivilegeable) continue;
                return;
            }
            ExoContainer container = ExoContainerContext.getTopContainer();
            if (container == null) {
                LOG.error((Object)"The top container could not be found");
                return;
            }
            DistributedCacheManager dcm = (DistributedCacheManager)container.getComponentInstanceOfType(DistributedCacheManager.class);
            if (dcm == null) {
                LOG.error((Object)"The DistributedCacheManager could not be found at top container level, please configure it.");
                return;
            }
            Cache cache = dcm.getCache(ISPNCacheWorkspaceStorageCache.CACHE_NAME);
            cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.FAIL_SILENTLY}).remove((Object)key);
        }
    }

    public static class UpdateTreePathMapper
    extends AbstractMapper<Void, Void> {
        private QPath prevRootPath;
        private QPath newRootPath;

        public UpdateTreePathMapper() {
        }

        public UpdateTreePathMapper(String ownerId, QPath prevRootPath, QPath newRootPath) {
            super(ownerId);
            this.prevRootPath = prevRootPath;
            this.newRootPath = newRootPath;
        }

        @Override
        protected boolean isValid(CacheKey key) {
            return super.isValid(key) && key instanceof CacheId;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            byte[] buf = this.prevRootPath.getAsString().getBytes("UTF-8");
            out.writeInt(buf.length);
            out.write(buf);
            buf = this.newRootPath.getAsString().getBytes("UTF-8");
            out.writeInt(buf.length);
            out.write(buf);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            try {
                byte[] buf = new byte[in.readInt()];
                in.readFully(buf);
                String sQPath = new String(buf, "UTF-8");
                this.prevRootPath = QPath.parse(sQPath);
                buf = new byte[in.readInt()];
                in.readFully(buf);
                sQPath = new String(buf, "UTF-8");
                this.newRootPath = QPath.parse(sQPath);
            }
            catch (IllegalPathException e) {
                throw new IOException("Deserialization error. ", (Throwable)((Object)e));
            }
        }

        protected void _map(CacheKey key, Object value, Collector<Void, Void> collector) {
            ExoContainer container = ExoContainerContext.getTopContainer();
            if (container == null) {
                LOG.error((Object)"The top container could not be found");
                return;
            }
            DistributedCacheManager dcm = (DistributedCacheManager)container.getComponentInstanceOfType(DistributedCacheManager.class);
            if (dcm == null) {
                LOG.error((Object)"The DistributedCacheManager could not be found at top container level, please configure it.");
                return;
            }
            Cache cache = dcm.getCache(ISPNCacheWorkspaceStorageCache.CACHE_NAME);
            ISPNCacheWorkspaceStorageCache.updateTreePath((Cache<CacheKey, Object>)cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}), this.ownerId, (ItemData)value, this.prevRootPath, this.newRootPath);
        }
    }

    public static class IdentityReducer
    implements Reducer<Void, Void> {
        private static final long serialVersionUID = -6193360351201912040L;

        public Void reduce(Void reducedKey, Iterator<Void> iter) {
            return null;
        }
    }

    public static class ClearCacheMapper
    extends AbstractMapper<Void, Void> {
        public ClearCacheMapper() {
        }

        public ClearCacheMapper(String ownerId) {
            super(ownerId);
        }

        protected void _map(CacheKey key, Object value, Collector<Void, Void> collector) {
            ExoContainer container = ExoContainerContext.getTopContainer();
            if (container == null) {
                LOG.error((Object)"The top container could not be found");
                return;
            }
            DistributedCacheManager dcm = (DistributedCacheManager)container.getComponentInstanceOfType(DistributedCacheManager.class);
            if (dcm == null) {
                LOG.error((Object)"The DistributedCacheManager could not be found at top container level, please configure it.");
                return;
            }
            Cache cache = dcm.getCache(ISPNCacheWorkspaceStorageCache.CACHE_NAME);
            cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.FAIL_SILENTLY}).remove((Object)key);
        }
    }

    public static class GetSizeReducer<K>
    implements Reducer<K, Integer> {
        private static final long serialVersionUID = 7877781449514234007L;

        public Integer reduce(K reducedKey, Iterator<Integer> iter) {
            int sum = 0;
            while (iter.hasNext()) {
                Integer i = iter.next();
                sum += i.intValue();
            }
            return sum;
        }
    }

    public static class GetSizeMapper
    extends AbstractMapper<String, Integer> {
        public GetSizeMapper() {
        }

        public GetSizeMapper(String ownerId) {
            super(ownerId);
        }

        protected void _map(CacheKey key, Object value, Collector<String, Integer> collector) {
            collector.emit((Object)"total", (Object)1);
        }
    }

    class ChildPropertiesIterator<P extends PropertyData>
    extends ChildItemsIterator<P> {
        ChildPropertiesIterator(ISPNCacheWorkspaceStorageCache this$0, String parentId) {
            super(parentId, PropertyData.class, new CachePropsId(this$0.getOwnerId(), parentId));
        }

        @Override
        public P next() {
            return (P)((PropertyData)super.next());
        }
    }

    class ChildNodesIterator<N extends NodeData>
    extends ChildItemsIterator<N> {
        ChildNodesIterator(ISPNCacheWorkspaceStorageCache this$0, String parentId) {
            super(parentId, NodeData.class, new CacheNodesId(this$0.getOwnerId(), parentId));
        }

        @Override
        public N next() {
            return (N)((NodeData)super.next());
        }
    }

    class ChildItemsIterator<T extends ItemData>
    implements Iterator<T> {
        private Iterator<String> childs;
        private Iterator<Map.Entry<CacheKey, Object>> entries;
        private String parentId;
        private Class<? extends ItemData> type;
        private T next;

        ChildItemsIterator(String parentId, Class<? extends ItemData> type, CacheKey key) {
            Set set = (Set)ISPNCacheWorkspaceStorageCache.this.cache.get(key);
            if (set != null) {
                this.childs = ((Set)ISPNCacheWorkspaceStorageCache.this.cache.get(key)).iterator();
            } else {
                this.entries = ISPNCacheWorkspaceStorageCache.this.cache.entrySet().iterator();
                this.parentId = parentId;
                this.type = type;
            }
            this.fetchNext();
        }

        protected void fetchNext() {
            if (this.childs != null) {
                if (this.childs.hasNext()) {
                    ItemData n = null;
                    while ((n = (ItemData)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheId(ISPNCacheWorkspaceStorageCache.this.getOwnerId(), this.childs.next()))) == null && this.childs.hasNext()) {
                    }
                    this.next = n;
                } else {
                    this.next = null;
                }
            } else if (this.entries.hasNext()) {
                ItemData n = null;
                do {
                    ItemData item;
                    Map.Entry<CacheKey, Object> entry;
                    if (!((entry = this.entries.next()).getKey() instanceof CacheId) || !this.type.isInstance(entry.getValue()) || !this.parentId.equals((item = (ItemData)entry.getValue()).getParentIdentifier())) continue;
                    n = item;
                } while (n == null && this.entries.hasNext());
                this.next = n;
            } else {
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T current = this.next;
            this.fetchNext();
            return current;
        }

        @Override
        public void remove() {
            throw new IllegalArgumentException("Not implemented");
        }
    }
}

