/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene.spell;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.LuceneDictionary;
import org.apache.lucene.search.spell.SuggestMode;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryRootNode;
import org.exoplatform.services.jcr.impl.core.query.RelationQueryNode;
import org.exoplatform.services.jcr.impl.core.query.TraversingQueryNodeVisitor;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.SpellChecker;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LuceneSpellChecker
implements SpellChecker {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.LuceneSpellChecker");
    private InternalSpellChecker spellChecker;
    private final long refreshInterval;

    public LuceneSpellChecker() {
        this(3600000L);
    }

    protected LuceneSpellChecker(long refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    @Override
    public void init(QueryHandler handler, float minDistance, boolean morePopular) throws IOException {
        if (!(handler instanceof SearchIndex)) {
            throw new IOException("LuceneSpellChecker only works with " + SearchIndex.class.getName());
        }
        this.spellChecker = new InternalSpellChecker((SearchIndex)handler, minDistance, morePopular);
    }

    @Override
    public String check(QueryRootNode aqt) throws IOException, RepositoryException {
        String stmt = this.getFulltextStatement(aqt);
        if (stmt == null) {
            return null;
        }
        return this.spellChecker.suggest(stmt);
    }

    @Override
    public void close() {
        this.spellChecker.close();
    }

    private String getFulltextStatement(QueryRootNode aqt) throws RepositoryException {
        final String[] stmt = new String[1];
        aqt.accept(new TraversingQueryNodeVisitor(this){

            @Override
            public Object visit(RelationQueryNode node, Object o) throws RepositoryException {
                if (stmt[0] == null && node.getOperation() == 29) {
                    stmt[0] = node.getStringValue();
                }
                return super.visit(node, o);
            }
        }, null);
        return stmt[0];
    }

    private final class InternalSpellChecker {
        private long lastRefresh;
        private boolean refreshing = false;
        private final SearchIndex handler;
        private Directory spellIndexDirectory;
        private org.apache.lucene.search.spell.SpellChecker spellChecker;
        private final boolean morePopular;

        InternalSpellChecker(SearchIndex handler, float minDistance, boolean morePopular) throws IOException {
            this.handler = handler;
            this.spellIndexDirectory = null;
            this.spellIndexDirectory = handler.getDirectoryManager().getDirectory("spellchecker");
            if (IndexReader.indexExists((Directory)this.spellIndexDirectory)) {
                this.lastRefresh = System.currentTimeMillis();
            }
            this.spellChecker = new org.apache.lucene.search.spell.SpellChecker(this.spellIndexDirectory);
            this.spellChecker.setAccuracy(minDistance);
            this.morePopular = morePopular;
            this.refreshSpellChecker();
        }

        String suggest(String statement) throws IOException {
            ArrayList<String> words = new ArrayList<String>();
            ArrayList<TokenData> tokens = new ArrayList<TokenData>();
            this.tokenize(statement, words, tokens);
            String[] suggestions = this.check(words.toArray(new String[words.size()]));
            if (suggestions != null) {
                StringBuilder sb = new StringBuilder(statement);
                for (int i = suggestions.length - 1; i >= 0; --i) {
                    TokenData t = (TokenData)tokens.get(i);
                    if (t.word.equalsIgnoreCase(suggestions[i])) continue;
                    sb.replace(t.startOffset, t.endOffset, suggestions[i]);
                }
                String result = sb.toString();
                if (statement.equalsIgnoreCase(result)) {
                    return null;
                }
                return result;
            }
            return null;
        }

        void close() {
            block2: {
                try {
                    this.spellIndexDirectory.close();
                }
                catch (IOException e) {
                    if (!LOG.isTraceEnabled()) break block2;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
            this.spellChecker = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tokenize(String statement, List<String> words, List<TokenData> tokens) throws IOException {
            TokenStream ts = this.handler.getTextAnalyzer().tokenStream(FieldNames.FULLTEXT, (Reader)new StringReader(statement));
            CharTermAttribute term = (CharTermAttribute)ts.getAttribute(CharTermAttribute.class);
            PositionIncrementAttribute positionIncrement = (PositionIncrementAttribute)ts.getAttribute(PositionIncrementAttribute.class);
            OffsetAttribute offset = (OffsetAttribute)ts.getAttribute(OffsetAttribute.class);
            try {
                while (ts.incrementToken()) {
                    String word = new String(term.buffer(), 0, term.length());
                    String origWord = statement.substring(offset.startOffset(), offset.endOffset());
                    if (positionIncrement.getPositionIncrement() > 0) {
                        words.add(word);
                        tokens.add(new TokenData(this, offset.startOffset(), offset.endOffset(), word));
                        continue;
                    }
                    TokenData current = tokens.get(tokens.size() - 1);
                    if (Math.abs(origWord.length() - current.termLength()) <= Math.abs(origWord.length() - word.length())) continue;
                    words.set(words.size() - 1, word);
                    tokens.set(tokens.size() - 1, new TokenData(this, offset.startOffset(), offset.endOffset(), word));
                }
            }
            finally {
                ts.end();
                ts.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String[] check(String[] words) throws IOException {
            this.refreshSpellChecker();
            boolean hasSuggestion = false;
            IndexReader reader = this.handler.getIndexReader();
            try {
                for (int retries = 0; retries < 100; ++retries) {
                    try {
                        String[] suggestion = new String[words.length];
                        for (int i = 0; i < words.length; ++i) {
                            int currentIndex = i;
                            String[] similar = this.spellChecker.suggestSimilar(words[currentIndex], 5, reader, FieldNames.FULLTEXT, this.morePopular ? SuggestMode.SUGGEST_MORE_POPULAR : SuggestMode.SUGGEST_WHEN_NOT_IN_INDEX);
                            if (similar.length > 0) {
                                suggestion[i] = similar[0];
                                hasSuggestion = true;
                                continue;
                            }
                            suggestion[i] = words[i];
                        }
                        if (hasSuggestion) {
                            LOG.debug((Object)("Successful after " + retries + " retries"));
                            String[] stringArray = suggestion;
                            return stringArray;
                        }
                        String[] stringArray = null;
                        return stringArray;
                    }
                    catch (AlreadyClosedException e) {
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                        continue;
                    }
                }
                String[] stringArray = null;
                return stringArray;
            }
            finally {
                Util.closeOrRelease(reader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshSpellChecker() {
            if (this.lastRefresh + LuceneSpellChecker.this.refreshInterval < System.currentTimeMillis()) {
                InternalSpellChecker internalSpellChecker = this;
                synchronized (internalSpellChecker) {
                    if (!this.refreshing) {
                        this.refreshing = true;
                        Runnable refresh = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                block11: {
                                    try {
                                        IndexReader reader = InternalSpellChecker.this.handler.getIndexReader();
                                        try {
                                            long time = System.currentTimeMillis();
                                            LuceneDictionary dict = new LuceneDictionary(reader, FieldNames.FULLTEXT);
                                            LOG.debug((Object)"Starting spell checker index refresh");
                                            InternalSpellChecker.this.spellChecker.indexDictionary((Dictionary)dict, new IndexWriterConfig(Version.LUCENE_36, (Analyzer)new StandardAnalyzer(Version.LUCENE_36)), true);
                                            time = System.currentTimeMillis() - time;
                                            LOG.info((Object)("Spell checker index refreshed in: " + (time /= 1000L) + " s."));
                                        }
                                        finally {
                                            Util.closeOrRelease(reader);
                                            InternalSpellChecker internalSpellChecker = InternalSpellChecker.this;
                                            synchronized (internalSpellChecker) {
                                                InternalSpellChecker.this.refreshing = false;
                                            }
                                        }
                                    }
                                    catch (IOException e) {
                                        if (!LOG.isTraceEnabled()) break block11;
                                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                                    }
                                }
                            }
                        };
                        new Thread(refresh, "SpellChecker Refresh").start();
                        this.lastRefresh = System.currentTimeMillis();
                    }
                }
            }
        }

        class TokenData {
            int startOffset;
            int endOffset;
            String word;

            public TokenData(InternalSpellChecker this$1, int startOffset, int endOffset, String word) {
                this.startOffset = startOffset;
                this.endOffset = endOffset;
                this.word = word;
            }

            public int termLength() {
                return this.word.length();
            }
        }
    }

    public static final class OneDayRefreshInterval
    extends LuceneSpellChecker {
        public OneDayRefreshInterval() {
            super(86400000L);
        }
    }

    public static final class TwelveHoursRefreshInterval
    extends LuceneSpellChecker {
        public TwelveHoursRefreshInterval() {
            super(43200000L);
        }
    }

    public static final class SixHoursRefreshInterval
    extends LuceneSpellChecker {
        public SixHoursRefreshInterval() {
            super(21600000L);
        }
    }

    public static final class OneHourRefreshInterval
    extends LuceneSpellChecker {
        public OneHourRefreshInterval() {
            super(3600000L);
        }
    }

    public static final class ThirtyMinutesRefreshInterval
    extends LuceneSpellChecker {
        public ThirtyMinutesRefreshInterval() {
            super(1800000L);
        }
    }

    public static final class FiveMinutesRefreshInterval
    extends LuceneSpellChecker {
        public FiveMinutesRefreshInterval() {
            super(300000L);
        }
    }

    public static final class OneMinuteRefreshInterval
    extends LuceneSpellChecker {
        public OneMinuteRefreshInterval() {
            super(60000L);
        }
    }

    public static final class FiveSecondsRefreshInterval
    extends LuceneSpellChecker {
        public FiveSecondsRefreshInterval() {
            super(5000L);
        }
    }
}

