/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.web;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.frameworks.jcr.command.web.GenericWebAppContext;
import org.exoplatform.services.command.impl.CommandService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class DisplayJCRContentServlet
extends HttpServlet {
    ServletConfig config;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String currentPath;
        GenericWebAppContext ctx;
        ExoContainer container = (ExoContainer)this.getServletContext().getAttribute("org.exoplatform.frameworks.web.eXoContainer");
        if (container == null) {
            container = PortalContainer.getCurrentInstance((ServletContext)this.getServletContext());
        }
        SessionProviderService sessionProviderService = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        CommandService commandService = (CommandService)container.getComponentInstanceOfType(CommandService.class);
        try {
            ctx = new GenericWebAppContext(this.getServletContext(), request, response, sessionProviderService.getSessionProvider(null), repositoryService.getDefaultRepository());
        }
        catch (RepositoryException e) {
            throw new IOException(){

                @Override
                public Throwable getCause() {
                    return e;
                }
            };
        }
        catch (RepositoryConfigurationException e) {
            throw new IOException(){

                @Override
                public Throwable getCause() {
                    return e;
                }
            };
        }
        String catalogName = (String)ctx.get((Object)"org.exoplatform.frameworks.web.catalogName");
        String wsName = (String)ctx.get((Object)"workspace");
        if (wsName != null) {
            ctx.setCurrentWorkspace(wsName);
        }
        if ((currentPath = (String)ctx.get((Object)"path")) == null) {
            throw new ServletException("Path undefined " + request.getParameter("path") + " Request: " + request.getRequestURI());
        }
        try {
            Command cmd = catalogName == null ? commandService.getCatalog().getCommand("displayResource") : commandService.getCatalog(catalogName).getCommand("displayResource");
            if (cmd == null) {
                throw new Exception("No 'displayResource' command found");
            }
            ctx.put("path", (Object)currentPath);
            ctx.put("cache-control-max-age", (Object)this.getServletConfig().getInitParameter("cache-control-max-age"));
            cmd.execute((Context)ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }
}

