/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.version;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.datamodel.Identifier;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.version.ItemDataRestoreVisitor;
import org.exoplatform.services.jcr.impl.core.version.VersionHistoryImpl;
import org.exoplatform.services.jcr.impl.core.version.VersionStorageDescendantNode;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableDataManager;
import org.exoplatform.services.jcr.impl.dataflow.version.VersionHistoryDataHelper;

public class VersionImpl
extends VersionStorageDescendantNode
implements Version {
    public VersionImpl(NodeData data, SessionImpl session) throws PathNotFoundException, RepositoryException {
        super(data, session);
        if (!this.isNodeType(Constants.NT_VERSION)) {
            throw new RepositoryException("Node " + this.getLocation().getAsString(true) + " is not nt:version type");
        }
    }

    @Override
    protected void invalidate() {
        super.invalidate();
    }

    public Calendar getCreated() throws RepositoryException {
        this.checkValid();
        PropertyData pdata = (PropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_CREATED, 0), ItemType.PROPERTY);
        if (pdata == null) {
            throw new VersionException("jcr:created property is not found for version " + this.getPath());
        }
        Value created = this.session.getValueFactory().loadValue(pdata.getValues().get(0), pdata.getType());
        return created.getDate();
    }

    public Version[] getSuccessors() throws RepositoryException {
        this.checkValid();
        PropertyData successorsData = (PropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_SUCCESSORS, 0), ItemType.PROPERTY);
        if (successorsData == null) {
            return new Version[0];
        }
        List<ValueData> successorsValues = successorsData.getValues();
        Version[] successors = new Version[successorsValues.size()];
        for (int i = 0; i < successorsValues.size(); ++i) {
            String videntifier = ValueDataUtil.getString(successorsValues.get(i));
            VersionImpl version = (VersionImpl)this.dataManager.getItemByIdentifier(videntifier, true);
            if (version == null) {
                throw new RepositoryException("Successor version is not found " + videntifier + ", this version " + this.getPath());
            }
            successors[i] = version;
        }
        return successors;
    }

    public Version[] getPredecessors() throws RepositoryException {
        this.checkValid();
        PropertyData predecessorsData = (PropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_PREDECESSORS, 0), ItemType.PROPERTY);
        if (predecessorsData == null) {
            return new Version[0];
        }
        List<ValueData> predecessorsValues = predecessorsData.getValues();
        Version[] predecessors = new Version[predecessorsValues.size()];
        for (int i = 0; i < predecessorsValues.size(); ++i) {
            String videntifier = ValueDataUtil.getString(predecessorsValues.get(i));
            VersionImpl version = (VersionImpl)this.dataManager.getItemByIdentifier(videntifier, false, false);
            if (version == null) {
                throw new RepositoryException("Predecessor version is not found " + videntifier + ", this version " + this.getPath());
            }
            predecessors[i] = version;
        }
        return predecessors;
    }

    public void addSuccessor(String successorIdentifier, PlainChangesLog changesLog) throws RepositoryException {
        this.checkValid();
        TransientValueData successorRef = new TransientValueData(new Identifier(successorIdentifier));
        PropertyData successorsProp = (PropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_SUCCESSORS, 0), ItemType.PROPERTY);
        if (successorsProp == null) {
            ArrayList<ValueData> successors = new ArrayList<ValueData>();
            successors.add(successorRef);
            successorsProp = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_SUCCESSORS, 9, true, successors);
            changesLog.add(ItemState.createAddedState(successorsProp));
        } else {
            ArrayList<ValueData> newSuccessorsValue = new ArrayList<ValueData>();
            try {
                for (ValueData svd : successorsProp.getValues()) {
                    newSuccessorsValue.add(ValueDataUtil.createTransientCopy(svd));
                }
            }
            catch (IOException e) {
                throw new RepositoryException("jcr:successors read error " + String.valueOf(e), (Throwable)e);
            }
            newSuccessorsValue.add(successorRef);
            TransientPropertyData newSuccessorsProp = new TransientPropertyData(successorsProp.getQPath(), successorsProp.getIdentifier(), successorsProp.getPersistedVersion(), successorsProp.getType(), successorsProp.getParentIdentifier(), successorsProp.isMultiValued(), newSuccessorsValue);
            changesLog.add(ItemState.createUpdatedState(newSuccessorsProp));
        }
    }

    public void addPredecessor(String predeccessorIdentifier, PlainChangesLog changesLog) throws RepositoryException {
        this.checkValid();
        TransientValueData predeccessorRef = new TransientValueData(new Identifier(predeccessorIdentifier));
        PropertyData predeccessorsProp = (PropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_PREDECESSORS, 0), ItemType.PROPERTY);
        if (predeccessorsProp == null) {
            ArrayList<ValueData> predeccessors = new ArrayList<ValueData>();
            predeccessors.add(predeccessorRef);
            predeccessorsProp = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_PREDECESSORS, 9, true, predeccessors);
            changesLog.add(ItemState.createAddedState(predeccessorsProp));
        } else {
            ArrayList<ValueData> newPredeccessorValue = new ArrayList<ValueData>();
            try {
                for (ValueData svd : predeccessorsProp.getValues()) {
                    newPredeccessorValue.add(ValueDataUtil.createTransientCopy(svd));
                }
            }
            catch (IOException e) {
                throw new RepositoryException("jcr:predecessors read error " + String.valueOf(e), (Throwable)e);
            }
            newPredeccessorValue.add(predeccessorRef);
            TransientPropertyData newPredeccessorsProp = new TransientPropertyData(predeccessorsProp.getQPath(), predeccessorsProp.getIdentifier(), predeccessorsProp.getPersistedVersion(), predeccessorsProp.getType(), predeccessorsProp.getParentIdentifier(), predeccessorsProp.isMultiValued(), newPredeccessorValue);
            changesLog.add(ItemState.createUpdatedState(newPredeccessorsProp));
        }
    }

    void removeSuccessor(String successorIdentifier, PlainChangesLog changesLog) throws RepositoryException {
        PropertyData successorsProp = (PropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_SUCCESSORS, 0), ItemType.PROPERTY);
        if (successorsProp != null) {
            ArrayList<ValueData> newSuccessors = new ArrayList<ValueData>();
            try {
                for (ValueData sdata : successorsProp.getValues()) {
                    if (successorIdentifier.equals(ValueDataUtil.getString(sdata))) continue;
                    newSuccessors.add(ValueDataUtil.createTransientCopy(sdata));
                }
            }
            catch (IOException e) {
                throw new RepositoryException("A jcr:successors property read error " + String.valueOf(e), (Throwable)e);
            }
            TransientPropertyData newSuccessorsProp = new TransientPropertyData(QPath.makeChildPath(this.nodeData().getQPath(), Constants.JCR_SUCCESSORS, successorsProp.getQPath().getIndex()), successorsProp.getIdentifier(), successorsProp.getPersistedVersion(), 9, this.nodeData().getIdentifier(), true, newSuccessors);
            if (!newSuccessors.isEmpty()) {
                changesLog.add(ItemState.createUpdatedState(newSuccessorsProp));
            } else {
                ItemData successorProp = this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_SUCCESSORS, 0), ItemType.PROPERTY);
                changesLog.add(ItemState.createDeletedState(successorProp));
            }
        } else {
            throw new RepositoryException("A jcr:successors property is not found, version " + this.getPath());
        }
    }

    void removeAddSuccessor(String removedSuccessorIdentifier, String addedSuccessorIdentifier, PlainChangesLog changesLog) throws RepositoryException {
        ArrayList<ValueData> newSuccessors;
        PropertyData successorsProp = (PropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_SUCCESSORS, 0), ItemType.PROPERTY);
        if (successorsProp != null) {
            newSuccessors = new ArrayList<ValueData>();
            try {
                for (ValueData sdata : successorsProp.getValues()) {
                    if (removedSuccessorIdentifier.equals(ValueDataUtil.getString(sdata))) continue;
                    newSuccessors.add(ValueDataUtil.createTransientCopy(sdata));
                }
            }
            catch (IOException e) {
                throw new RepositoryException("A jcr:successors property read error " + String.valueOf(e), (Throwable)e);
            }
            if (addedSuccessorIdentifier != null) {
                newSuccessors.add(new TransientValueData(new Identifier(addedSuccessorIdentifier)));
            }
        } else {
            throw new RepositoryException("A jcr:successors property is not found, version " + this.getPath());
        }
        TransientPropertyData newSuccessorsProp = new TransientPropertyData(QPath.makeChildPath(this.nodeData().getQPath(), Constants.JCR_SUCCESSORS, successorsProp.getQPath().getIndex()), successorsProp.getIdentifier(), successorsProp.getPersistedVersion(), 9, this.nodeData().getIdentifier(), true, newSuccessors);
        changesLog.add(ItemState.createUpdatedState(newSuccessorsProp));
    }

    void removePredecessor(String predecessorIdentifier, PlainChangesLog changesLog) throws RepositoryException {
        ArrayList<ValueData> newPredeccessors;
        PropertyData predeccessorsProp = (PropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_PREDECESSORS, 0), ItemType.PROPERTY);
        if (predeccessorsProp != null) {
            newPredeccessors = new ArrayList<ValueData>();
            try {
                for (ValueData sdata : predeccessorsProp.getValues()) {
                    if (predecessorIdentifier.equals(ValueDataUtil.getString(sdata))) continue;
                    newPredeccessors.add(ValueDataUtil.createTransientCopy(sdata));
                }
            }
            catch (IOException e) {
                throw new RepositoryException("A jcr:predecessors property read error " + String.valueOf(e), (Throwable)e);
            }
        } else {
            throw new RepositoryException("A jcr:predecessors property is not found, version " + this.getPath());
        }
        TransientPropertyData newPredecessorsProp = new TransientPropertyData(QPath.makeChildPath(this.nodeData().getQPath(), Constants.JCR_PREDECESSORS, predeccessorsProp.getQPath().getIndex()), predeccessorsProp.getIdentifier(), predeccessorsProp.getPersistedVersion(), 9, this.nodeData().getIdentifier(), true, newPredeccessors);
        changesLog.add(ItemState.createUpdatedState(newPredecessorsProp));
    }

    void removeAddPredecessor(String removedPredecessorIdentifier, String addedPredecessorIdentifier, PlainChangesLog changesLog) throws RepositoryException {
        ArrayList<ValueData> newPredeccessors;
        PropertyData predeccessorsProp = (PropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_PREDECESSORS, 0), ItemType.PROPERTY);
        if (predeccessorsProp != null) {
            newPredeccessors = new ArrayList<ValueData>();
            try {
                for (ValueData sdata : predeccessorsProp.getValues()) {
                    if (removedPredecessorIdentifier.equals(ValueDataUtil.getString(sdata))) continue;
                    newPredeccessors.add(ValueDataUtil.createTransientCopy(sdata));
                }
            }
            catch (IOException e) {
                throw new RepositoryException("A jcr:predecessors property read error " + String.valueOf(e), (Throwable)e);
            }
        } else {
            throw new RepositoryException("A jcr:predecessors property is not found, version " + this.getPath());
        }
        newPredeccessors.add(new TransientValueData(new Identifier(addedPredecessorIdentifier)));
        TransientPropertyData newPredecessorsProp = new TransientPropertyData(QPath.makeChildPath(this.nodeData().getQPath(), Constants.JCR_PREDECESSORS, predeccessorsProp.getQPath().getIndex()), predeccessorsProp.getIdentifier(), predeccessorsProp.getPersistedVersion(), 9, this.nodeData().getIdentifier(), true, newPredeccessors);
        changesLog.add(ItemState.createUpdatedState(newPredecessorsProp));
    }

    public VersionHistoryImpl getContainingHistory() throws RepositoryException {
        this.checkValid();
        VersionHistoryImpl vhistory = (VersionHistoryImpl)this.dataManager.getItemByIdentifier(this.nodeData().getParentIdentifier(), true, false);
        if (vhistory == null) {
            throw new VersionException("Version history item is not found for version " + this.getPath());
        }
        return vhistory;
    }

    public SessionChangesLog restoreLog(NodeData destParent, InternalQName name, VersionHistoryDataHelper historyData, SessionImpl restoreSession, boolean removeExisting, SessionChangesLog delegatedLog) throws RepositoryException {
        this.checkValid();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Restore on parent " + destParent.getQPath().getAsString() + " as " + name.getAsString() + ", removeExisting=" + removeExisting));
        }
        TransactionableDataManager dmanager = restoreSession.getTransientNodesManager().getTransactManager();
        NodeData frozenData = (NodeData)dmanager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_FROZENNODE, 1), ItemType.NODE);
        ItemDataRestoreVisitor restoreVisitor = new ItemDataRestoreVisitor(destParent, name, historyData, restoreSession, removeExisting, delegatedLog);
        frozenData.accept(restoreVisitor);
        return restoreVisitor.getRestoreChanges();
    }

    public void restore(SessionImpl restoreSession, NodeData destParent, InternalQName name, boolean removeExisting) throws RepositoryException {
        this.checkValid();
        TransactionableDataManager dmanager = restoreSession.getTransientNodesManager().getTransactManager();
        NodeData vh = (NodeData)dmanager.getItemData(this.nodeData().getParentIdentifier());
        VersionHistoryDataHelper historyHelper = new VersionHistoryDataHelper(vh, dmanager, this.session.getWorkspace().getNodeTypesHolder());
        SessionChangesLog changesLog = this.restoreLog(destParent, name, historyHelper, restoreSession, removeExisting, null);
        dmanager.save(changesLog);
    }

    public boolean isSuccessorOrSameOf(VersionImpl anotherVersion) throws RepositoryException {
        Version[] prds = this.getPredecessors();
        for (int i = 0; i < prds.length; ++i) {
            if (!prds[i].getUUID().equals(anotherVersion.getUUID()) && !((VersionImpl)prds[i]).isSuccessorOrSameOf(anotherVersion)) continue;
            return true;
        }
        return false;
    }
}

