/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Calendar;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.SpoolConfig;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;

public abstract class StreamValueData
extends AbstractValueData {
    protected InputStream stream;
    protected SpoolFile spoolFile;
    protected final SpoolConfig spoolConfig;
    protected byte[] data;
    protected FileChannel channel;

    protected StreamValueData(int orderNumber, InputStream stream, SpoolFile spoolFile, SpoolConfig spoolConfig) throws IOException {
        super(orderNumber);
        this.stream = stream;
        this.spoolFile = spoolFile;
        this.spoolConfig = spoolConfig;
        if (spoolFile != null) {
            spoolFile.acquire(this);
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
        }
    }

    @Override
    public byte[] getAsByteArray() throws IOException {
        if (this.isByteArrayAfterSpool()) {
            return this.data;
        }
        return this.fileToByteArray(this.spoolFile);
    }

    @Override
    public InputStream getAsStream() throws IOException {
        if (this.isByteArrayAfterSpool()) {
            return new ByteArrayInputStream(this.data);
        }
        if (this.spoolFile != null) {
            return new FileInputStream(this.spoolFile);
        }
        throw new IllegalArgumentException("Stream already consumed");
    }

    @Override
    public long getLength() {
        if (this.isByteArrayAfterSpool()) {
            return this.data.length;
        }
        return this.spoolFile.length();
    }

    @Override
    public boolean isByteArray() {
        return this.data != null;
    }

    @Override
    public long read(OutputStream stream, long length, long position) throws IOException {
        if (this.isByteArrayAfterSpool()) {
            return this.readFromByteArray(stream, length, position);
        }
        return this.readFromFile(stream, this.spoolFile, length, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long readFromFile(OutputStream stream, File file, long length, long position) throws IOException {
        FileInputStream in = null;
        try {
            if (this.channel == null || !this.channel.isOpen()) {
                in = new FileInputStream(file);
                this.channel = in.getChannel();
            }
            length = this.validateAndAdjustLenght(length, position, this.channel.size());
            MappedByteBuffer bb = this.channel.map(FileChannel.MapMode.READ_ONLY, position, length);
            WritableByteChannel ch = Channels.newChannel(stream);
            ch.write(bb);
            ch.close();
            long l = length;
            return l;
        }
        finally {
            if (in != null) {
                in.close();
                if (this.channel != null) {
                    this.channel.close();
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.channel != null) {
            this.channel.close();
        }
        this.removeSpoolFile();
        super.finalize();
    }

    private boolean isByteArrayAfterSpool() {
        if (this.data != null) {
            return true;
        }
        this.spoolInputStream();
        return this.data != null;
    }

    protected void spoolInputStream() {
        if (this.spoolFile != null || this.data != null) {
            return;
        }
        byte[] buffer = new byte[]{};
        byte[] tmpBuff = new byte[2048];
        int read = 0;
        int len = 0;
        SpoolFile sf = null;
        OutputStream sfout = null;
        try {
            while ((read = this.stream.read(tmpBuff)) >= 0) {
                if (sfout != null) {
                    sfout.write(tmpBuff, 0, read);
                    len += read;
                    continue;
                }
                if (len + read > this.spoolConfig.maxBufferSize) {
                    sf = SpoolFile.createTempFile("jcrvd", null, this.spoolConfig.tempDirectory);
                    sf.acquire(this);
                    sfout = new FileOutputStream(sf);
                    sfout.write(buffer, 0, len);
                    sfout.write(tmpBuff, 0, read);
                    buffer = null;
                    len += read;
                    continue;
                }
                byte[] newBuffer = new byte[len + read];
                System.arraycopy(buffer, 0, newBuffer, 0, len);
                System.arraycopy(tmpBuff, 0, newBuffer, len, read);
                buffer = newBuffer;
                len += read;
            }
            if (sf != null) {
                this.spoolFile = sf;
                this.data = null;
            } else {
                this.spoolFile = null;
                this.data = buffer;
            }
        }
        catch (IOException e) {
            block20: {
                if (sf != null) {
                    try {
                        sf.release(this);
                        this.spoolConfig.fileCleaner.addFile(sf);
                    }
                    catch (FileNotFoundException ex) {
                        if (!LOG.isDebugEnabled()) break block20;
                        LOG.debug((Object)("Could not remove temporary file : " + sf.getAbsolutePath()));
                    }
                }
            }
            throw new IllegalStateException("Error of spooling to temp file from " + String.valueOf(this.stream), e);
        }
        finally {
            try {
                if (sfout != null) {
                    sfout.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Error of spool output close.", (Throwable)e);
            }
            this.stream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] fileToByteArray(File file) throws IOException {
        FileInputStream in = null;
        try {
            if (this.channel == null || !this.channel.isOpen()) {
                in = new FileInputStream(file);
                this.channel = in.getChannel();
            }
            ByteBuffer bb = ByteBuffer.allocate((int)this.channel.size());
            this.channel.read(bb);
            if (bb.hasArray()) {
                byte[] byArray = bb.array();
                return byArray;
            }
            byte[] tmpb = new byte[bb.capacity()];
            bb.get(tmpb);
            byte[] byArray = tmpb;
            return byArray;
        }
        finally {
            if (in != null) {
                in.close();
                if (this.channel != null) {
                    this.channel.close();
                }
            }
        }
    }

    private void removeSpoolFile() throws IOException {
        if (this.spoolFile != null) {
            if (this.spoolFile instanceof SpoolFile) {
                this.spoolFile.release(this);
            }
            if (this.spoolFile.exists() && !this.spoolFile.delete()) {
                this.spoolConfig.fileCleaner.addFile(this.spoolFile);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Could not remove file. Add to fileCleaner " + this.spoolFile.getAbsolutePath()));
                }
            }
        }
    }

    @Override
    protected byte[] spoolInternalValue() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    protected boolean internalEquals(ValueData another) {
        if (another instanceof StreamValueData) {
            StreamValueData streamValue = (StreamValueData)another;
            if (this.isByteArray()) {
                return another.isByteArray() && Arrays.equals(streamValue.data, this.data);
            }
            if (this.stream != null && this.stream == streamValue.stream) {
                return true;
            }
            if (this.spoolFile != null && this.spoolFile.equals(streamValue.spoolFile)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public PersistedValueData createPersistedCopy(int orderNumber) throws IOException {
        if (this.isByteArray()) {
            return new ByteArrayPersistedValueData(orderNumber, this.data);
        }
        if (this.spoolFile != null) {
            return new StreamPersistedValueData(orderNumber, this.spoolFile, null, this.spoolConfig);
        }
        return new StreamPersistedValueData(orderNumber, this.stream, null, this.spoolConfig);
    }

    @Override
    public TransientValueData createTransientCopy(int orderNumber) throws IOException {
        return new TransientValueData(this.getOrderNumber(), this.getAsStream(), this.spoolConfig);
    }

    @Override
    protected Long getLong() throws ValueFormatException {
        return Long.valueOf(this.getString());
    }

    @Override
    protected Boolean getBoolean() throws ValueFormatException {
        return Boolean.valueOf(this.getString());
    }

    @Override
    protected Double getDouble() throws ValueFormatException {
        return Double.valueOf(this.getString());
    }

    @Override
    protected String getString() throws ValueFormatException {
        try {
            return new String(this.getAsByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ValueFormatException("Unsupported encoding UTF-8", (Throwable)e);
        }
        catch (IOException e) {
            throw new ValueFormatException("Can't represents data as array of bytes", (Throwable)e);
        }
    }

    @Override
    protected Calendar getDate() throws ValueFormatException {
        return JCRDateFormat.parse(this.getString());
    }

    @Override
    protected InputStream getStream() throws IOException {
        return this.getAsStream();
    }

    @Override
    protected InternalQName getName() throws ValueFormatException, IllegalNameException {
        return InternalQName.parse(this.getString());
    }

    @Override
    protected QPath getPath() throws ValueFormatException, IllegalPathException {
        return QPath.parse(this.getString());
    }

    @Override
    protected String getReference() throws ValueFormatException {
        return this.getString();
    }

    @Override
    protected AccessControlEntry getPermission() throws ValueFormatException {
        return AccessControlEntry.parse(this.getString());
    }
}

