/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.propertyeditor;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.util.Classes;
import org.jboss.util.propertyeditor.ByteArrayEditor;
import org.jboss.util.propertyeditor.CharacterEditor;
import org.jboss.util.propertyeditor.ClassArrayEditor;
import org.jboss.util.propertyeditor.IntArrayEditor;
import org.jboss.util.propertyeditor.StringArrayEditor;

public class PropertyEditors {
    private static Logger log = Logger.getLogger(PropertyEditors.class);
    private static final String NULL = "null";
    private static boolean disableIsNull = false;
    private static boolean initialized = false;

    public static synchronized void init() {
        if (!initialized) {
            AccessController.doPrivileged(Initialize.instance);
            initialized = true;
        }
    }

    public static final boolean isNull(String value) {
        return PropertyEditors.isNull(value, true, true);
    }

    public static final boolean isNull(String value, boolean trim, boolean empty) {
        String trimmed;
        if (disableIsNull) {
            return false;
        }
        if (value == null) {
            return true;
        }
        String string = trimmed = trim ? value.trim() : value;
        if (empty && trimmed.length() == 0) {
            return true;
        }
        return NULL.equalsIgnoreCase(trimmed);
    }

    public static boolean isNullHandlingEnabled() {
        return !disableIsNull;
    }

    public static PropertyEditor findEditor(Class<?> type) {
        return PropertyEditorManager.findEditor(type);
    }

    public static PropertyEditor findEditor(String typeName) throws ClassNotFoundException {
        Class<?> type = Classes.getPrimitiveTypeForName(typeName);
        if (type == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            type = loader.loadClass(typeName);
        }
        return PropertyEditorManager.findEditor(type);
    }

    public static PropertyEditor getEditor(Class<?> type) {
        PropertyEditor editor = PropertyEditors.findEditor(type);
        if (editor == null) {
            throw new RuntimeException("No property editor for type: " + type);
        }
        return editor;
    }

    public static PropertyEditor getEditor(String typeName) throws ClassNotFoundException {
        PropertyEditor editor = PropertyEditors.findEditor(typeName);
        if (editor == null) {
            throw new RuntimeException("No property editor for type: " + typeName);
        }
        return editor;
    }

    public static void registerEditor(Class<?> type, Class<?> editorType) {
        PropertyEditorManager.registerEditor(type, editorType);
    }

    public static void registerEditor(String typeName, String editorTypeName) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> type = loader.loadClass(typeName);
        Class<?> editorType = loader.loadClass(editorTypeName);
        PropertyEditorManager.registerEditor(type, editorType);
    }

    public static Object convertValue(String text, String typeName) throws ClassNotFoundException, IntrospectionException {
        PropertyEditor editor;
        Class<?> typeClass = Classes.getPrimitiveTypeForName(typeName);
        if (typeClass == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            typeClass = loader.loadClass(typeName);
        }
        if ((editor = PropertyEditorManager.findEditor(typeClass)) == null) {
            throw new IntrospectionException("No property editor for type=" + typeClass);
        }
        editor.setAsText(text);
        return editor.getValue();
    }

    public static void mapJavaBeanProperties(Object bean, Properties beanProps) throws IntrospectionException {
        PropertyEditors.mapJavaBeanProperties(bean, beanProps, true);
    }

    public static void mapJavaBeanProperties(Object bean, Properties beanProps, boolean isStrict) throws IntrospectionException {
        HashMap<String, PropertyDescriptor> propertyMap = new HashMap<String, PropertyDescriptor>();
        BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
        PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
        for (int p = 0; p < props.length; ++p) {
            String fieldName = props[p].getName();
            propertyMap.put(fieldName, props[p]);
        }
        boolean trace = log.isTraceEnabled();
        Iterator<Object> keys = beanProps.keySet().iterator();
        if (trace) {
            log.trace((Object)("Mapping properties for bean: " + bean));
        }
        while (keys.hasNext()) {
            String name = (String)keys.next();
            String text = beanProps.getProperty(name);
            PropertyDescriptor pd = (PropertyDescriptor)propertyMap.get(name);
            if (pd == null) {
                char first;
                String exName;
                if (name.length() > 1 && (pd = (PropertyDescriptor)propertyMap.get(exName = Character.toUpperCase(first = name.charAt(0)) + name.substring(1))) == null) {
                    exName = Character.toLowerCase(first) + name.substring(1);
                    pd = (PropertyDescriptor)propertyMap.get(exName);
                }
                if (pd == null) {
                    if (!isStrict) continue;
                    String msg = "No property found for: " + name + " on JavaBean: " + bean;
                    throw new IntrospectionException(msg);
                }
            }
            Method setter = pd.getWriteMethod();
            if (trace) {
                log.trace((Object)("Property editor found for: " + name + ", editor: " + pd + ", setter: " + setter));
            }
            if (setter == null) continue;
            Class<?> ptype = pd.getPropertyType();
            PropertyEditor editor = PropertyEditorManager.findEditor(ptype);
            if (editor == null && trace) {
                log.trace((Object)("Failed to find property editor for: " + name));
            }
            try {
                editor.setAsText(text);
                Object[] args = new Object[]{editor.getValue()};
                setter.invoke(bean, args);
            }
            catch (Exception e) {
                if (!trace) continue;
                log.trace((Object)"Failed to write property", (Throwable)e);
            }
        }
    }

    public String[] getEditorSearchPath() {
        return PropertyEditorManager.getEditorSearchPath();
    }

    public void setEditorSearchPath(String[] path) {
        PropertyEditorManager.setEditorSearchPath(path);
    }

    static {
        PropertyEditors.init();
    }

    private static class Initialize
    implements PrivilegedAction<Object> {
        static Initialize instance = new Initialize();

        private Initialize() {
        }

        @Override
        public Object run() {
            String[] currentPath = PropertyEditorManager.getEditorSearchPath();
            int length = currentPath != null ? currentPath.length : 0;
            String[] newPath = new String[length + 2];
            System.arraycopy(currentPath, 0, newPath, 2, length);
            newPath[0] = "org.jboss.util.propertyeditor";
            newPath[1] = "org.jboss.mx.util.propertyeditor";
            PropertyEditorManager.setEditorSearchPath(newPath);
            Class<String[]> strArrayType = String[].class;
            PropertyEditorManager.registerEditor(strArrayType, StringArrayEditor.class);
            Class<Class[]> clsArrayType = Class[].class;
            PropertyEditorManager.registerEditor(clsArrayType, ClassArrayEditor.class);
            Class<int[]> intArrayType = int[].class;
            PropertyEditorManager.registerEditor(intArrayType, IntArrayEditor.class);
            Class<byte[]> byteArrayType = byte[].class;
            PropertyEditorManager.registerEditor(byteArrayType, ByteArrayEditor.class);
            PropertyEditorManager.registerEditor(Character.TYPE, CharacterEditor.class);
            try {
                if (System.getProperty("org.jboss.util.property.disablenull") != null) {
                    disableIsNull = true;
                }
            }
            catch (Throwable ignored) {
                log.trace((Object)"Error retrieving system property org.jboss.util.property.diablenull", ignored);
            }
            return null;
        }
    }
}

