/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.util.ArgumentChecks;

final class ReshapedImage
extends PlanarImage {
    final RenderedImage source;
    private final int offsetX;
    private final int offsetY;
    private final int width;
    private final int height;
    private final int minX;
    private final int minY;
    private final int minTileX;
    private final int minTileY;

    ReshapedImage(RenderedImage renderedImage, long l, long l2, long l3, long l4) {
        this.source = renderedImage;
        long l5 = renderedImage.getMinX();
        long l6 = renderedImage.getMinY();
        long l7 = (long)renderedImage.getWidth() + l5;
        long l8 = (long)renderedImage.getHeight() + l6;
        long l9 = renderedImage.getTileWidth();
        long l10 = renderedImage.getTileHeight();
        long l11 = renderedImage.getTileGridXOffset();
        long l12 = renderedImage.getTileGridYOffset();
        long l13 = Math.floorDiv(Math.max(l5, l) - l11, l9);
        long l14 = Math.floorDiv(Math.max(l6, l2) - l12, l10);
        long l15 = Math.floorDiv(Math.min(l7, l3) - l11, l9);
        long l16 = Math.floorDiv(Math.min(l8, l4) - l12, l10);
        long l17 = Math.max(l5, l13 * l9 + l11);
        long l18 = Math.max(l6, l14 * l10 + l12);
        long l19 = Math.subtractExact(l17, l);
        long l20 = Math.subtractExact(l18, l2);
        this.minX = Math.toIntExact(l19);
        this.minY = Math.toIntExact(l20);
        this.width = Math.toIntExact(Math.min(l7, (l15 + 1L) * l9 + l11) - l17);
        this.height = Math.toIntExact(Math.min(l8, (l16 + 1L) * l10 + l12) - l18);
        this.offsetX = Math.toIntExact(l19 - l17);
        this.offsetY = Math.toIntExact(l20 - l18);
        this.minTileX = Math.toIntExact(l13);
        this.minTileY = Math.toIntExact(l14);
    }

    final boolean isIdentity() {
        return this.offsetX == 0 && this.offsetY == 0 && this.width >= this.source.getWidth() && this.height >= this.source.getHeight();
    }

    @Override
    public Vector<RenderedImage> getSources() {
        Vector<RenderedImage> vector = new Vector<RenderedImage>(1);
        vector.add(this.source);
        return vector;
    }

    @Override
    public Object getProperty(String string) {
        return this.source.getProperty(string);
    }

    @Override
    public String[] getPropertyNames() {
        return this.source.getPropertyNames();
    }

    @Override
    public ColorModel getColorModel() {
        return this.source.getColorModel();
    }

    @Override
    public SampleModel getSampleModel() {
        return this.source.getSampleModel();
    }

    @Override
    public int getTileWidth() {
        return this.source.getTileWidth();
    }

    @Override
    public int getTileHeight() {
        return this.source.getTileHeight();
    }

    @Override
    public int getMinX() {
        return this.minX;
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getMinTileX() {
        return this.minTileX;
    }

    @Override
    public int getMinTileY() {
        return this.minTileY;
    }

    @Override
    public int getTileGridXOffset() {
        return Math.addExact(this.source.getTileGridXOffset(), this.offsetX);
    }

    @Override
    public int getTileGridYOffset() {
        return Math.addExact(this.source.getTileGridYOffset(), this.offsetY);
    }

    private Raster offset(Raster raster) {
        return raster.createTranslatedChild(Math.addExact(raster.getMinX(), this.offsetX), Math.addExact(raster.getMinY(), this.offsetY));
    }

    @Override
    public Raster getTile(int n, int n2) {
        return this.offset(this.source.getTile(n, n2));
    }

    @Override
    public Raster getData() {
        if (this.width >= this.source.getWidth() && this.height >= this.source.getHeight()) {
            return this.offset(this.source.getData());
        }
        return this.copyData(new Rectangle(this.minX, this.minY, this.width, this.height));
    }

    @Override
    public Raster getData(Rectangle rectangle) {
        ArgumentChecks.ensureNonNull((String)"aoi", (Object)rectangle);
        return this.copyData(new Rectangle(rectangle));
    }

    private Raster copyData(Rectangle rectangle) {
        rectangle.x = Math.subtractExact(rectangle.x, this.offsetX);
        rectangle.y = Math.subtractExact(rectangle.y, this.offsetY);
        Raster raster = this.source.getData(rectangle);
        return raster.createTranslatedChild(Math.addExact(raster.getMinX(), this.offsetX), Math.addExact(raster.getMinY(), this.offsetY));
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        WritableRaster writableRaster2 = writableRaster != null ? writableRaster.createWritableTranslatedChild(Math.subtractExact(writableRaster.getMinX(), this.offsetX), Math.subtractExact(writableRaster.getMinY(), this.offsetY)) : null;
        if ((writableRaster2 = this.source.copyData(writableRaster2)).getWritableParent() == writableRaster) {
            return writableRaster;
        }
        return writableRaster2.createWritableTranslatedChild(Math.addExact(writableRaster2.getMinX(), this.offsetX), Math.addExact(writableRaster2.getMinY(), this.offsetY));
    }

    @Override
    public String verify() {
        String string;
        if (this.source instanceof PlanarImage && (string = ((PlanarImage)this.source).verify()) != null) {
            return "source." + string;
        }
        if (this.getMinX() != this.source.getMinX() + (this.minTileX - this.source.getMinTileX()) * this.getTileWidth() + this.offsetX) {
            return "minX";
        }
        if (this.getMinY() != this.source.getMinY() + (this.minTileY - this.source.getMinTileY()) * this.getTileHeight() + this.offsetY) {
            return "minY";
        }
        if (this.getTileGridXOffset() != super.getTileGridXOffset()) {
            return "tileGridXOffset";
        }
        if (this.getTileGridYOffset() != super.getTileGridYOffset()) {
            return "tileGridYOffset";
        }
        return super.verify();
    }
}

