/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.exoplatform.services.jcr.config.WorkspaceEntry;

public class PropertiesParser {
    public static final String EXO_JCR_CONFIG = "exo.jcr.config.";
    public static final String DEFAULT_TYPE = "default.";
    public static final String FORCE_TYPE = "force.";
    public static final String WORKSPACE_SCOPE = "workspace.";
    public static final String REPOSITORY_SCOPE = "repository.";
    public static final String ALL_SCOPE = "all.";
    protected final WorkspaceEntry workspaceEntry;
    private List<String> forceParameterPrefixes;
    private List<String> defaultParameterPrefixes;
    private final String componentName;

    PropertiesParser(WorkspaceEntry workspaceEntry, String componentName) {
        this.workspaceEntry = workspaceEntry;
        this.componentName = componentName;
    }

    public String getForcedParameterValue(String parameterShortName, Map<String, String> parameters) {
        List<String> longNames = this.generateForceParameterLongNames(parameterShortName);
        return this.chooseAppropriateParameterValue(longNames, parameters);
    }

    public String getDefaultParameterValue(String parameterShortName, Map<String, String> parameters) {
        List<String> longNames = this.generateDefaultParameterLongNames(parameterShortName);
        return this.chooseAppropriateParameterValue(longNames, parameters);
    }

    public Set<String> getParameterNames(Set<String> allParameterNames) {
        HashSet<String> names = new HashSet<String>();
        for (String propertyName : allParameterNames) {
            int index = this.propertyNameMatchIndex(propertyName);
            if (index <= 0) continue;
            names.add(propertyName.substring(index));
        }
        return names;
    }

    private void prepareForceParameterPrefixes() {
        this.forceParameterPrefixes = new ArrayList<String>();
        this.forceParameterPrefixes.add(this.generateForceParameterPrefix(WORKSPACE_SCOPE));
        this.forceParameterPrefixes.add(this.generateForceParameterPrefix(REPOSITORY_SCOPE));
        this.forceParameterPrefixes.add(this.generateForceParameterPrefix(ALL_SCOPE));
    }

    private void prepareDefaultParameterPrefixes() {
        this.defaultParameterPrefixes = new ArrayList<String>();
        this.defaultParameterPrefixes.add(this.generateDafaultParameterPrefix(WORKSPACE_SCOPE));
        this.defaultParameterPrefixes.add(this.generateDafaultParameterPrefix(REPOSITORY_SCOPE));
        this.defaultParameterPrefixes.add(this.generateDafaultParameterPrefix(ALL_SCOPE));
    }

    private String generateForceParameterPrefix(String scope) {
        return this.generateParameterPrefix(FORCE_TYPE, scope);
    }

    private String generateDafaultParameterPrefix(String scope) {
        return this.generateParameterPrefix(DEFAULT_TYPE, scope);
    }

    private String generateParameterPrefix(String type, String scope) {
        StringBuilder sb = new StringBuilder(EXO_JCR_CONFIG);
        sb.append(type);
        sb.append(scope);
        if (REPOSITORY_SCOPE.equals(scope)) {
            sb.append(this.generateRepositoryName());
            sb.append(".");
        }
        if (WORKSPACE_SCOPE.equals(scope)) {
            sb.append(this.workspaceEntry.getUniqueName());
            sb.append(".");
        }
        sb.append(this.componentName + ".");
        return sb.toString();
    }

    private List<String> generateForceParameterLongNames(String parameterShortName) {
        this.prepareForceParameterPrefixes();
        return this.generateParameterLongNames(parameterShortName, this.forceParameterPrefixes);
    }

    private List<String> generateDefaultParameterLongNames(String parameterShortName) {
        this.prepareDefaultParameterPrefixes();
        return this.generateParameterLongNames(parameterShortName, this.defaultParameterPrefixes);
    }

    private List<String> generateParameterLongNames(String parameterShortName, List<String> parameterPrefixes) {
        ArrayList<String> forceParameterLongNames = new ArrayList<String>();
        for (String parameterPrefix : parameterPrefixes) {
            forceParameterLongNames.add(parameterPrefix + parameterShortName);
        }
        return forceParameterLongNames;
    }

    private String chooseAppropriateParameterValue(List<String> parameterNames, Map<String, String> parameters) {
        for (String parameterName : parameterNames) {
            String parameterValue = parameters.get(parameterName);
            if (parameterValue == null) continue;
            return parameterValue;
        }
        return null;
    }

    private int propertyNameMatchIndex(String propertyFullName) {
        this.prepareForceParameterPrefixes();
        for (String prefix : this.forceParameterPrefixes) {
            if (!propertyFullName.startsWith(prefix)) continue;
            return prefix.length();
        }
        this.prepareDefaultParameterPrefixes();
        for (String prefix : this.defaultParameterPrefixes) {
            if (!propertyFullName.startsWith(prefix)) continue;
            return prefix.length();
        }
        return -1;
    }

    public static Properties getSystemProperties() {
        return System.getProperties();
    }

    private String generateRepositoryName() {
        String workspaceUniqueName = this.workspaceEntry.getUniqueName();
        int workspaceNameIndex = workspaceUniqueName.indexOf(this.workspaceEntry.getName());
        return workspaceUniqueName.substring(0, workspaceNameIndex - 1);
    }
}

