/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.query.IndexException;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.picocontainer.Startable;

public class RepositoryIndexSearcherHolder
implements Startable {
    private final List<SearchManager> indexSearchers = new ArrayList<SearchManager>();

    public void addIndexSearcher(SearchManager indexSearcher) {
        this.indexSearchers.add(indexSearcher);
    }

    public Set<String> getFieldNames() throws IndexException {
        HashSet<String> fildsSet = new HashSet<String>();
        for (SearchManager queryHandler : this.indexSearchers) {
            fildsSet.addAll(queryHandler.getFieldNames());
        }
        return fildsSet;
    }

    public Set<String> getNodesByNodeType(InternalQName nodeType) throws RepositoryException {
        HashSet<String> result = new HashSet<String>();
        for (SearchManager indexingService : this.indexSearchers) {
            result.addAll(indexingService.getNodesByNodeType(nodeType));
        }
        return result;
    }

    public Set<String> getNodesByUri(String uri) throws RepositoryException {
        HashSet<String> result = new HashSet<String>();
        for (SearchManager indexingService : this.indexSearchers) {
            result.addAll(indexingService.getNodesByUri(uri));
        }
        return result;
    }

    public void removeIndexSearcher(SearchManager indexSearcher) {
        this.indexSearchers.remove(indexSearcher);
    }

    public void start() {
    }

    public void stop() {
        this.indexSearchers.clear();
    }
}

