/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.xmlbeans.XmlException;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.document.impl.POIPropertiesReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MSXWordDocumentReader
extends BaseDocumentReader {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.document.MSXWordDocumentReader");

    @Override
    public String[] getMimeTypes() {
        return new String[]{"application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "application/vnd.ms-word.document.macroenabled.12", "application/vnd.ms-word.template.macroenabled.12"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream is null.");
        }
        String text = "";
        try {
            XWPFDocument doc;
            if (is.available() == 0) {
                String string = "";
                return string;
            }
            try {
                doc = new XWPFDocument(is);
            }
            catch (RuntimeException cause) {
                throw new DocumentReadException("Can not get the content: " + cause.getMessage(), cause);
            }
            try (XWPFWordExtractor extractor = new XWPFWordExtractor(doc);){
                text = extractor.getText();
            }
        }
        finally {
            block21: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isTraceEnabled()) break block21;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
        }
        return text.trim();
    }

    @Override
    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    @Override
    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        try {
            OPCPackage container = OPCPackage.open((InputStream)is);
            POIXMLProperties xmlProperties = new POIXMLProperties(container);
            POIPropertiesReader reader = new POIPropertiesReader();
            reader.readDCProperties(xmlProperties);
            return reader.getProperties();
        }
        catch (InvalidFormatException e) {
            throw new DocumentReadException("The format of the document to read is invalid.", e);
        }
        catch (XmlException e) {
            throw new DocumentReadException("Problem during the document parsing.", e);
        }
        catch (OpenXML4JException e) {
            throw new DocumentReadException("Problem during the document parsing.", e);
        }
    }
}

