/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.dataflow.DefaultItemDataCopyVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.version.VersionHistoryDataHelper;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ItemDataCopyVisitor
extends DefaultItemDataCopyVisitor {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ItemDataCopyVisitor");

    public ItemDataCopyVisitor(NodeData parent, InternalQName destNodeName, NodeTypeDataManager nodeTypeManager, SessionDataManager srcDataManager, SessionDataManager dstDataManager, boolean keepIdentifiers) {
        super(parent, destNodeName, nodeTypeManager, srcDataManager, dstDataManager, keepIdentifiers);
    }

    @Override
    protected void entering(PropertyData property, int level) throws RepositoryException {
        List<ValueData> values;
        InternalQName qname = property.getQPath().getName();
        if (this.ntManager.isNodeType(Constants.MIX_VERSIONABLE, this.curParent().getPrimaryTypeName(), this.curParent().getMixinTypeNames())) {
            QPath vhpPath = QPath.makeChildPath(this.curParent().getQPath(), Constants.JCR_VERSIONHISTORY);
            ItemState vhpState = this.findLastItemState(vhpPath);
            if (vhpState == null) {
                PlainChangesLogImpl changes = new PlainChangesLogImpl();
                VersionHistoryDataHelper vh = new VersionHistoryDataHelper(this.curParent(), changes, this.dataManager, this.ntManager);
                this.itemAddStates.addAll(changes.getAllStates());
            }
            values = new ArrayList<TransientValueData>(1);
            if (qname.equals((Object)Constants.JCR_LOCKISDEEP)) {
                return;
            }
            if (qname.equals((Object)Constants.JCR_LOCKOWNER)) {
                return;
            }
            if (qname.equals((Object)Constants.JCR_VERSIONHISTORY)) {
                return;
            }
            if (qname.equals((Object)Constants.JCR_PREDECESSORS)) {
                return;
            }
            if (qname.equals((Object)Constants.JCR_BASEVERSION)) {
                return;
            }
            if (qname.equals((Object)Constants.JCR_ISCHECKEDOUT)) {
                values.add((TransientValueData)((ValueData)new TransientValueData(true)));
            } else {
                if (qname.equals((Object)Constants.JCR_MERGEFAILED)) {
                    return;
                }
                if (qname.equals((Object)Constants.JCR_UUID)) {
                    values.add((TransientValueData)((ValueData)new TransientValueData(this.curParent().getIdentifier())));
                } else {
                    values = this.copyValues(property);
                }
            }
        } else if (this.ntManager.isNodeType(Constants.MIX_REFERENCEABLE, this.curParent().getPrimaryTypeName(), this.curParent().getMixinTypeNames()) && qname.equals((Object)Constants.JCR_UUID)) {
            values = new ArrayList(1);
            values.add(new TransientValueData(this.curParent().getIdentifier()));
        } else {
            if (qname.equals((Object)Constants.JCR_LOCKISDEEP)) {
                return;
            }
            if (qname.equals((Object)Constants.JCR_LOCKOWNER)) {
                return;
            }
            values = this.copyValues(property);
        }
        TransientPropertyData newProperty = new TransientPropertyData(QPath.makeChildPath(this.curParent().getQPath(), qname), this.keepIdentifiers ? property.getIdentifier() : IdGenerator.generate(), -1, property.getType(), this.curParent().getIdentifier(), property.isMultiValued(), values);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("entering COPY " + newProperty.getQPath().getAsString() + "; pidentifier: " + newProperty.getParentIdentifier() + "; identifier: " + newProperty.getIdentifier()));
        }
        this.itemAddStates.add(new ItemState(newProperty, 1, true, this.ancestorToSave, level != 0));
    }
}

