/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.ReaderUtil;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;

public class IndexFormatVersion {
    public static final IndexFormatVersion V1 = new IndexFormatVersion(1);
    public static final IndexFormatVersion V2 = new IndexFormatVersion(2);
    public static final IndexFormatVersion V3 = new IndexFormatVersion(3);
    public static final IndexFormatVersion V4 = new IndexFormatVersion(4);
    private final int version;

    private IndexFormatVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isAtLeast(IndexFormatVersion version) {
        return this.version >= version.getVersion();
    }

    public String toString() {
        return String.valueOf(this.getVersion());
    }

    public static IndexFormatVersion getVersion(IndexReader indexReader) {
        FieldInfos fields = ReaderUtil.getMergedFieldInfos((IndexReader)indexReader);
        if (fields.fieldInfo(FieldNames.INDEX) != null && fields.fieldInfo(FieldNames.PATH) != null || indexReader.numDocs() == 0) {
            return V4;
        }
        if (fields.fieldInfo(FieldNames.LOCAL_NAME) != null) {
            return V3;
        }
        if (fields.fieldInfo(FieldNames.PROPERTIES_SET) != null) {
            return V2;
        }
        return V1;
    }
}

