/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedNodeData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.IllegalACLException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.NodeDataIndexing;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ACLHolder;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ChangedSizeHandler;
import org.exoplatform.services.jcr.impl.dataflow.persistent.SimplePersistedSize;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.PrimaryTypeNotFoundException;
import org.exoplatform.services.jcr.impl.storage.jdbc.SQLExceptionHandler;
import org.exoplatform.services.jcr.impl.storage.value.ValueStorageNotFoundException;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.ValueFileIOHelper;
import org.exoplatform.services.jcr.impl.util.io.SwapFile;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class JDBCStorageConnection
extends DBConstants
implements WorkspaceStorageConnection {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JDBCStorageConnection");
    public static final int I_CLASS_NODE = 1;
    public static final int I_CLASS_PROPERTY = 2;
    protected final JDBCDataContainerConfig containerConfig;
    protected final Connection dbConnection;
    protected final SQLExceptionHandler exceptionHandler;
    protected final List<ValueIOChannel> valueChanges;
    protected static final WriteValueHelper WRITE_VALUE_HELPER = new WriteValueHelper();
    protected PreparedStatement findItemById;
    protected PreparedStatement findItemByPath;
    protected PreparedStatement findItemByName;
    protected PreparedStatement findChildPropertyByPath;
    protected PreparedStatement findPropertyByName;
    protected PreparedStatement findDescendantNodes;
    protected PreparedStatement findDescendantProperties;
    protected PreparedStatement findReferences;
    protected PreparedStatement findValuesByPropertyId;
    protected PreparedStatement findValuesDataByPropertyId;
    protected PreparedStatement findNodesByParentId;
    protected PreparedStatement findLastOrderNumberByParentId;
    protected PreparedStatement findNodesCountByParentId;
    protected PreparedStatement findPropertiesByParentId;
    protected PreparedStatement findMaxPropertyVersions;
    protected PreparedStatement insertNode;
    protected PreparedStatement insertProperty;
    protected PreparedStatement insertReference;
    protected PreparedStatement insertValue;
    protected PreparedStatement updateNode;
    protected PreparedStatement updateProperty;
    protected PreparedStatement deleteItem;
    protected PreparedStatement deleteReference;
    protected PreparedStatement deleteValue;
    protected PreparedStatement renameNode;
    protected PreparedStatement findNodesAndProperties;
    protected PreparedStatement findNodesCount;
    protected PreparedStatement findWorkspaceDataSize;
    protected PreparedStatement findNodeDataSize;
    protected PreparedStatement findNodePropertiesOnValueStorage;
    protected PreparedStatement findWorkspacePropertiesOnValueStorage;
    protected PreparedStatement findValueStorageDescAndSize;
    private Exception closedByCallStack;
    protected final boolean readOnly;
    private AtomicInteger dbConnectionTotalUsed;
    protected static Comparator<ValueData> COMPARATOR_VALUE_DATA = new Comparator<ValueData>(){

        @Override
        public int compare(ValueData vd1, ValueData vd2) {
            return vd1.getOrderNumber() - vd2.getOrderNumber();
        }
    };

    protected JDBCStorageConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        this.dbConnection = dbConnection;
        this.readOnly = readOnly;
        this.containerConfig = containerConfig;
        if (!readOnly && dbConnection.getAutoCommit()) {
            dbConnection.setAutoCommit(false);
        }
        this.prepareEntityNames();
        this.prepareQueries();
        this.exceptionHandler = new SQLExceptionHandler(this.containerConfig.containerName, this);
        this.valueChanges = new ArrayList<ValueIOChannel>();
    }

    protected void prepareEntityNames() {
        switch (this.containerConfig.dbStructureType) {
            case MULTI: {
                this.JCR_ITEM = "JCR_MITEM";
                this.JCR_VALUE = "JCR_MVALUE";
                this.JCR_REF = "JCR_MREF";
                this.JCR_PK_ITEM = "JCR_PK_MITEM";
                this.JCR_FK_ITEM_PARENT = "JCR_FK_MITEM_PARENT";
                this.JCR_IDX_ITEM_PARENT = "JCR_IDX_MITEM_PARENT";
                this.JCR_IDX_ITEM_PARENT_NAME = "JCR_IDX_MITEM_PARENT_NAME";
                this.JCR_IDX_ITEM_PARENT_ID = "JCR_IDX_MITEM_PARENT_ID";
                this.JCR_PK_VALUE = "JCR_PK_MVALUE";
                this.JCR_FK_VALUE_PROPERTY = "JCR_FK_MVALUE_PROPERTY";
                this.JCR_IDX_VALUE_PROPERTY = "JCR_IDX_MVALUE_PROPERTY";
                this.JCR_PK_REF = "JCR_PK_MREF";
                this.JCR_IDX_REF_PROPERTY = "JCR_IDX_MREF_PROPERTY";
                this.JCR_IDX_ITEM_N_ORDER_NUM = "JCR_IDX_MITEM_N_ORDER_NUM";
                this.JCR_IDX_ITEM_PARENT_FK = "JCR_IDX_MITEM_PARENT_FK";
                this.JCR_ITEM_SEQ = "JCR_MITEM_SEQ";
                this.JCR_ITEM_NEXT_VAL = "JCR_MITEM_NEXT_VAL";
                break;
            }
            case SINGLE: {
                this.JCR_ITEM = "JCR_SITEM";
                this.JCR_VALUE = "JCR_SVALUE";
                this.JCR_REF = "JCR_SREF";
                this.JCR_PK_ITEM = "JCR_PK_SITEM";
                this.JCR_FK_ITEM_PARENT = "JCR_FK_SITEM_PARENT";
                this.JCR_IDX_ITEM_PARENT = "JCR_IDX_SITEM_PARENT";
                this.JCR_IDX_ITEM_PARENT_NAME = "JCR_IDX_SITEM_PARENT_NAME";
                this.JCR_IDX_ITEM_PARENT_ID = "JCR_IDX_SITEM_PARENT_ID";
                this.JCR_PK_VALUE = "JCR_PK_SVALUE";
                this.JCR_FK_VALUE_PROPERTY = "JCR_FK_SVALUE_PROPERTY";
                this.JCR_IDX_VALUE_PROPERTY = "JCR_IDX_SVALUE_PROPERTY";
                this.JCR_PK_REF = "JCR_PK_SREF";
                this.JCR_IDX_REF_PROPERTY = "JCR_IDX_SREF_PROPERTY";
                this.JCR_IDX_ITEM_N_ORDER_NUM = "JCR_IDX_SITEM_N_ORDER_NUM";
                this.JCR_IDX_ITEM_PARENT_FK = "JCR_IDX_SITEM_PARENT_FK";
                this.JCR_ITEM_SEQ = "JCR_SITEM_SEQ";
                this.JCR_ITEM_NEXT_VAL = "JCR_SITEM_NEXT_VAL";
                break;
            }
            case ISOLATED: {
                this.JCR_ITEM = "JCR_I" + this.containerConfig.dbTableSuffix;
                this.JCR_VALUE = "JCR_V" + this.containerConfig.dbTableSuffix;
                this.JCR_REF = "JCR_R" + this.containerConfig.dbTableSuffix;
                this.JCR_PK_ITEM = "JCR_PK_I" + this.containerConfig.dbTableSuffix;
                this.JCR_FK_ITEM_PARENT = "JCR_FK_I" + this.containerConfig.dbTableSuffix + "_PARENT";
                this.JCR_IDX_ITEM_PARENT = "JCR_IDX_I" + this.containerConfig.dbTableSuffix + "_PARENT";
                this.JCR_IDX_ITEM_PARENT_NAME = "JCR_IDX_I" + this.containerConfig.dbTableSuffix + "_PARENT_NAME";
                this.JCR_IDX_ITEM_PARENT_ID = "JCR_IDX_I" + this.containerConfig.dbTableSuffix + "_PARENT_ID";
                this.JCR_PK_VALUE = "JCR_PK_V" + this.containerConfig.dbTableSuffix;
                this.JCR_FK_VALUE_PROPERTY = "JCR_FK_V" + this.containerConfig.dbTableSuffix + "_PROPERTY";
                this.JCR_IDX_VALUE_PROPERTY = "JCR_IDX_V" + this.containerConfig.dbTableSuffix + "_PROPERTY";
                this.JCR_PK_REF = "JCR_PK_R" + this.containerConfig.dbTableSuffix;
                this.JCR_IDX_REF_PROPERTY = "JCR_IDX_R" + this.containerConfig.dbTableSuffix + "_PROPERTY";
                this.JCR_IDX_ITEM_N_ORDER_NUM = "JCR_IDX_I" + this.containerConfig.dbTableSuffix + "_N_ORDER_NUM";
                this.JCR_IDX_ITEM_PARENT_FK = "JCR_IDX_I" + this.containerConfig.dbTableSuffix + "_PARENT_FK";
                this.JCR_ITEM_SEQ = "JCR_I" + this.containerConfig.dbTableSuffix + "_SEQ";
                this.JCR_ITEM_NEXT_VAL = "JCR_I" + this.containerConfig.dbTableSuffix + "_NEXT_VAL";
                break;
            }
        }
    }

    public Connection getJdbcConnection() {
        return this.dbConnection;
    }

    void share() {
        if (this.dbConnectionTotalUsed == null) {
            this.dbConnectionTotalUsed = new AtomicInteger(1);
        }
        this.dbConnectionTotalUsed.incrementAndGet();
    }

    int getDbConnectionTotalUsed() {
        return this.dbConnectionTotalUsed == null ? 1 : this.dbConnectionTotalUsed.get();
    }

    int release() {
        return this.dbConnectionTotalUsed == null ? 0 : this.dbConnectionTotalUsed.decrementAndGet();
    }

    protected abstract void prepareQueries() throws SQLException;

    protected abstract String getInternalId(String var1);

    protected abstract String getIdentifier(String var1);

    protected void checkIfOpened() throws IllegalStateException {
        if (!this.isOpened()) {
            throw new IllegalStateException("Connection is already closed", this.closedByCallStack);
        }
    }

    @Override
    public boolean isOpened() {
        try {
            return !this.dbConnection.isClosed();
        }
        catch (SQLException e) {
            LOG.error((Object)("An exception occured: " + e.getMessage()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void rollback() throws IllegalStateException, RepositoryException {
        this.checkIfOpened();
        try {
            this.closeStatements();
            if (!this.readOnly) {
                try {
                    if (this.getDbConnectionTotalUsed() == 1) {
                        this.dbConnection.rollback();
                    }
                }
                finally {
                    IOException e = null;
                    for (int p = this.valueChanges.size() - 1; p >= 0; --p) {
                        try {
                            this.valueChanges.get(p).rollback();
                            continue;
                        }
                        catch (IOException e1) {
                            if (e == null) {
                                e = e1;
                                continue;
                            }
                            LOG.error((Object)"Could not rollback value change", (Throwable)e1);
                        }
                    }
                    if (e != null) {
                        throw e;
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            block24: {
                this.valueChanges.clear();
                try {
                    if (this.release() == 0) {
                        this.dbConnection.close();
                    }
                }
                catch (SQLException e) {
                    if (!LOG.isWarnEnabled()) break block24;
                    LOG.warn((Object)"Could not close the connection", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void close() throws IllegalStateException, RepositoryException {
        this.checkIfOpened();
        if (LOG.isDebugEnabled()) {
            this.closedByCallStack = new Exception("The connection has been closed by the following call stack");
        }
        try {
            this.closeStatements();
            if (!this.readOnly && this.getDbConnectionTotalUsed() == 1 && this.dbConnection.getTransactionIsolation() > 2) {
                this.dbConnection.rollback();
            }
            if (this.release() == 0) {
                this.dbConnection.close();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void closeStatements() {
        try {
            if (this.findItemById != null) {
                this.findItemById.close();
            }
            if (this.findItemByPath != null) {
                this.findItemByPath.close();
            }
            if (this.findItemByName != null) {
                this.findItemByName.close();
            }
            if (this.findChildPropertyByPath != null) {
                this.findChildPropertyByPath.close();
            }
            if (this.findPropertyByName != null) {
                this.findPropertyByName.close();
            }
            if (this.findDescendantNodes != null) {
                this.findDescendantNodes.close();
            }
            if (this.findDescendantProperties != null) {
                this.findDescendantProperties.close();
            }
            if (this.findReferences != null) {
                this.findReferences.close();
            }
            if (this.findValuesByPropertyId != null) {
                this.findValuesByPropertyId.close();
            }
            if (this.findValuesDataByPropertyId != null) {
                this.findValuesDataByPropertyId.close();
            }
            if (this.findNodesByParentId != null) {
                this.findNodesByParentId.close();
            }
            if (this.findLastOrderNumberByParentId != null) {
                this.findLastOrderNumberByParentId.close();
            }
            if (this.findNodesCountByParentId != null) {
                this.findNodesCountByParentId.close();
            }
            if (this.findPropertiesByParentId != null) {
                this.findPropertiesByParentId.close();
            }
            if (this.findMaxPropertyVersions != null) {
                this.findMaxPropertyVersions.close();
            }
            if (this.insertNode != null) {
                this.insertNode.close();
            }
            if (this.insertProperty != null) {
                this.insertProperty.close();
            }
            if (this.insertReference != null) {
                this.insertReference.close();
            }
            if (this.insertValue != null) {
                this.insertValue.close();
            }
            if (this.updateNode != null) {
                this.updateNode.close();
            }
            if (this.updateProperty != null) {
                this.updateProperty.close();
            }
            if (this.deleteItem != null) {
                this.deleteItem.close();
            }
            if (this.deleteReference != null) {
                this.deleteReference.close();
            }
            if (this.deleteValue != null) {
                this.deleteValue.close();
            }
            if (this.renameNode != null) {
                this.renameNode.close();
            }
            if (this.findNodesAndProperties != null) {
                this.findNodesAndProperties.close();
            }
            if (this.findNodesCount != null) {
                this.findNodesCount.close();
            }
            if (this.findWorkspaceDataSize != null) {
                this.findWorkspaceDataSize.close();
            }
            if (this.findNodeDataSize != null) {
                this.findNodeDataSize.close();
            }
            if (this.findNodePropertiesOnValueStorage != null) {
                this.findNodePropertiesOnValueStorage.close();
            }
            if (this.findWorkspacePropertiesOnValueStorage != null) {
                this.findWorkspacePropertiesOnValueStorage.close();
            }
            if (this.findValueStorageDescAndSize != null) {
                this.findValueStorageDescAndSize.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the statement: " + e.getMessage()));
        }
    }

    @Override
    public void prepare() throws IllegalStateException, RepositoryException {
        try {
            for (ValueIOChannel vo : this.valueChanges) {
                vo.prepare();
            }
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        this.onPreCommit();
    }

    @Override
    public final void commit() throws IllegalStateException, RepositoryException {
        block17: {
            this.checkIfOpened();
            try {
                this.closeStatements();
                if (this.readOnly) break block17;
                try {
                    for (ValueIOChannel vo : this.valueChanges) {
                        vo.twoPhaseCommit();
                    }
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
                finally {
                    this.valueChanges.clear();
                }
                if (this.getDbConnectionTotalUsed() == 1) {
                    this.dbConnection.commit();
                }
            }
            catch (SQLException e) {
                throw new RepositoryException((Throwable)e);
            }
            finally {
                block19: {
                    try {
                        if (this.release() == 0) {
                            this.dbConnection.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!LOG.isWarnEnabled()) break block19;
                        LOG.warn((Object)"Could not close the connection", (Throwable)e);
                    }
                }
            }
        }
    }

    protected void onPreCommit() throws IllegalStateException, RepositoryException {
    }

    @Override
    public void add(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            this.addNodeRecord(data);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Node added " + data.getQPath().getAsString() + ", " + data.getIdentifier() + ", " + data.getPrimaryTypeName().getAsString()));
            }
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Node add. Database error: " + String.valueOf(e)));
            }
            this.exceptionHandler.handleAddException(e, (ItemData)data);
        }
    }

    @Override
    public void add(PropertyData data, ChangedSizeHandler sizeHandler) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            this.addPropertyRecord(data);
            if (data.getType() == 9) {
                try {
                    this.addReference(data);
                }
                catch (IOException e) {
                    throw new RepositoryException("Can't read REFERENCE property (" + String.valueOf(data.getQPath()) + " " + data.getIdentifier() + ") value: " + e.getMessage(), (Throwable)e);
                }
            }
            this.addValues(this.getInternalId(data.getIdentifier()), data, sizeHandler);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Property added " + data.getQPath().getAsString() + ", " + data.getIdentifier() + (String)(data.getValues() != null ? ", values count: " + data.getValues().size() : ", NULL data")));
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Property add. IO error: " + String.valueOf(e)), (Throwable)e);
            }
            throw new RepositoryException("Error of Property Value add " + String.valueOf(e), (Throwable)e);
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Property add. Database error: " + String.valueOf(e)), (Throwable)e);
            }
            this.exceptionHandler.handleAddException(e, (ItemData)data);
        }
    }

    @Override
    public void rename(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            if (this.renameNode(data) <= 0) {
                throw new JCRInvalidItemStateException("(rename) Node not found " + data.getQPath().getAsString() + " " + data.getIdentifier() + ". Probably was deleted by another session ", data.getIdentifier(), 32);
            }
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Property add. Database error: " + String.valueOf(e)), (Throwable)e);
            }
            this.exceptionHandler.handleAddException(e, (ItemData)data);
        }
    }

    @Override
    public void delete(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        String cid = this.getInternalId(data.getIdentifier());
        try {
            int nc = this.deleteItemByIdentifier(cid);
            if (nc <= 0) {
                throw new JCRInvalidItemStateException("(delete) Node not found " + data.getQPath().getAsString() + " " + data.getIdentifier() + ". Probably was deleted by another session ", data.getIdentifier(), 4);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Node deleted " + data.getQPath().getAsString() + ", " + data.getIdentifier() + ", " + data.getPrimaryTypeName().getAsString()));
            }
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Node remove. Database error: " + String.valueOf(e)), (Throwable)e);
            }
            this.exceptionHandler.handleDeleteException(e, data);
        }
    }

    @Override
    public void delete(PropertyData data, ChangedSizeHandler sizeHandler) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        String cid = this.getInternalId(data.getIdentifier());
        try {
            this.deleteValues(cid, data, false, sizeHandler);
            this.deleteReference(cid);
            int nc = this.deleteItemByIdentifier(cid);
            if (nc <= 0) {
                throw new JCRInvalidItemStateException("(delete) Property not found " + data.getQPath().getAsString() + " " + data.getIdentifier() + ". Probably was deleted by another session ", data.getIdentifier(), 4);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Property deleted " + data.getQPath().getAsString() + ", " + data.getIdentifier() + (String)(data.getValues() != null ? ", values count: " + data.getValues().size() : ", NULL data")));
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Property remove. IO error: " + String.valueOf(e)), (Throwable)e);
            }
            throw new RepositoryException("Error of Property Value delete " + String.valueOf(e), (Throwable)e);
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Property remove. Database error: " + String.valueOf(e)), (Throwable)e);
            }
            this.exceptionHandler.handleDeleteException(e, data);
        }
    }

    @Override
    public void update(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            String cid = this.getInternalId(data.getIdentifier());
            if (this.updateNodeByIdentifier(data.getPersistedVersion(), data.getQPath().getIndex(), data.getOrderNumber(), cid) <= 0) {
                throw new JCRInvalidItemStateException("(update) Node not found " + data.getQPath().getAsString() + " " + data.getIdentifier() + ". Probably was deleted by another session ", data.getIdentifier(), 2);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Node updated " + data.getQPath().getAsString() + ", " + data.getIdentifier() + ", " + data.getPrimaryTypeName().getAsString()));
            }
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Node update. Database error: " + String.valueOf(e)), (Throwable)e);
            }
            this.exceptionHandler.handleUpdateException(e, data);
        }
    }

    @Override
    public void update(PropertyData data, ChangedSizeHandler sizeHandler) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            String cid = this.getInternalId(data.getIdentifier());
            if (this.updatePropertyByIdentifier(data.getPersistedVersion(), data.getType(), cid) <= 0) {
                throw new JCRInvalidItemStateException("(update) Property not found " + data.getQPath().getAsString() + " " + data.getIdentifier() + ". Probably was deleted by another session ", data.getIdentifier(), 2);
            }
            try {
                this.deleteReference(cid);
                if (data.getType() == 9) {
                    this.addReference(data);
                }
            }
            catch (IOException e) {
                throw new RepositoryException("Can't update REFERENCE property (" + String.valueOf(data.getQPath()) + " " + data.getIdentifier() + ") value: " + e.getMessage(), (Throwable)e);
            }
            this.deleteValues(cid, data, true, sizeHandler);
            this.addValues(cid, data, sizeHandler);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Property updated " + data.getQPath().getAsString() + ", " + data.getIdentifier() + (String)(data.getValues() != null ? ", values count: " + data.getValues().size() : ", NULL data")));
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Property update. IO error: " + String.valueOf(e)), (Throwable)e);
            }
            throw new RepositoryException("Error of Property Value update " + String.valueOf(e), (Throwable)e);
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Property update. Database error: " + String.valueOf(e)), (Throwable)e);
            }
            this.exceptionHandler.handleUpdateException(e, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException, IllegalStateException {
        ArrayList<NodeData> arrayList;
        this.checkIfOpened();
        ResultSet node = this.findChildNodesByParentIdentifier(this.getInternalId(parent.getIdentifier()));
        try {
            ArrayList<NodeData> childrens = new ArrayList<NodeData>();
            while (node.next()) {
                childrens.add((NodeData)this.itemData(parent.getQPath(), node, 1, parent.getACL()));
            }
            arrayList = childrens;
        }
        catch (Throwable throwable) {
            try {
                try {
                    node.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        try {
            node.close();
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
        }
        return arrayList;
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData parent, List<QPathEntryFilter> pattern) throws RepositoryException, IllegalStateException {
        return this.getChildNodesData(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getLastOrderNumber(NodeData parent) throws RepositoryException {
        this.checkIfOpened();
        try {
            ResultSet count = this.findLastOrderNumberByParentIdentifier(this.getInternalId(parent.getIdentifier()));
            try {
                if (count.next() && count.getInt(1) > 0) {
                    int n = count.getInt(2);
                    return n;
                }
                int n = -1;
                return n;
            }
            finally {
                try {
                    count.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMaxPropertyVersion(PropertyData data) throws RepositoryException {
        this.checkIfOpened();
        try {
            ResultSet count = this.findMaxPropertyVersion(data.getParentIdentifier(), data.getQPath().getName().getAsString(), data.getQPath().getIndex());
            try {
                if (count.next()) {
                    int n = count.getInt(1);
                    return n;
                }
                int n = 0;
                return n;
            }
            finally {
                try {
                    count.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + String.valueOf(e)), (Throwable)e);
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getChildNodesCount(NodeData parent) throws RepositoryException {
        this.checkIfOpened();
        try {
            ResultSet count = this.findChildNodesCountByParentIdentifier(this.getInternalId(parent.getIdentifier()));
            try {
                if (!count.next()) throw new RepositoryException("FATAL No resulton childNodes count for " + parent.getQPath().getAsString());
                int n = count.getInt(1);
                return n;
            }
            finally {
                try {
                    count.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        ArrayList<PropertyData> arrayList;
        this.checkIfOpened();
        ResultSet prop = this.findChildPropertiesByParentIdentifier(this.getInternalId(parent.getIdentifier()));
        try {
            ArrayList<PropertyData> children = new ArrayList<PropertyData>();
            while (prop.next()) {
                children.add((PropertyData)this.itemData(parent.getQPath(), prop, 2, null));
            }
            arrayList = children;
        }
        catch (Throwable throwable) {
            try {
                try {
                    prop.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        try {
            prop.close();
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
        }
        return arrayList;
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent, List<QPathEntryFilter> itemDataFilter) throws RepositoryException, IllegalStateException {
        return this.getChildPropertiesData(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeDataIndexing> getNodesAndProperties(String lastNodeId, int offset, int limit) throws RepositoryException, IllegalStateException {
        ArrayList<NodeDataIndexing> result = new ArrayList<NodeDataIndexing>();
        this.checkIfOpened();
        try {
            this.startTxIfNeeded();
            ResultSet resultSet = this.findNodesAndProperties(lastNodeId, offset, limit);
            int processed = 0;
            try {
                NodeDataIndexing nodeData;
                TempNodeData tempNodeData = null;
                while (resultSet.next()) {
                    ExtendedTempPropertyData parsedProperty;
                    if (tempNodeData == null) {
                        tempNodeData = new TempNodeData(this, resultSet);
                        ++processed;
                    } else if (!resultSet.getString("ID").equals(tempNodeData.cid)) {
                        if (!(this.needToSkipOffsetNodes() && processed <= offset || (nodeData = this.createNodeDataIndexing(tempNodeData)) == null)) {
                            result.add(nodeData);
                        }
                        tempNodeData = new TempNodeData(this, resultSet);
                        ++processed;
                    }
                    if (this.needToSkipOffsetNodes() && processed <= offset) continue;
                    String key = resultSet.getString("P_NAME");
                    SortedSet<TempPropertyData> values = tempNodeData.properties.get(key);
                    if (values == null) {
                        values = new TreeSet<TempPropertyData>();
                        tempNodeData.properties.put(key, values);
                    }
                    try {
                        parsedProperty = new ExtendedTempPropertyData(resultSet);
                    }
                    catch (Exception e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.error("Error parsing data of property {} of node {}, ignore it", new Object[]{key, tempNodeData.cid, e});
                            continue;
                        }
                        LOG.error("Error parsing data of property {} of node {}, ignore it. Error: {}", new Object[]{key, tempNodeData.cid, e.getMessage()});
                        continue;
                    }
                    values.add(parsedProperty);
                }
                if (!(tempNodeData == null || this.needToSkipOffsetNodes() && processed <= offset || (nodeData = this.createNodeDataIndexing(tempNodeData)) == null)) {
                    result.add(nodeData);
                }
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Error during data reindexation", (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        catch (IllegalNameException e) {
            LOG.error((Object)"Error during data reindexation", (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        catch (SQLException e) {
            LOG.error((Object)"Error during data reindexation", (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("getNodesAndProperties(%s, %s, %s) = %s elements", new Object[]{lastNodeId, offset, limit, result.size()});
        }
        return result;
    }

    protected boolean needToSkipOffsetNodes() {
        return false;
    }

    @Override
    public boolean getChildNodesDataByPage(NodeData parent, int fromOrderNum, int offset, int pageSize, List<NodeData> childNodes) throws RepositoryException, IllegalStateException {
        throw new UnsupportedRepositoryOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> listChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        ArrayList<PropertyData> arrayList;
        this.checkIfOpened();
        ResultSet prop = this.findChildPropertiesByParentIdentifier(this.getInternalId(parent.getIdentifier()));
        try {
            ArrayList<PropertyData> children = new ArrayList<PropertyData>();
            while (prop.next()) {
                children.add(this.propertyData(parent.getQPath(), prop));
            }
            arrayList = children;
        }
        catch (Throwable throwable) {
            try {
                try {
                    prop.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        try {
            prop.close();
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
        }
        return arrayList;
    }

    @Override
    public List<ACLHolder> getACLHolders() throws RepositoryException, IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException("This method is not supported by the old JDBCWorkspaceDataContainer, use CQJDBCWorkspaceDataContainer instead.");
    }

    @Override
    public ItemData getItemData(String identifier) throws RepositoryException, IllegalStateException {
        return this.getItemByIdentifier(this.getInternalId(identifier));
    }

    @Override
    public boolean hasItemData(NodeData parentData, QPathEntry name, ItemType itemType) throws RepositoryException, IllegalStateException {
        return this.hasItemByName(parentData, this.getInternalId(parentData.getIdentifier()), name, itemType);
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name, ItemType itemType) throws RepositoryException, IllegalStateException {
        if (parentData != null) {
            return this.getItemByName(parentData, this.getInternalId(parentData.getIdentifier()), name, itemType);
        }
        return this.getItemByName(null, null, name, itemType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getReferencesData(String nodeIdentifier) throws RepositoryException, IllegalStateException {
        ArrayList<PropertyData> arrayList;
        this.checkIfOpened();
        this.startTxIfNeeded();
        ResultSet refProps = this.findReferences(this.getInternalId(nodeIdentifier));
        try {
            ArrayList<PropertyData> references = new ArrayList<PropertyData>();
            while (refProps.next()) {
                references.add((PropertyData)this.itemData(null, refProps, 2, null));
            }
            arrayList = references;
        }
        catch (Throwable throwable) {
            try {
                try {
                    refProps.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        try {
            refProps.close();
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getNodesCount() throws RepositoryException {
        try {
            ResultSet countNodes = this.findNodesCount();
            try {
                if (!countNodes.next()) throw new SQLException("ResultSet has't records.");
                long l = countNodes.getLong(1);
                return l;
            }
            finally {
                JDBCUtils.freeResources((ResultSet)countNodes, null, null);
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Can not calculate nodes count", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getWorkspaceDataSize() throws RepositoryException {
        long dataSize = 0L;
        ResultSet result = null;
        try {
            result = this.findWorkspaceDataSize();
            try {
                if (result.next()) {
                    dataSize += result.getLong(1);
                }
            }
            finally {
                JDBCUtils.freeResources((ResultSet)result, null, null);
            }
            result = this.findWorkspacePropertiesOnValueStorage();
            try {
                while (result.next()) {
                    String storageDesc = result.getString("STORAGE_DESC");
                    String propertyId = result.getString("PROPERTY_ID");
                    int orderNum = result.getInt("ORDER_NUM");
                    ValueIOChannel channel = this.containerConfig.valueStorageProvider.getChannel(storageDesc);
                    dataSize += channel.getValueSize(this.getIdentifier(propertyId), orderNum);
                }
            }
            finally {
                JDBCUtils.freeResources((ResultSet)result, null, null);
            }
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (SQLException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        return dataSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNodeDataSize(String nodeIdentifier) throws RepositoryException {
        long dataSize = 0L;
        ResultSet result = null;
        try {
            result = this.findNodeDataSize(this.getInternalId(nodeIdentifier));
            try {
                if (result.next()) {
                    dataSize += result.getLong(1);
                }
            }
            finally {
                JDBCUtils.freeResources((ResultSet)result, null, null);
            }
            result = this.findNodePropertiesOnValueStorage(this.getInternalId(nodeIdentifier));
            try {
                while (result.next()) {
                    String storageDesc = result.getString("STORAGE_DESC");
                    String propertyId = result.getString("PROPERTY_ID");
                    int orderNum = result.getInt("ORDER_NUM");
                    ValueIOChannel channel = this.containerConfig.valueStorageProvider.getChannel(storageDesc);
                    dataSize += channel.getValueSize(this.getIdentifier(propertyId), orderNum);
                }
            }
            finally {
                JDBCUtils.freeResources((ResultSet)result, null, null);
            }
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (SQLException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        return dataSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ItemData getItemByIdentifier(String cid) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        try {
            ResultSet item = this.findItemByIdentifier(cid);
            try {
                if (item.next()) {
                    ItemData itemData = this.itemData(null, item, item.getInt("I_CLASS"), null);
                    return itemData;
                }
                ItemData itemData = null;
                return itemData;
            }
            finally {
                try {
                    item.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("getItemData() error", (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException("getItemData() error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasItemByName(NodeData parent, String parentId, QPathEntry name, ItemType itemType) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        try {
            ResultSet item = null;
            try {
                item = this.findItemByName(parentId, name.getAsString(), name.getIndex());
                while (item.next()) {
                    int columnClass = item.getInt("I_CLASS");
                    if (itemType != ItemType.UNKNOWN && columnClass != itemType.ordinal()) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (item != null) {
                        item.close();
                    }
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ItemData getItemByName(NodeData parent, String parentId, QPathEntry name, ItemType itemType) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        try {
            ResultSet item = null;
            try {
                item = this.findItemByName(parentId, name.getAsString(), name.getIndex());
                while (item.next()) {
                    int columnClass = item.getInt("I_CLASS");
                    if (itemType != ItemType.UNKNOWN && columnClass != itemType.ordinal()) continue;
                    ItemData itemData = this.itemData(parent.getQPath(), item, columnClass, parent.getACL());
                    return itemData;
                }
                ItemData itemData = null;
                return itemData;
            }
            finally {
                try {
                    if (item != null) {
                        item.close();
                    }
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("Unable to read binary content from disk for node " + String.valueOf(parent.getQPath()) + ". The binary content is not accessible, it was removed, or may have been quarantined by an antivirus."), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected QPath traverseQPath(String cpid) throws SQLException, InvalidItemStateException, IllegalNameException {
        return this.traverseQPathSQ(cpid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QPath traverseQPathSQ(String cpid) throws SQLException, InvalidItemStateException, IllegalNameException {
        ArrayList<QPathEntry> qrpath = new ArrayList<QPathEntry>();
        String caid = cpid;
        do {
            ResultSet parent = this.findItemByIdentifier(caid);
            try {
                if (!parent.next()) {
                    throw new InvalidItemStateException("Parent not found, uuid: " + this.getIdentifier(caid));
                }
                QPathEntry qpe = new QPathEntry(InternalQName.parse(parent.getString("NAME")), parent.getInt("I_INDEX"), this.getIdentifier(caid));
                qrpath.add(qpe);
                caid = parent.getString("PARENT_ID");
                if (caid.equals(parent.getString("ID"))) {
                    throw new InvalidItemStateException("An item with id='" + this.getIdentifier(caid) + "' is its own parent");
                }
            }
            finally {
                try {
                    parent.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
        } while (!caid.equals(Constants.ROOT_PARENT_UUID));
        QPathEntry[] qentries = new QPathEntry[qrpath.size()];
        int qi = 0;
        for (int i = qrpath.size() - 1; i >= 0; --i) {
            qentries[qi++] = (QPathEntry)qrpath.get(i);
        }
        return new QPath(qentries);
    }

    protected String findParentId(String cid) throws SQLException, RepositoryException {
        ResultSet pidrs = this.findItemByIdentifier(cid);
        try {
            if (pidrs.next()) {
                String string = pidrs.getString("PARENT_ID");
                return string;
            }
            throw new RepositoryException("Item not found id: " + this.getIdentifier(cid));
        }
        finally {
            try {
                pidrs.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
            }
        }
    }

    private ItemData itemData(QPath parentPath, ResultSet item, int itemClass, AccessControlList parentACL) throws RepositoryException, SQLException, IOException {
        String cid = item.getString("ID");
        String cname = item.getString("NAME");
        int cversion = item.getInt("VERSION");
        String cpid = item.getString("PARENT_ID");
        try {
            if (itemClass == 1) {
                int cindex = item.getInt("I_INDEX");
                int cnordernumb = item.getInt("N_ORDER_NUM");
                return this.loadNodeRecord(parentPath, cname, cid, cpid, cindex, cversion, cnordernumb, parentACL);
            }
            int cptype = item.getInt("P_TYPE");
            boolean cpmultivalued = item.getBoolean("P_MULTIVALUED");
            return this.loadPropertyRecord(parentPath, cname, cid, cpid, cversion, cptype, cpmultivalued);
        }
        catch (InvalidItemStateException e) {
            throw new InvalidItemStateException("FATAL: Can't build item path for name " + cname + " id: " + this.getIdentifier(cid) + ". " + String.valueOf((Object)e));
        }
    }

    private PropertyData propertyData(QPath parentPath, ResultSet item) throws RepositoryException, SQLException, IOException {
        String cid = item.getString("ID");
        String cname = item.getString("NAME");
        int cversion = item.getInt("VERSION");
        String cpid = item.getString("PARENT_ID");
        int cptype = item.getInt("P_TYPE");
        boolean cpmultivalued = item.getBoolean("P_MULTIVALUED");
        try {
            InternalQName qname = InternalQName.parse(cname);
            QPath qpath = QPath.makeChildPath(parentPath == null ? this.traverseQPath(cpid) : parentPath, qname);
            PersistedPropertyData pdata = new PersistedPropertyData(this.getIdentifier(cid), qpath, this.getIdentifier(cpid), cversion, cptype, cpmultivalued, new ArrayList<ValueData>(), new SimplePersistedSize(0L));
            return pdata;
        }
        catch (InvalidItemStateException e) {
            throw new InvalidItemStateException("FATAL: Can't build property path for name " + cname + " id: " + this.getIdentifier(cid) + ". " + String.valueOf((Object)e));
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MixinInfo readMixins(String cid) throws SQLException, IllegalNameException {
        ResultSet mtrs = this.findPropertyByName(cid, Constants.JCR_MIXINTYPES.getAsString());
        try {
            ArrayList<InternalQName> mts = null;
            boolean owneable = false;
            boolean privilegeable = false;
            if (mtrs.next()) {
                mts = new ArrayList<InternalQName>();
                do {
                    byte[] mxnb;
                    if ((mxnb = mtrs.getBytes("DATA")) == null) continue;
                    InternalQName mxn = InternalQName.parse(new String(mxnb));
                    mts.add(mxn);
                    if (!privilegeable && Constants.EXO_PRIVILEGEABLE.equals((Object)mxn)) {
                        privilegeable = true;
                        continue;
                    }
                    if (owneable || !Constants.EXO_OWNEABLE.equals((Object)mxn)) continue;
                    owneable = true;
                } while (mtrs.next());
            }
            MixinInfo mixinInfo = new MixinInfo(this, mts, owneable, privilegeable);
            return mixinInfo;
        }
        finally {
            try {
                mtrs.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
            }
        }
    }

    protected List<AccessControlEntry> readACLPermisions(String cid) throws SQLException, IllegalACLException {
        ArrayList<AccessControlEntry> naPermissions = new ArrayList<AccessControlEntry>();
        ResultSet exoPerm = this.findPropertyByName(cid, Constants.EXO_PERMISSIONS.getAsString());
        try {
            if (exoPerm.next()) {
                do {
                    naPermissions.add(AccessControlEntry.parse(new String(exoPerm.getBytes("DATA"))));
                } while (exoPerm.next());
                ArrayList<AccessControlEntry> arrayList = naPermissions;
                return arrayList;
            }
            throw new IllegalACLException("Property exo:permissions is not found for node with id: " + this.getIdentifier(cid));
        }
        finally {
            try {
                exoPerm.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
            }
        }
    }

    protected String readACLOwner(String cid) throws SQLException, IllegalACLException {
        ResultSet exoOwner = this.findPropertyByName(cid, Constants.EXO_OWNER.getAsString());
        try {
            if (exoOwner.next()) {
                String string = new String(exoOwner.getBytes("DATA"));
                return string;
            }
            throw new IllegalACLException("Property exo:owner is not found for node with id: " + this.getIdentifier(cid));
        }
        finally {
            try {
                exoOwner.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PersistedNodeData loadNodeRecord(QPath parentPath, String cname, String cid, String cpid, int cindex, int cversion, int cnordernumb, AccessControlList parentACL) throws RepositoryException, SQLException {
        try {
            String parentCid;
            QPath qpath;
            InternalQName qname = InternalQName.parse(cname);
            if (parentPath != null) {
                qpath = QPath.makeChildPath(parentPath, qname, cindex, this.getIdentifier(cid));
                parentCid = cpid;
            } else if (cpid.equals(Constants.ROOT_PARENT_UUID)) {
                qpath = Constants.ROOT_PATH;
                parentCid = null;
            } else {
                qpath = QPath.makeChildPath(this.traverseQPath(cpid), qname, cindex, this.getIdentifier(cid));
                parentCid = cpid;
            }
            ResultSet ptProp = this.findPropertyByName(cid, Constants.JCR_PRIMARYTYPE.getAsString());
            try {
                if (!ptProp.next()) {
                    throw new PrimaryTypeNotFoundException("FATAL ERROR primary type record not found. Node " + qpath.getAsString() + ", id " + this.getIdentifier(cid) + ", container " + this.containerConfig.containerName, null);
                }
                byte[] data = ptProp.getBytes("DATA");
                InternalQName ptName = InternalQName.parse(new String(data != null ? data : new byte[]{}));
                MixinInfo mixins = this.readMixins(cid);
                AccessControlList acl = mixins.hasOwneable() ? (mixins.hasPrivilegeable() ? new AccessControlList(this.readACLOwner(cid), this.readACLPermisions(cid)) : (parentACL != null ? new AccessControlList(this.readACLOwner(cid), parentACL.hasPermissions() ? parentACL.getPermissionEntries() : null) : new AccessControlList(this.readACLOwner(cid), null))) : (mixins.hasPrivilegeable() ? (mixins.hasOwneable() ? new AccessControlList(this.readACLOwner(cid), this.readACLPermisions(cid)) : (parentACL != null ? new AccessControlList(parentACL.getOwner(), this.readACLPermisions(cid)) : new AccessControlList(null, this.readACLPermisions(cid)))) : (parentACL != null ? new AccessControlList(parentACL.getOwner(), parentACL.hasPermissions() ? parentACL.getPermissionEntries() : null) : null));
                PersistedNodeData persistedNodeData = new PersistedNodeData(this.getIdentifier(cid), qpath, this.getIdentifier(parentCid), cversion, cnordernumb, ptName, mixins.mixinNames(), acl);
                return persistedNodeData;
            }
            catch (IllegalACLException e) {
                throw new RepositoryException("FATAL ERROR Node " + this.getIdentifier(cid) + " " + qpath.getAsString() + " has wrong formed ACL. ", (Throwable)e);
            }
            finally {
                try {
                    ptProp.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected PersistedPropertyData loadPropertyRecord(QPath parentPath, String cname, String cid, String cpid, int cversion, int cptype, boolean cpmultivalued) throws RepositoryException, SQLException, IOException {
        try {
            QPath qpath = QPath.makeChildPath(parentPath == null ? this.traverseQPath(cpid) : parentPath, InternalQName.parse(cname));
            String identifier = this.getIdentifier(cid);
            List<ValueDataUtil.ValueDataWrapper> data = this.readValues(cid, cptype, identifier, cversion);
            long size = 0L;
            ArrayList<ValueData> values = new ArrayList<ValueData>();
            for (ValueDataUtil.ValueDataWrapper vdDataWrapper : data) {
                values.add(vdDataWrapper.value);
                size += vdDataWrapper.size;
            }
            PersistedPropertyData pdata = new PersistedPropertyData(identifier, qpath, this.getIdentifier(cpid), cversion, cptype, cpmultivalued, values, new SimplePersistedSize(size));
            return pdata;
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteValues(String cid, PropertyData pdata, boolean update, ChangedSizeHandler sizeHandler) throws IOException, SQLException, RepositoryException, InvalidItemStateException {
        HashSet<String> storages = new HashSet<String>();
        ResultSet valueRecords = this.findValueStorageDescAndSize(cid);
        try {
            if (valueRecords.next()) {
                do {
                    String storageId = valueRecords.getString("STORAGE_DESC");
                    if (!valueRecords.wasNull()) {
                        storages.add(storageId);
                        continue;
                    }
                    sizeHandler.accumulatePrevSize(valueRecords.getLong(1));
                } while (valueRecords.next());
            }
            for (String storageId : storages) {
                try (ValueIOChannel channel = this.containerConfig.valueStorageProvider.getChannel(storageId);){
                    sizeHandler.accumulatePrevSize(channel.getValueSize(pdata.getIdentifier()));
                    channel.delete(pdata.getIdentifier());
                    this.valueChanges.add(channel);
                }
            }
            this.deleteValueData(cid);
        }
        finally {
            JDBCUtils.freeResources((ResultSet)valueRecords, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ValueDataUtil.ValueDataWrapper> readValues(String cid, int cptype, String identifier, int cversion) throws IOException, SQLException, ValueStorageNotFoundException {
        ArrayList<ValueDataUtil.ValueDataWrapper> data = new ArrayList<ValueDataUtil.ValueDataWrapper>();
        ResultSet valueRecords = this.findValuesByPropertyId(cid);
        try {
            while (valueRecords.next()) {
                int orderNum = valueRecords.getInt("ORDER_NUM");
                String storageId = valueRecords.getString("STORAGE_DESC");
                ValueDataUtil.ValueDataWrapper vdWrapper = valueRecords.wasNull() ? ValueDataUtil.readValueData(cid, cptype, orderNum, cversion, valueRecords.getBinaryStream("DATA"), this.containerConfig.spoolConfig) : this.readValueData(identifier, orderNum, cptype, storageId);
                data.add(vdWrapper);
            }
        }
        finally {
            try {
                valueRecords.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueDataUtil.ValueDataWrapper readValueData(String identifier, int orderNumber, int type, String storageId) throws SQLException, IOException, ValueStorageNotFoundException {
        try (ValueIOChannel channel = this.containerConfig.valueStorageProvider.getChannel(storageId);){
            ValueDataUtil.ValueDataWrapper valueDataWrapper = channel.read(identifier, orderNumber, type, this.containerConfig.spoolConfig);
            return valueDataWrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addValues(String cid, PropertyData data, ChangedSizeHandler sizeHandler) throws IOException, SQLException, RepositoryException {
        List<ValueData> vdata = data.getValues();
        for (int i = 0; i < vdata.size(); ++i) {
            String storageId;
            int streamLength;
            InputStream stream;
            ValueData vd = vdata.get(i);
            ValueIOChannel channel = this.containerConfig.valueStorageProvider.getApplicableChannel(data, i);
            if (channel == null) {
                if (vd.isByteArray()) {
                    byte[] dataBytes = vd.getAsByteArray();
                    stream = new ByteArrayInputStream(dataBytes);
                    streamLength = dataBytes.length;
                } else {
                    StreamPersistedValueData streamData;
                    block9: {
                        streamData = (StreamPersistedValueData)vd;
                        SwapFile swapFile = SwapFile.get(this.containerConfig.spoolConfig.tempDirectory, cid + i + "." + data.getPersistedVersion(), this.containerConfig.spoolConfig.fileCleaner);
                        try {
                            long vlen = WRITE_VALUE_HELPER.writeStreamedValue(swapFile, streamData);
                            if (vlen <= Integer.MAX_VALUE) {
                                streamLength = (int)vlen;
                                break block9;
                            }
                            throw new RepositoryException("Value data large of allowed by JDBC (Integer.MAX_VALUE) " + vlen + ". Property " + data.getQPath().getAsString());
                        }
                        finally {
                            swapFile.spoolDone();
                        }
                    }
                    stream = streamData.getAsStream();
                }
                storageId = null;
                sizeHandler.accumulateNewSize(streamLength);
            } else {
                this.valueChanges.add(channel);
                channel.write(data.getIdentifier(), vd, sizeHandler);
                storageId = channel.getStorageId();
                stream = null;
                streamLength = 0;
            }
            this.addValueData(cid, i, stream, streamLength, storageId);
        }
    }

    protected NodeDataIndexing createNodeDataIndexing(TempNodeData tempNode) throws RepositoryException, SQLException, IOException, IllegalNameException {
        QPath parentPath;
        String parentCid;
        if (tempNode.cpid.equals(Constants.ROOT_PARENT_UUID)) {
            parentCid = null;
            parentPath = Constants.ROOT_PATH;
        } else {
            parentCid = tempNode.cpid;
            parentPath = QPath.makeChildPath(this.traverseQPath(tempNode.cpid), InternalQName.parse(tempNode.cname), tempNode.cindex);
        }
        SortedSet<TempPropertyData> primaryTypes = tempNode.properties.get(Constants.JCR_PRIMARYTYPE.getAsString());
        if (primaryTypes == null) {
            LOG.error("Unable to get the primary types of the node {}", new Object[]{tempNode.cid});
            return null;
        }
        TempPropertyData primaryType = primaryTypes.first();
        if (primaryType == null) {
            LOG.error("Unable to get the first primary type of node {}", new Object[]{tempNode.cid});
            return null;
        }
        ValueData ptValueData = primaryType.getValueData();
        long ptSize = primaryType.getSize();
        InternalQName ptName = InternalQName.parse(ValueDataUtil.getString(ptValueData));
        ArrayList<ValueData> mixinsData = new ArrayList<ValueData>();
        ArrayList<InternalQName> mixins = new ArrayList<InternalQName>();
        long mixinsSize = 0L;
        Set mixinsTempProps = tempNode.properties.get(Constants.JCR_MIXINTYPES.getAsString());
        if (mixinsTempProps != null) {
            for (TempPropertyData mxnb : mixinsTempProps) {
                ValueData vdata = mxnb.getValueData();
                mixinsData.add(vdata);
                mixins.add(InternalQName.parse(ValueDataUtil.getString(vdata)));
                mixinsSize += mxnb.getSize();
            }
        }
        PersistedNodeData nodeData = new PersistedNodeData(this.getIdentifier(tempNode.cid), parentPath, this.getIdentifier(parentCid), tempNode.cversion, tempNode.cnordernumb, ptName, mixins.toArray(new InternalQName[mixins.size()]), null);
        HashMap<String, PropertyData> childProps = new HashMap<String, PropertyData>();
        for (String propName : tempNode.properties.keySet()) {
            ExtendedTempPropertyData prop = (ExtendedTempPropertyData)tempNode.properties.get(propName).first();
            String identifier = this.getIdentifier(prop.id);
            QPath qpath = QPath.makeChildPath(parentPath, InternalQName.parse(prop.name));
            ArrayList<ValueData> values = new ArrayList<ValueData>();
            long size = 0L;
            if (propName.equals(Constants.JCR_PRIMARYTYPE.getAsString())) {
                values.add(ptValueData);
                size = ptSize;
            } else if (propName.equals(Constants.JCR_MIXINTYPES.getAsString())) {
                values = mixinsData;
                size = mixinsSize;
            } else {
                for (TempPropertyData tempProp : tempNode.properties.get(propName)) {
                    ExtendedTempPropertyData exTempProp = (ExtendedTempPropertyData)tempProp;
                    values.add(exTempProp.getValueData());
                    size += exTempProp.getSize();
                }
            }
            PersistedPropertyData pdata = new PersistedPropertyData(identifier, qpath, this.getIdentifier(tempNode.cid), prop.version, prop.type, prop.multi, values, new SimplePersistedSize(size));
            childProps.put(propName, pdata);
        }
        return new NodeDataIndexing(nodeData, childProps);
    }

    protected void startTxIfNeeded() throws SQLException {
    }

    protected abstract int addNodeRecord(NodeData var1) throws SQLException, InvalidItemStateException, RepositoryException;

    protected abstract int addPropertyRecord(PropertyData var1) throws SQLException, InvalidItemStateException, RepositoryException;

    protected abstract ResultSet findItemByIdentifier(String var1) throws SQLException;

    protected abstract ResultSet findPropertyByName(String var1, String var2) throws SQLException;

    protected abstract ResultSet findItemByName(String var1, String var2, int var3) throws SQLException;

    protected abstract ResultSet findChildNodesByParentIdentifier(String var1) throws SQLException;

    protected abstract ResultSet findLastOrderNumberByParentIdentifier(String var1) throws SQLException;

    protected abstract ResultSet findChildNodesCountByParentIdentifier(String var1) throws SQLException;

    protected abstract ResultSet findChildPropertiesByParentIdentifier(String var1) throws SQLException;

    protected abstract ResultSet findNodesAndProperties(String var1, int var2, int var3) throws SQLException;

    protected abstract ResultSet findChildNodesByParentIdentifier(String var1, int var2, int var3, int var4) throws SQLException;

    protected abstract int addReference(PropertyData var1) throws SQLException, IOException, InvalidItemStateException, RepositoryException;

    protected abstract int renameNode(NodeData var1) throws SQLException, InvalidItemStateException, RepositoryException;

    protected abstract int deleteReference(String var1) throws SQLException, InvalidItemStateException, RepositoryException;

    protected abstract void deleteLockProperties() throws SQLException, InvalidItemStateException, RepositoryException;

    protected abstract ResultSet findReferences(String var1) throws SQLException;

    protected abstract int deleteItemByIdentifier(String var1) throws SQLException, InvalidItemStateException, RepositoryException;

    protected abstract int updateNodeByIdentifier(int var1, int var2, int var3, String var4) throws SQLException, InvalidItemStateException, RepositoryException;

    protected abstract int updatePropertyByIdentifier(int var1, int var2, String var3) throws SQLException, InvalidItemStateException, RepositoryException;

    protected abstract ResultSet findNodesCount() throws SQLException;

    protected abstract int addValueData(String var1, int var2, InputStream var3, int var4, String var5) throws SQLException, InvalidItemStateException, RepositoryException;

    protected abstract int deleteValueData(String var1) throws SQLException, InvalidItemStateException, RepositoryException;

    protected abstract ResultSet findValuesByPropertyId(String var1) throws SQLException;

    protected abstract ResultSet findMaxPropertyVersion(String var1, String var2, int var3) throws SQLException;

    protected abstract ResultSet findWorkspaceDataSize() throws SQLException;

    protected abstract ResultSet findWorkspacePropertiesOnValueStorage() throws SQLException;

    protected abstract ResultSet findNodeDataSize(String var1) throws SQLException;

    protected abstract ResultSet findNodePropertiesOnValueStorage(String var1) throws SQLException;

    protected abstract ResultSet findValueStorageDescAndSize(String var1) throws SQLException;

    protected class TempNodeData {
        public String cid;
        public String cname;
        public int cversion;
        public String cpid;
        public int cindex;
        public int cnordernumb;
        public Map<String, SortedSet<TempPropertyData>> properties = new HashMap<String, SortedSet<TempPropertyData>>();

        public TempNodeData(JDBCStorageConnection this$0, ResultSet item) throws SQLException {
            this.cid = item.getString("ID");
            this.cname = item.getString("NAME");
            this.cversion = item.getInt("VERSION");
            this.cpid = item.getString("PARENT_ID");
            this.cindex = item.getInt("I_INDEX");
            this.cnordernumb = item.getInt("N_ORDER_NUM");
        }
    }

    protected class ExtendedTempPropertyData
    extends TempPropertyData {
        protected final String id;
        protected final String name;
        protected final int version;
        protected final boolean multi;
        protected final int type;
        protected final String storage_desc;

        public ExtendedTempPropertyData(ResultSet item) throws SQLException, ValueStorageNotFoundException, IOException {
            super(JDBCStorageConnection.this, item, false);
            this.id = item.getString("P_ID");
            this.name = item.getString("P_NAME");
            this.version = item.getInt("P_VERSION");
            this.type = item.getInt("P_TYPE");
            this.multi = item.getBoolean("P_MULTIVALUED");
            this.storage_desc = item.getString("STORAGE_DESC");
            this.readData(item);
        }

        @Override
        protected void readData(ResultSet item) throws SQLException, ValueStorageNotFoundException, IOException {
            InputStream is = item.getBinaryStream("DATA");
            ValueDataUtil.ValueDataWrapper vdWrapper = this.storage_desc == null ? ValueDataUtil.readValueData(this.id, this.type, this.orderNum, this.version, is, JDBCStorageConnection.this.containerConfig.spoolConfig) : JDBCStorageConnection.this.readValueData(JDBCStorageConnection.this.getIdentifier(this.id), this.orderNum, this.type, this.storage_desc);
            this.data = vdWrapper.value;
            this.size = vdWrapper.size;
        }
    }

    public class MixinInfo {
        static final int OWNEABLE = 1;
        static final int PRIVILEGEABLE = 2;
        static final int OWNEABLE_PRIVILEGEABLE = 3;
        final List<InternalQName> mixinTypes;
        final boolean owneable;
        final boolean privilegeable;
        final String parentId;

        public MixinInfo(JDBCStorageConnection this$0, List<InternalQName> mixinTypes, boolean owneable, boolean privilegeable) {
            this.parentId = null;
            this.mixinTypes = mixinTypes;
            this.owneable = owneable;
            this.privilegeable = privilegeable;
        }

        public InternalQName[] mixinNames() {
            if (this.mixinTypes != null) {
                InternalQName[] mns = new InternalQName[this.mixinTypes.size()];
                this.mixinTypes.toArray(mns);
                return mns;
            }
            return new InternalQName[0];
        }

        public boolean hasPrivilegeable() {
            return this.privilegeable;
        }

        public boolean hasOwneable() {
            return this.owneable;
        }

        public String getParentId() {
            return this.parentId;
        }
    }

    protected static class WriteValueHelper
    extends ValueFileIOHelper {
        protected WriteValueHelper() {
        }

        @Override
        public long writeStreamedValue(File file, ValueData value) throws IOException {
            return super.writeStreamedValue(file, value);
        }
    }

    protected class TempPropertyData
    implements Comparable<TempPropertyData> {
        protected final int orderNum;
        protected ValueData data;
        protected long size;

        public TempPropertyData(JDBCStorageConnection this$0, ResultSet item) throws SQLException, IOException, ValueStorageNotFoundException {
            this.orderNum = item.getInt("ORDER_NUM");
            this.readData(item);
        }

        public TempPropertyData(JDBCStorageConnection this$0, ResultSet item, boolean readValue) throws SQLException, IOException, ValueStorageNotFoundException {
            this.orderNum = item.getInt("ORDER_NUM");
            if (readValue) {
                this.readData(item);
            }
        }

        protected void readData(ResultSet item) throws SQLException, ValueStorageNotFoundException, IOException {
            byte[] internalData = item.getBytes("DATA");
            this.data = new ByteArrayPersistedValueData(this.orderNum, internalData);
            this.size = internalData.length;
        }

        @Override
        public int compareTo(TempPropertyData o) {
            return this.orderNum - o.orderNum;
        }

        public ValueData getValueData() {
            return this.data;
        }

        public long getSize() {
            return this.size;
        }
    }

    class ItemLocationInfo {
        final QPath qpath;
        final List<String> ancestors;
        final String itemId;

        ItemLocationInfo(JDBCStorageConnection this$0, QPath qpath, List<String> ancestors, String itemId) {
            this.qpath = qpath;
            this.ancestors = ancestors;
            this.itemId = itemId;
        }
    }
}

