/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.unpack.ppm;

import com.github.junrar.io.Raw;
import com.github.junrar.unpack.ppm.FreqData;
import com.github.junrar.unpack.ppm.ModelPPM;
import com.github.junrar.unpack.ppm.Pointer;
import com.github.junrar.unpack.ppm.RangeCoder;
import com.github.junrar.unpack.ppm.SEE2Context;
import com.github.junrar.unpack.ppm.State;
import com.github.junrar.unpack.ppm.StateRef;

public class PPMContext
extends Pointer {
    private static final int unionSize = Math.max(6, 6);
    public static final int size = 2 + unionSize + 4;
    private int numStats;
    private final FreqData freqData;
    private final State oneState;
    private int suffix;
    public static final int[] ExpEscape = new int[]{25, 14, 9, 7, 5, 5, 4, 4, 4, 3, 3, 3, 2, 2, 2, 2};
    private final State tempState1 = new State(null);
    private final State tempState2 = new State(null);
    private final State tempState3 = new State(null);
    private final State tempState4 = new State(null);
    private final State tempState5 = new State(null);
    private PPMContext tempPPMContext = null;
    private final int[] ps = new int[256];

    public PPMContext(byte[] mem) {
        super(mem);
        this.oneState = new State(mem);
        this.freqData = new FreqData(mem);
    }

    public PPMContext init(byte[] mem) {
        this.mem = mem;
        this.pos = 0;
        this.oneState.init(mem);
        this.freqData.init(mem);
        return this;
    }

    public FreqData getFreqData() {
        return this.freqData;
    }

    public void setFreqData(FreqData freqData) {
        this.freqData.setSummFreq(freqData.getSummFreq());
        this.freqData.setStats(freqData.getStats());
    }

    public final int getNumStats() {
        if (this.mem != null) {
            this.numStats = Raw.readShortLittleEndian(this.mem, this.pos) & 0xFFFF;
        }
        return this.numStats;
    }

    public final void setNumStats(int numStats) {
        this.numStats = numStats & 0xFFFF;
        if (this.mem != null) {
            Raw.writeShortLittleEndian(this.mem, this.pos, (short)numStats);
        }
    }

    public State getOneState() {
        return this.oneState;
    }

    public void setOneState(StateRef oneState) {
        this.oneState.setValues(oneState);
    }

    public int getSuffix() {
        if (this.mem != null) {
            this.suffix = Raw.readIntLittleEndian(this.mem, this.pos + 8);
        }
        return this.suffix;
    }

    public void setSuffix(PPMContext suffix) {
        this.setSuffix(suffix.getAddress());
    }

    public void setSuffix(int suffix) {
        this.suffix = suffix;
        if (this.mem != null) {
            Raw.writeIntLittleEndian(this.mem, this.pos + 8, suffix);
        }
    }

    @Override
    public void setAddress(int pos) {
        super.setAddress(pos);
        this.oneState.setAddress(pos + 2);
        this.freqData.setAddress(pos + 2);
    }

    private PPMContext getTempPPMContext(byte[] mem) {
        if (this.tempPPMContext == null) {
            this.tempPPMContext = new PPMContext(null);
        }
        return this.tempPPMContext.init(mem);
    }

    public int createChild(ModelPPM model, State pStats, StateRef firstState) {
        PPMContext pc = this.getTempPPMContext(model.getSubAlloc().getHeap());
        pc.setAddress(model.getSubAlloc().allocContext());
        if (pc != null) {
            pc.setNumStats(1);
            pc.setOneState(firstState);
            pc.setSuffix(this);
            pStats.setSuccessor(pc);
        }
        return pc.getAddress();
    }

    public void rescale(ModelPPM model) {
        StateRef tmp;
        int OldNS = this.getNumStats();
        int i = this.getNumStats() - 1;
        State p1 = new State(model.getHeap());
        State p = new State(model.getHeap());
        State temp = new State(model.getHeap());
        p.setAddress(model.getFoundState().getAddress());
        while (p.getAddress() != this.freqData.getStats()) {
            temp.setAddress(p.getAddress() - 6);
            State.ppmdSwap(p, temp);
            p.decAddress();
        }
        temp.setAddress(this.freqData.getStats());
        temp.incFreq(4);
        this.freqData.incSummFreq(4);
        int EscFreq = this.freqData.getSummFreq() - p.getFreq();
        int Adder = model.getOrderFall() != 0 ? 1 : 0;
        p.setFreq(p.getFreq() + Adder >>> 1);
        this.freqData.setSummFreq(p.getFreq());
        do {
            p.incAddress();
            EscFreq -= p.getFreq();
            p.setFreq(p.getFreq() + Adder >>> 1);
            this.freqData.incSummFreq(p.getFreq());
            temp.setAddress(p.getAddress() - 6);
            if (p.getFreq() <= temp.getFreq()) continue;
            p1.setAddress(p.getAddress());
            tmp = new StateRef();
            tmp.setValues(p1);
            State temp2 = new State(model.getHeap());
            State temp3 = new State(model.getHeap());
            do {
                temp2.setAddress(p1.getAddress() - 6);
                p1.setValues(temp2);
                p1.decAddress();
                temp3.setAddress(p1.getAddress() - 6);
            } while (p1.getAddress() != this.freqData.getStats() && tmp.getFreq() > temp3.getFreq());
            p1.setValues(tmp);
        } while (--i != 0);
        if (p.getFreq() == 0) {
            do {
                ++i;
                p.decAddress();
            } while (p.getFreq() == 0);
            EscFreq += i;
            this.setNumStats(this.getNumStats() - i);
            if (this.getNumStats() == 1) {
                tmp = new StateRef();
                temp.setAddress(this.freqData.getStats());
                tmp.setValues(temp);
                do {
                    tmp.decFreq(tmp.getFreq() >>> 1);
                } while ((EscFreq >>>= 1) > 1);
                model.getSubAlloc().freeUnits(this.freqData.getStats(), OldNS + 1 >>> 1);
                this.oneState.setValues(tmp);
                model.getFoundState().setAddress(this.oneState.getAddress());
                return;
            }
        }
        EscFreq -= EscFreq >>> 1;
        this.freqData.incSummFreq(EscFreq);
        int n0 = OldNS + 1 >>> 1;
        int n1 = this.getNumStats() + 1 >>> 1;
        if (n0 != n1) {
            this.freqData.setStats(model.getSubAlloc().shrinkUnits(this.freqData.getStats(), n0, n1));
        }
        model.getFoundState().setAddress(this.freqData.getStats());
    }

    private int getArrayIndex(ModelPPM Model, State rs) {
        PPMContext tempSuffix = this.getTempPPMContext(Model.getSubAlloc().getHeap());
        tempSuffix.setAddress(this.getSuffix());
        int ret = 0;
        ret += Model.getPrevSuccess();
        ret += Model.getNS2BSIndx()[tempSuffix.getNumStats() - 1];
        ret += Model.getHiBitsFlag() + 2 * Model.getHB2Flag()[rs.getSymbol()];
        return ret += Model.getRunLength() >>> 26 & 0x20;
    }

    public int getMean(int summ, int shift, int round) {
        return summ + (1 << shift - round) >>> shift;
    }

    public void decodeBinSymbol(ModelPPM model) {
        State rs = this.tempState1.init(model.getHeap());
        rs.setAddress(this.oneState.getAddress());
        model.setHiBitsFlag(model.getHB2Flag()[model.getFoundState().getSymbol()]);
        int off1 = rs.getFreq() - 1;
        int off2 = this.getArrayIndex(model, rs);
        int bs = model.getBinSumm()[off1][off2];
        if (model.getCoder().getCurrentShiftCount(14) < (long)bs) {
            model.getFoundState().setAddress(rs.getAddress());
            rs.incFreq(rs.getFreq() < 128 ? 1 : 0);
            model.getCoder().getSubRange().setLowCount(0L);
            model.getCoder().getSubRange().setHighCount(bs);
            model.getBinSumm()[off1][off2] = bs = bs + 128 - this.getMean(bs, 7, 2) & 0xFFFF;
            model.setPrevSuccess(1);
            model.incRunLength(1);
        } else {
            model.getCoder().getSubRange().setLowCount(bs);
            model.getBinSumm()[off1][off2] = bs = bs - this.getMean(bs, 7, 2) & 0xFFFF;
            model.getCoder().getSubRange().setHighCount(16384L);
            model.setInitEsc(ExpEscape[bs >>> 10]);
            model.setNumMasked(1);
            model.getCharMask()[rs.getSymbol()] = model.getEscCount();
            model.setPrevSuccess(0);
            model.getFoundState().setAddress(0);
        }
    }

    public void update1(ModelPPM model, int p) {
        model.getFoundState().setAddress(p);
        model.getFoundState().incFreq(4);
        this.freqData.incSummFreq(4);
        State p0 = this.tempState3.init(model.getHeap());
        State p1 = this.tempState4.init(model.getHeap());
        p0.setAddress(p);
        p1.setAddress(p - 6);
        if (p0.getFreq() > p1.getFreq()) {
            State.ppmdSwap(p0, p1);
            model.getFoundState().setAddress(p1.getAddress());
            if (p1.getFreq() > 124) {
                this.rescale(model);
            }
        }
    }

    public boolean decodeSymbol2(ModelPPM model) {
        int i = this.getNumStats() - model.getNumMasked();
        SEE2Context psee2c = this.makeEscFreq2(model, i);
        RangeCoder coder = model.getCoder();
        State p = this.tempState1.init(model.getHeap());
        State temp = this.tempState2.init(model.getHeap());
        p.setAddress(this.freqData.getStats() - 6);
        int pps = 0;
        int hiCnt = 0;
        while (true) {
            p.incAddress();
            if (model.getCharMask()[p.getSymbol()] == model.getEscCount()) continue;
            hiCnt += p.getFreq();
            this.ps[pps++] = p.getAddress();
            if (--i == 0) break;
        }
        coder.getSubRange().incScale(hiCnt);
        long count = coder.getCurrentCount();
        if (count >= coder.getSubRange().getScale()) {
            return false;
        }
        pps = 0;
        p.setAddress(this.ps[pps]);
        if (count < (long)hiCnt) {
            hiCnt = 0;
            while ((long)(hiCnt += p.getFreq()) <= count) {
                p.setAddress(this.ps[++pps]);
            }
            coder.getSubRange().setHighCount(hiCnt);
            coder.getSubRange().setLowCount(hiCnt - p.getFreq());
            psee2c.update();
            this.update2(model, p.getAddress());
        } else {
            coder.getSubRange().setLowCount(hiCnt);
            coder.getSubRange().setHighCount(coder.getSubRange().getScale());
            i = this.getNumStats() - model.getNumMasked();
            --pps;
            do {
                temp.setAddress(this.ps[++pps]);
                model.getCharMask()[temp.getSymbol()] = model.getEscCount();
            } while (--i != 0);
            psee2c.incSumm((int)coder.getSubRange().getScale());
            model.setNumMasked(this.getNumStats());
        }
        return true;
    }

    public void update2(ModelPPM model, int p) {
        State temp = this.tempState5.init(model.getHeap());
        temp.setAddress(p);
        model.getFoundState().setAddress(p);
        model.getFoundState().incFreq(4);
        this.freqData.incSummFreq(4);
        if (temp.getFreq() > 124) {
            this.rescale(model);
        }
        model.incEscCount(1);
        model.setRunLength(model.getInitRL());
    }

    private SEE2Context makeEscFreq2(ModelPPM model, int Diff) {
        SEE2Context psee2c;
        int numStats = this.getNumStats();
        if (numStats != 256) {
            PPMContext suff = this.getTempPPMContext(model.getHeap());
            suff.setAddress(this.getSuffix());
            int idx1 = model.getNS2Indx()[Diff - 1];
            int idx2 = 0;
            idx2 += Diff < suff.getNumStats() - numStats ? 1 : 0;
            idx2 += 2 * (this.freqData.getSummFreq() < 11 * numStats ? 1 : 0);
            idx2 += 4 * (model.getNumMasked() > Diff ? 1 : 0);
            psee2c = model.getSEE2Cont()[idx1][idx2 += model.getHiBitsFlag()];
            model.getCoder().getSubRange().setScale(psee2c.getMean());
        } else {
            psee2c = model.getDummySEE2Cont();
            model.getCoder().getSubRange().setScale(1L);
        }
        return psee2c;
    }

    public boolean decodeSymbol1(ModelPPM model) {
        RangeCoder coder = model.getCoder();
        coder.getSubRange().setScale(this.freqData.getSummFreq());
        State p = new State(model.getHeap());
        p.setAddress(this.freqData.getStats());
        long count = coder.getCurrentCount();
        if (count >= coder.getSubRange().getScale()) {
            return false;
        }
        int HiCnt = p.getFreq();
        if (count < (long)HiCnt) {
            coder.getSubRange().setHighCount(HiCnt);
            model.setPrevSuccess((long)(2 * HiCnt) > coder.getSubRange().getScale() ? 1 : 0);
            model.incRunLength(model.getPrevSuccess());
            model.getFoundState().setAddress(p.getAddress());
            model.getFoundState().setFreq(HiCnt += 4);
            this.freqData.incSummFreq(4);
            if (HiCnt > 124) {
                this.rescale(model);
            }
            coder.getSubRange().setLowCount(0L);
            return true;
        }
        if (model.getFoundState().getAddress() == 0) {
            return false;
        }
        model.setPrevSuccess(0);
        int numStats = this.getNumStats();
        int i = numStats - 1;
        while ((long)(HiCnt += p.incAddress().getFreq()) <= count) {
            if (--i != 0) continue;
            model.setHiBitsFlag(model.getHB2Flag()[model.getFoundState().getSymbol()]);
            coder.getSubRange().setLowCount(HiCnt);
            model.getCharMask()[p.getSymbol()] = model.getEscCount();
            model.setNumMasked(numStats);
            i = numStats - 1;
            model.getFoundState().setAddress(0);
            do {
                model.getCharMask()[p.decAddress().getSymbol()] = model.getEscCount();
            } while (--i != 0);
            coder.getSubRange().setHighCount(coder.getSubRange().getScale());
            return true;
        }
        coder.getSubRange().setLowCount(HiCnt - p.getFreq());
        coder.getSubRange().setHighCount(HiCnt);
        this.update1(model, p.getAddress());
        return true;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("PPMContext[");
        buffer.append("\n  pos=");
        buffer.append(this.pos);
        buffer.append("\n  size=");
        buffer.append(size);
        buffer.append("\n  numStats=");
        buffer.append(this.getNumStats());
        buffer.append("\n  Suffix=");
        buffer.append(this.getSuffix());
        buffer.append("\n  freqData=");
        buffer.append(this.freqData);
        buffer.append("\n  oneState=");
        buffer.append(this.oneState);
        buffer.append("\n]");
        return buffer.toString();
    }
}

