/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.util;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.util.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TemplateConfigurationHelper {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.TemplateConfigurationHelper");
    private List<Pattern> includes = new ArrayList<Pattern>();
    private List<Pattern> excludes = new ArrayList<Pattern>();
    private ConfigurationManager cfm;

    public TemplateConfigurationHelper(String[] includes, String[] excludes, ConfigurationManager cfm) {
        this.cfm = cfm;
        for (String regex : includes) {
            this.includes.add(Pattern.compile(regex));
        }
        for (String regex : excludes) {
            this.excludes.add(Pattern.compile(regex));
        }
    }

    public InputStream fillTemplate(InputStream inputStream, Map<String, String> parameters) throws IOException {
        if (inputStream == null || parameters == null || parameters.size() == 0) {
            return inputStream;
        }
        Map<String, String> preparedParams = this.prepareParameters(parameters);
        String configuration = Utils.readStream((InputStream)inputStream);
        for (Map.Entry<String, String> entry : preparedParams.entrySet()) {
            configuration = configuration.replace(entry.getKey(), entry.getValue());
        }
        ByteArrayInputStream configurationStream = new ByteArrayInputStream(configuration.getBytes());
        return configurationStream;
    }

    public InputStream fillTemplate(String filename, Map<String, String> parameters) throws IOException {
        InputStream inputStream = TemplateConfigurationHelper.getInputStream(this.cfm, filename);
        if (inputStream == null) {
            throw new IOException("Can't find or open file:" + filename);
        }
        return this.fillTemplate(inputStream, parameters);
    }

    public static InputStream getInputStream(ConfigurationManager cfm, String filename) {
        InputStream inputStream;
        block8: {
            block7: {
                inputStream = null;
                try {
                    inputStream = cfm.getInputStream(filename);
                }
                catch (Exception e) {
                    if (!LOG.isTraceEnabled()) break block7;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
            if (inputStream == null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                InputStream inputStream2 = inputStream = cl == null ? null : cl.getResourceAsStream(filename);
            }
            if (inputStream == null) {
                inputStream = TemplateConfigurationHelper.class.getClassLoader().getResourceAsStream(filename);
            }
            if (inputStream == null) {
                try {
                    inputStream = new FileInputStream(filename);
                }
                catch (IOException e) {
                    if (!LOG.isTraceEnabled()) break block8;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
        }
        return inputStream;
    }

    private boolean matches(List<Pattern> patterns, String parameter) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(parameter).matches()) continue;
            return true;
        }
        return false;
    }

    protected Map<String, String> prepareParameters(Map<String, String> parameters) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (!this.matches(this.includes, entry.getKey()) || this.matches(this.excludes, entry.getKey())) continue;
            map.put("${" + entry.getKey() + "}", entry.getValue());
        }
        return map;
    }
}

