/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.resource.jcr;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import javax.jcr.RepositoryException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.resource.JcrURLConnection;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentationService;
import org.exoplatform.services.jcr.ext.resource.UnifiedNodeReference;
import org.exoplatform.services.security.ConversationState;
import org.picocontainer.Startable;

public class Handler
extends URLStreamHandler
implements Startable {
    private static final String protocolPathPkg = "org.exoplatform.services.jcr.ext.resource";
    private final RepositoryService repositoryService;
    private final NodeRepresentationService nodeRepresentationService;
    private final SessionProviderService threadLocalSessionProviderService;

    public Handler(RepositoryService rs, NodeRepresentationService nrs, SessionProviderService tsps) {
        this.repositoryService = rs;
        this.nodeRepresentationService = nrs;
        this.threadLocalSessionProviderService = tsps;
    }

    public Handler() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        this.nodeRepresentationService = (NodeRepresentationService)container.getComponentInstanceOfType(NodeRepresentationService.class);
        this.threadLocalSessionProviderService = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        try {
            String workspaceName;
            String repositoryName;
            UnifiedNodeReference nodeReference = new UnifiedNodeReference(url);
            SessionProvider sessionProvider = this.threadLocalSessionProviderService.getSessionProvider(null);
            boolean closeSessionProvider = false;
            if (sessionProvider == null && ConversationState.getCurrent() != null) {
                sessionProvider = (SessionProvider)ConversationState.getCurrent().getAttribute("JCRsessionProvider");
            }
            if (sessionProvider == null) {
                sessionProvider = SessionProvider.createAnonimProvider();
                closeSessionProvider = true;
            }
            if ((repositoryName = nodeReference.getRepository()) != null && repositoryName.length() > 0) {
                ManageableRepository repository = this.repositoryService.getRepository(repositoryName);
                sessionProvider.setCurrentRepository(repository);
            }
            if ((workspaceName = nodeReference.getWorkspace()) != null && workspaceName.length() > 0) {
                sessionProvider.setCurrentWorkspace(workspaceName);
            }
            JcrURLConnection conn = new JcrURLConnection(nodeReference, sessionProvider, this.nodeRepresentationService, closeSessionProvider);
            return conn;
        }
        catch (RepositoryException e) {
            throw new IOException("Open connection to URL '" + url.toString() + "' failed!", e);
        }
        catch (URISyntaxException e) {
            throw new IOException("Open connection to URL '" + url.toString() + "' failed!", e);
        }
        catch (RepositoryConfigurationException e) {
            throw new IOException("Open connection to URL '" + url.toString() + "' failed!", e);
        }
    }

    public void start() {
        String existingProtocolPathPkgs = System.getProperty("java.protocol.handler.pkgs");
        if (existingProtocolPathPkgs == null) {
            System.setProperty("java.protocol.handler.pkgs", protocolPathPkg);
        } else if (existingProtocolPathPkgs.indexOf(protocolPathPkg) == -1) {
            System.setProperty("java.protocol.handler.pkgs", existingProtocolPathPkgs + "|org.exoplatform.services.jcr.ext.resource");
        }
    }

    public void stop() {
    }
}

