/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter.sqlmm;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sis.filter.Expression;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.filter.sqlmm.FunctionWithSRID;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class GeometryConstructor<R, G>
extends FunctionWithSRID<R> {
    private static final long serialVersionUID = -4644842662358995787L;
    final Expression<? super R, ?> geometry;
    final Geometries<G> library;

    GeometryConstructor(SQLMM sQLMM, Expression<? super R, ?>[] expressionArray, Geometries<G> geometries) {
        super(sQLMM, expressionArray, expressionArray.length >= sQLMM.maxParamCount ? 1 : 0);
        this.geometry = expressionArray[0];
        this.library = geometries;
    }

    @Override
    public Expression<R, Object> recreate(Expression<? super R, ?>[] expressionArray) {
        return new GeometryConstructor(this.operation, expressionArray, this.getGeometryLibrary());
    }

    @Override
    public final List<Expression<? super R, ?>> getParameters() {
        if (this.srid == null) {
            return Collections.singletonList(this.geometry);
        }
        return Arrays.asList(this.geometry, this.srid);
    }

    @Override
    final Geometries<?> getGeometryLibrary() {
        return this.library;
    }

    @Override
    public Object apply(R r) {
        Object obj = this.geometry.apply(r);
        try {
            CoordinateReferenceSystem coordinateReferenceSystem;
            if (obj == null) {
                return null;
            }
            GeometryWrapper<G> geometryWrapper = obj instanceof byte[] ? this.library.parseWKB(ByteBuffer.wrap((byte[])obj)) : (obj instanceof ByteBuffer ? this.library.parseWKB((ByteBuffer)obj) : (obj instanceof String ? this.library.parseWKT((String)obj) : this.library.createFromComponents(this.operation.getGeometryType().get(), obj)));
            Object object = geometryWrapper.implementation();
            Class<?> clazz = this.operation.getReturnType(this.library);
            if (!clazz.isInstance(object)) {
                throw new IllegalArgumentException(Errors.format((short)43, (Object)"geom", clazz, object.getClass()));
            }
            if (this.srid != null && (coordinateReferenceSystem = this.getTargetCRS(r)) != null) {
                geometryWrapper.setCoordinateReferenceSystem(coordinateReferenceSystem);
            }
            return object;
        }
        catch (Exception exception) {
            this.warning(exception, false);
            return null;
        }
    }
}

