/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataHashObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataSizeObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.IntermediateNodeObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.NodeObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupDataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupObjectData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupObjectDeclare;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.SignatureObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectParseErrorException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BinaryItem;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.DataNodeObjectData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ExGuid;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.ByteUtil;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.SequenceNumberGenerator;

public class LeafNodeObject
extends NodeObject {
    public DataNodeObjectData dataNodeObjectData;
    public DataHashObject dataHash;

    public LeafNodeObject() {
        super(StreamObjectTypeHeaderStart.LeafNodeObject);
    }

    @Override
    public List<Byte> getContent() throws TikaException {
        ArrayList<Byte> content = new ArrayList<Byte>();
        if (this.dataNodeObjectData != null) {
            ByteUtil.appendByteArrayToListOfByte(content, this.dataNodeObjectData.objectData);
        } else if (this.intermediateNodeObjectList != null) {
            for (LeafNodeObject intermediateNode : this.intermediateNodeObjectList) {
                content.addAll(intermediateNode.getContent());
            }
        } else {
            throw new TikaException("The DataNodeObjectData and IntermediateNodeObjectList properties in LeafNodeObjectData cannot be null at the same time.");
        }
        return content;
    }

    @Override
    protected void deserializeItemsFromByteArray(byte[] byteArray, AtomicInteger currentIndex, int lengthOfItems) throws TikaException, IOException {
        AtomicInteger index = new AtomicInteger(currentIndex.get());
        if (lengthOfItems != 0) {
            throw new StreamObjectParseErrorException(currentIndex.get(), "LeafNodeObjectData", "Stream Object over-parse error", null);
        }
        this.signature = StreamObject.getCurrent(byteArray, index, SignatureObject.class);
        this.dataSize = StreamObject.getCurrent(byteArray, index, DataSizeObject.class);
        AtomicReference<StreamObjectHeaderStart> streamObjectHeader = new AtomicReference<StreamObjectHeaderStart>();
        if (StreamObjectHeaderStart.tryParse(byteArray, index.get(), streamObjectHeader) != 0 && streamObjectHeader.get().type == StreamObjectTypeHeaderStart.DataHashObject) {
            this.dataHash = StreamObject.getCurrent(byteArray, index, DataHashObject.class);
        }
        currentIndex.set(index.get());
    }

    @Override
    protected int serializeItemsToByteList(List<Byte> byteList) throws TikaException, IOException {
        byteList.addAll(this.signature.serializeToByteList());
        byteList.addAll(this.dataSize.serializeToByteList());
        return 0;
    }

    public static class IntermediateNodeObjectBuilder {
        public LeafNodeObject Build(List<ObjectGroupDataElementData> objectGroupList, ObjectGroupObjectData dataObj, ExGuid intermediateGuid) throws TikaException, IOException {
            AtomicReference<LeafNodeObject> node = new AtomicReference<LeafNodeObject>();
            AtomicReference rootNode = new AtomicReference();
            AtomicInteger index = new AtomicInteger(0);
            if (StreamObject.tryGetCurrent(ByteUtil.toByteArray(dataObj.data.content), index, node, LeafNodeObject.class)) {
                if (dataObj.objectExGUIDArray == null) {
                    throw new TikaException("Failed to build intermediate node because the object extend GUID array does not exist.");
                }
                ((LeafNodeObject)node.get()).exGuid = intermediateGuid;
                if (dataObj.objectExGUIDArray.count.getDecodedValue() == 1L) {
                    AtomicReference<ObjectGroupObjectDeclare> dataNodeDeclare = new AtomicReference<ObjectGroupObjectDeclare>();
                    ObjectGroupObjectData dataNodeData = this.FindByExGuid(objectGroupList, dataObj.objectExGUIDArray.content.get(0), dataNodeDeclare);
                    BinaryItem data = dataNodeData.data;
                    ((LeafNodeObject)node.get()).dataNodeObjectData = new DataNodeObjectData(ByteUtil.toByteArray(data.content), 0, (int)data.length.getDecodedValue());
                    ((LeafNodeObject)node.get()).dataNodeObjectData.exGuid = dataObj.objectExGUIDArray.content.get(0);
                    ((LeafNodeObject)node.get()).intermediateNodeObjectList = null;
                } else {
                    ((LeafNodeObject)node.get()).intermediateNodeObjectList = new ArrayList();
                    ((LeafNodeObject)node.get()).dataNodeObjectData = null;
                    for (ExGuid extGuid : dataObj.objectExGUIDArray.content) {
                        AtomicReference<ObjectGroupObjectDeclare> intermediateDeclare = new AtomicReference<ObjectGroupObjectDeclare>();
                        ObjectGroupObjectData intermediateData = this.FindByExGuid(objectGroupList, extGuid, intermediateDeclare);
                        ((LeafNodeObject)node.get()).intermediateNodeObjectList.add(new IntermediateNodeObjectBuilder().Build(objectGroupList, intermediateData, extGuid));
                    }
                }
            } else if (StreamObject.tryGetCurrent(ByteUtil.toByteArray(dataObj.data.content), index, rootNode, IntermediateNodeObject.class)) {
                node.set(new LeafNodeObject());
                ((LeafNodeObject)node.get()).intermediateNodeObjectList = new ArrayList();
                ((LeafNodeObject)node.get()).dataSize = ((IntermediateNodeObject)rootNode.get()).dataSize;
                ((LeafNodeObject)node.get()).exGuid = ((IntermediateNodeObject)rootNode.get()).exGuid;
                ((LeafNodeObject)node.get()).signature = ((IntermediateNodeObject)rootNode.get()).signature;
                ((LeafNodeObject)node.get()).dataNodeObjectData = null;
                for (ExGuid extGuid : dataObj.objectExGUIDArray.content) {
                    AtomicReference<ObjectGroupObjectDeclare> intermediateDeclare = new AtomicReference<ObjectGroupObjectDeclare>();
                    ObjectGroupObjectData intermediateData = this.FindByExGuid(objectGroupList, extGuid, intermediateDeclare);
                    ((LeafNodeObject)node.get()).intermediateNodeObjectList.add(new IntermediateNodeObjectBuilder().Build(objectGroupList, intermediateData, extGuid));
                }
            } else {
                throw new TikaException("In the ObjectGroupDataElement cannot only contain the IntermediateNodeObject or IntermediateNodeObject.");
            }
            return (LeafNodeObject)node.get();
        }

        public LeafNodeObject Build(byte[] array, SignatureObject signature) {
            LeafNodeObject nodeObject = new LeafNodeObject();
            nodeObject.dataSize = new DataSizeObject();
            nodeObject.dataSize.dataSize = array.length;
            nodeObject.signature = signature;
            nodeObject.exGuid = new ExGuid(SequenceNumberGenerator.GetCurrentSerialNumber(), UUID.randomUUID());
            nodeObject.dataNodeObjectData = new DataNodeObjectData(array, 0, array.length);
            nodeObject.intermediateNodeObjectList = null;
            return nodeObject;
        }

        private ObjectGroupObjectData FindByExGuid(List<ObjectGroupDataElementData> objectGroupList, ExGuid extendedGuid, AtomicReference<ObjectGroupObjectDeclare> declare) throws TikaException {
            for (ObjectGroupDataElementData objectGroup : objectGroupList) {
                int findIndex = -1;
                for (int i = 0; i < objectGroup.objectGroupDeclarations.objectDeclarationList.size(); ++i) {
                    ObjectGroupObjectDeclare objDeclare = objectGroup.objectGroupDeclarations.objectDeclarationList.get(i);
                    if (!objDeclare.objectExtendedGUID.equals(extendedGuid)) continue;
                    findIndex = i;
                    break;
                }
                if (findIndex < 0) continue;
                declare.set(objectGroup.objectGroupDeclarations.objectDeclarationList.get(findIndex));
                return objectGroup.objectGroupData.objectGroupObjectDataList.get(findIndex);
            }
            throw new TikaException("Cannot find the " + extendedGuid.guid.toString());
        }
    }
}

