/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.script.groovy.jarjar;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.exoplatform.services.script.groovy.jarjar.PackageNameVisitor;

class Package {
    private final Package parent;
    private final Map<String, Package> subMappers;
    private List<String> target;

    public Package() {
        this.parent = null;
        this.target = null;
        this.subMappers = new HashMap<String, Package>();
    }

    private Package(Package parent) {
        this.parent = parent;
        this.target = null;
        this.subMappers = new HashMap<String, Package>();
    }

    public void add(List<String> source, List<String> target) {
        this.add(source.iterator(), target);
    }

    public Package getSubPackage(String name) {
        return this.subMappers.get(name);
    }

    private void add(Iterator<String> source, List<String> target) {
        if (source.hasNext()) {
            String name = source.next();
            Package sub = this.subMappers.get(name);
            if (sub == null) {
                sub = new Package(this);
                this.subMappers.put(name, sub);
            }
            sub.add(source, target);
        } else {
            if (this.target != null) {
                throw new IllegalStateException();
            }
            this.target = Collections.unmodifiableList(target);
        }
    }

    public List<String> getTarget() {
        return this.target;
    }

    public String getName() {
        if (this.parent != null) {
            for (Map.Entry<String, Package> entry : this.parent.subMappers.entrySet()) {
                if (entry.getValue() != this) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public Package map(Expression exp) {
        Package mapmap = null;
        if (exp instanceof VariableExpression) {
            String name = ((VariableExpression)exp).getName();
            mapmap = this.getSubPackage(name);
        } else if (exp instanceof PropertyExpression) {
            Package sub_sub;
            ConstantExpression pe_ce;
            PropertyExpression pe = (PropertyExpression)exp;
            if (pe.getObjectExpression() instanceof VariableExpression) {
                mapmap = this.map(pe.getObjectExpression());
            } else if (pe.getObjectExpression() instanceof PropertyExpression) {
                PropertyExpression pe_pe = (PropertyExpression)pe.getObjectExpression();
                mapmap = this.map((Expression)pe_pe);
            }
            if (mapmap != null && (pe_ce = (ConstantExpression)pe.getProperty()).getType().getName().equals("java.lang.String") && (sub_sub = mapmap.getSubPackage((String)pe_ce.getValue())) != null) {
                mapmap = sub_sub;
            }
        }
        return mapmap;
    }

    public List<String> map2(Expression expr) {
        BiltoVisitor visitor = new BiltoVisitor(this);
        visitor.visit(expr);
        return visitor.repackaged ? visitor.bilto : null;
    }

    public List<String> map2(String expr) {
        BiltoVisitor visitor = new BiltoVisitor(this);
        visitor.visit(expr);
        return visitor.repackaged ? visitor.bilto : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    private void toString(StringBuilder sb) {
        if (this.parent != null) {
            this.parent.toString(sb);
            String name = this.getName();
            sb.append(".").append(name);
        }
    }

    private static class BiltoVisitor
    extends PackageNameVisitor {
        Package ref;
        List<String> bilto = new LinkedList<String>();
        boolean repackaged = false;

        private BiltoVisitor(Package mapper) {
            this.ref = mapper;
        }

        @Override
        protected void accept(String name) {
            if (this.ref != null) {
                Package sub = this.ref.getSubPackage(name);
                if (sub != null) {
                    List<String> target = sub.target;
                    if (target != null) {
                        this.bilto.clear();
                        this.bilto.addAll(target);
                        this.repackaged = true;
                    } else {
                        this.bilto.add(name);
                    }
                    this.ref = sub;
                } else {
                    this.bilto.add(name);
                    this.ref = null;
                }
            } else {
                this.bilto.add(name);
            }
        }
    }
}

