/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.ispn;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.Indexer;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.ispn.ChangesKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.Cache;
import org.infinispan.commons.util.concurrent.FutureListener;
import org.infinispan.context.Flag;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;

public abstract class AbstractIndexerCacheStore
implements AdvancedLoadWriteStore {
    protected final Map<String, Indexer> indexers = new HashMap<String, Indexer>();
    protected InitializationContext ctx;
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.IndexerCacheLoader");

    public void register(SearchManager searchManager, SearchManager parentSearchManager, QueryHandler handler, QueryHandler parentHandler) throws RepositoryConfigurationException {
        this.indexers.put(searchManager.getWsId(), new Indexer(searchManager, parentSearchManager, handler, parentHandler));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Register " + searchManager.getWsId() + " " + String.valueOf(this) + " in " + String.valueOf(this.indexers)));
        }
    }

    public abstract IndexerIoModeHandler getModeHandler();

    public void init(InitializationContext ctx) {
        this.ctx = ctx;
    }

    public void start() {
    }

    public void stop() {
        this.indexers.clear();
    }

    public MarshalledEntry load(Object key) {
        return null;
    }

    public boolean contains(Object key) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(MarshalledEntry entry) {
        if (entry.getKey() instanceof ChangesKey && entry.getValue() instanceof ChangesFilterListsWrapper) {
            Cache cache;
            ChangesKey key;
            block7: {
                if (LOG.isDebugEnabled()) {
                    LOG.info((Object)"Received list wrapper, start indexing...");
                }
                ChangesFilterListsWrapper wrapper = (ChangesFilterListsWrapper)entry.getValue();
                key = (ChangesKey)entry.getKey();
                cache = this.ctx.getCache();
                try {
                    Indexer indexer = this.indexers.get(key.getWsId());
                    if (indexer == null) {
                        LOG.warn((Object)("No indexer could be found for the cache entry " + key.toString()));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("The current content of the map of indexers is " + String.valueOf(this.indexers)));
                        }
                        break block7;
                    }
                    if (wrapper.withChanges()) {
                        indexer.updateIndex(wrapper.getChanges(), wrapper.getParentChanges());
                        break block7;
                    }
                    indexer.updateIndex(wrapper.getAddedNodes(), wrapper.getRemovedNodes(), wrapper.getParentAddedNodes(), wrapper.getParentRemovedNodes());
                }
                catch (Throwable throwable) {
                    cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.IGNORE_RETURN_VALUES}).removeAsync((Object)key).attachListener(new FutureListener(){
                        final /* synthetic */ Cache val$cache;
                        final /* synthetic */ ChangesKey val$key;
                        {
                            this.val$cache = cache;
                            this.val$key = changesKey;
                        }

                        public void futureDone(Future future) {
                            if (this.val$cache.containsKey((Object)this.val$key)) {
                                LOG.debug((Object)"The entry was not removed properly, it will try to remove it once again");
                                this.val$cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.IGNORE_RETURN_VALUES}).remove((Object)this.val$key);
                            }
                        }
                    });
                    throw throwable;
                }
            }
            cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.IGNORE_RETURN_VALUES}).removeAsync((Object)key).attachListener(new /* invalid duplicate definition of identical inner class */);
        }
    }

    public boolean delete(Object key) {
        return true;
    }

    public void clear() {
        throw new UnsupportedOperationException("This operation is not supported by this component.");
    }

    public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener listener) {
    }

    public void process(KeyFilter filter, AdvancedCacheLoader.CacheLoaderTask task, Executor executor, boolean fetchValue, boolean fetchMetadata) {
    }

    public int size() {
        return 0;
    }
}

