/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web.jakarta.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.apache.commons.chain.web.jakarta.WebContext;
import org.apache.commons.chain.web.jakarta.servlet.ServletApplicationScopeMap;
import org.apache.commons.chain.web.jakarta.servlet.ServletCookieMap;
import org.apache.commons.chain.web.jakarta.servlet.ServletHeaderMap;
import org.apache.commons.chain.web.jakarta.servlet.ServletHeaderValuesMap;
import org.apache.commons.chain.web.jakarta.servlet.ServletInitParamMap;
import org.apache.commons.chain.web.jakarta.servlet.ServletParamMap;
import org.apache.commons.chain.web.jakarta.servlet.ServletParamValuesMap;
import org.apache.commons.chain.web.jakarta.servlet.ServletRequestScopeMap;
import org.apache.commons.chain.web.jakarta.servlet.ServletSessionScopeMap;

public class ServletWebContext
extends WebContext {
    private static final long serialVersionUID = 5302874006663111922L;
    private transient Map<String, Object> applicationScope = null;
    private transient ServletContext context = null;
    private transient Map<String, String> header = null;
    private transient Map<String, String[]> headerValues = null;
    private transient Map<String, String> initParam = null;
    private transient Map<String, Cookie> cookieValues = null;
    private transient Map<String, String> param = null;
    private transient Map<String, String[]> paramValues = null;
    private transient HttpServletRequest request = null;
    private transient Map<String, Object> requestScope = null;
    private transient HttpServletResponse response = null;
    private transient Map<String, Object> sessionScope = null;

    public ServletWebContext() {
    }

    public ServletWebContext(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.initialize(context, request, response);
    }

    public ServletContext getContext() {
        return this.context;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void initialize(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.context = context;
        this.request = request;
        this.response = response;
    }

    public void release() {
        this.applicationScope = null;
        this.header = null;
        this.headerValues = null;
        this.initParam = null;
        this.param = null;
        this.paramValues = null;
        this.cookieValues = null;
        this.requestScope = null;
        this.sessionScope = null;
        this.context = null;
        this.request = null;
        this.response = null;
    }

    public Map<String, Object> getApplicationScope() {
        if (this.applicationScope == null && this.context != null) {
            this.applicationScope = new ServletApplicationScopeMap(this.context);
        }
        return this.applicationScope;
    }

    public Map<String, String> getHeader() {
        if (this.header == null && this.request != null) {
            this.header = new ServletHeaderMap(this.request);
        }
        return this.header;
    }

    public Map<String, String[]> getHeaderValues() {
        if (this.headerValues == null && this.request != null) {
            this.headerValues = new ServletHeaderValuesMap(this.request);
        }
        return this.headerValues;
    }

    public Map<String, String> getInitParam() {
        if (this.initParam == null && this.context != null) {
            this.initParam = new ServletInitParamMap(this.context);
        }
        return this.initParam;
    }

    public Map<String, String> getParam() {
        if (this.param == null && this.request != null) {
            this.param = new ServletParamMap(this.request);
        }
        return this.param;
    }

    public Map<String, String[]> getParamValues() {
        if (this.paramValues == null && this.request != null) {
            this.paramValues = new ServletParamValuesMap(this.request);
        }
        return this.paramValues;
    }

    public Map<String, Cookie> getCookies() {
        if (this.cookieValues == null && this.request != null) {
            this.cookieValues = new ServletCookieMap(this.request);
        }
        return this.cookieValues;
    }

    public Map<String, Object> getRequestScope() {
        if (this.requestScope == null && this.request != null) {
            this.requestScope = new ServletRequestScopeMap(this.request);
        }
        return this.requestScope;
    }

    public Map<String, Object> getSessionScope() {
        if (this.sessionScope == null && this.request != null) {
            this.sessionScope = new ServletSessionScopeMap(this.request);
        }
        return this.sessionScope;
    }
}

