/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.jcr.impl.storage.JCRItemExistsException;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;

public class SQLExceptionHandler {
    private final String containerName;
    private final JDBCStorageConnection conn;

    SQLExceptionHandler(String containerName, JDBCStorageConnection conn) {
        this.containerName = containerName;
        this.conn = conn;
    }

    public String handleAddException(SQLException e, ItemData item) throws RepositoryException, InvalidItemStateException {
        String itemInfo;
        StringBuilder message;
        block25: {
            if (e instanceof BatchUpdateException) {
                if (e.getNextException() != null) {
                    e = e.getNextException();
                } else if (e.getCause() instanceof SQLException) {
                    e = (SQLException)e.getCause();
                }
            }
            message = new StringBuilder("[");
            message.append(this.containerName).append("] ADD ").append(item.isNode() ? "NODE. " : "PROPERTY. ");
            String errMessage = e.getMessage();
            itemInfo = item.getQPath().getAsString() + ", ID: " + item.getIdentifier() + ", ParentID: " + item.getParentIdentifier() + (String)(errMessage != null ? ". Cause >>>> " + errMessage : "");
            if (errMessage != null) {
                String umsg = errMessage.toLowerCase().toUpperCase();
                if (umsg.indexOf(this.conn.JCR_FK_ITEM_PARENT) >= 0) {
                    message.append("Parent not found. Item ").append(itemInfo);
                    throw new JCRInvalidItemStateException(message.toString(), item.getIdentifier(), 1, e);
                }
                if (umsg.indexOf(this.conn.JCR_PK_ITEM) >= 0) {
                    message.append("Item already exists. Condition: ID. ").append(itemInfo);
                    throw new JCRInvalidItemStateException(message.toString(), item.getIdentifier(), 1, e);
                }
                if (umsg.indexOf(this.conn.JCR_IDX_ITEM_PARENT_NAME) >= 0) {
                    message.append("Item already exists. Condition: parent ID and ID. ").append(itemInfo);
                    throw new ItemExistsException(message.toString(), (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_IDX_ITEM_PARENT_ID) >= 0) {
                    message.append("Item already exists. Condition: parent ID and ID. ").append(itemInfo);
                    throw new ItemExistsException(message.toString(), (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_IDX_ITEM_PARENT) >= 0) {
                    message.append("Item already exists. Condition: parent ID, name, index. ").append(itemInfo);
                    throw new ItemExistsException(message.toString(), (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_FK_VALUE_PROPERTY) >= 0) {
                    message.append("Property is not exist but the value is being created. Condition: property ID. ").append(itemInfo);
                    throw new RepositoryException(message.toString(), (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_IDX_VALUE_PROPERTY) >= 0) {
                    message.append("Property already exists. Condition: property ID, order number. ").append(itemInfo);
                    throw new RepositoryException(message.toString(), (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_PK_VALUE) >= 0) {
                    message.append("[FATAL] Value already exists with the ValueID. Impossible state, check is ValueID is autoincremented. ").append(itemInfo);
                    throw new RepositoryException(message.toString(), (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_PK_REF) >= 0) {
                    message.append("Reference chain already exists. Condition: node ID, property ID, order number. ").append(itemInfo);
                    throw new RepositoryException(message.toString(), (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_IDX_REF_PROPERTY) >= 0) {
                    message.append("Referenceable property value already exists. Condition: property ID, order number. ").append(itemInfo);
                    throw new RepositoryException(message.toString(), (Throwable)e);
                }
            }
            Object ownException = null;
            try {
                block26: {
                    NodeData parent = (NodeData)this.conn.getItemData(item.getParentIdentifier());
                    if (parent == null) break block25;
                    try {
                        ItemData me = this.conn.getItemData(item.getIdentifier());
                        if (me != null) {
                            message.append("Item already exists in storage: ").append(itemInfo);
                            ownException = new JCRItemExistsException(message.toString(), me.getIdentifier(), 1, e);
                            throw ownException;
                        }
                        me = this.conn.getItemData(parent, new QPathEntry(item.getQPath().getName(), item.getQPath().getIndex()), ItemType.getItemType(item));
                        if (me != null) {
                            message.append("Item already exists in storage: ").append(itemInfo);
                            ownException = new JCRItemExistsException(message.toString(), me.getIdentifier(), 1, e);
                            throw ownException;
                        }
                    }
                    catch (Exception ep) {
                        if (ownException == null) break block26;
                        throw ownException;
                    }
                }
                if (e.getClass().getName().indexOf("MySQLIntegrityConstraintViolationException") >= 0 && errMessage.indexOf(item.getIdentifier()) >= 0) {
                    message.append("Item already exists. Condition: ID. ").append(itemInfo);
                    throw new JCRInvalidItemStateException(message.toString(), item.getIdentifier(), 1, e);
                }
                if (e.getClass().getName().indexOf("BatchUpdateException") >= 0 && errMessage.indexOf(item.getIdentifier()) >= 0) {
                    message.append("Item already exists. Condition: ID. ").append(itemInfo);
                    throw new JCRInvalidItemStateException(message.toString(), item.getIdentifier(), 1, e);
                }
                if (e.getClass().getName().indexOf("SqlIntegrityConstraintViolationException") >= 0 && errMessage.indexOf("SQLCODE=-803") >= 0) {
                    message.append("Item already exists.").append(itemInfo);
                    throw new JCRInvalidItemStateException(message.toString(), item.getIdentifier(), 1, e);
                }
                if (e.getClass().getName().indexOf("JdbcSQLException") >= 0 && errMessage.indexOf("Unique index or primary key violation") >= 0) {
                    message.append("Item already exists.").append(itemInfo);
                    throw new JCRInvalidItemStateException(message.toString(), item.getIdentifier(), 1, e);
                }
                message.append("Error of item add. ").append(itemInfo);
                ownException = new RepositoryException(message.toString(), (Throwable)e);
                throw ownException;
            }
            catch (Exception ep) {
                if (ownException == null) break block25;
                throw ownException;
            }
        }
        message.append("Error of item add. ").append(itemInfo);
        throw new JCRInvalidItemStateException(message.toString(), item.getIdentifier(), 1, e);
    }

    protected String handleAddException(IOException e, ItemData item) throws RepositoryException, InvalidItemStateException {
        String itemInfo;
        StringBuilder message;
        block6: {
            message = new StringBuilder("[");
            message.append(this.containerName).append("] ADD ").append(item.isNode() ? "NODE. " : "PROPERTY. ");
            String errMessage = e.getMessage();
            itemInfo = item.getQPath().getAsString() + ", ID: " + item.getIdentifier() + ", ParentID: " + item.getParentIdentifier() + (String)(errMessage != null ? ". Cause >>>> " + errMessage : "");
            Throwable ownException = null;
            try {
                block7: {
                    NodeData parent = (NodeData)this.conn.getItemData(item.getParentIdentifier());
                    if (parent == null) break block6;
                    try {
                        ItemData me = this.conn.getItemData(item.getIdentifier());
                        if (me != null) {
                            message.append("Item already exists in storage: ").append(itemInfo);
                            ownException = new ItemExistsException(message.toString(), (Throwable)e);
                            throw ownException;
                        }
                        me = this.conn.getItemData(parent, new QPathEntry(item.getQPath().getName(), item.getQPath().getIndex()), ItemType.getItemType(item));
                        if (me != null) {
                            message.append("Item already exists in storage: ").append(itemInfo);
                            ownException = new ItemExistsException(message.toString(), (Throwable)e);
                            throw ownException;
                        }
                    }
                    catch (Exception ep) {
                        if (ownException == null) break block7;
                        throw ownException;
                    }
                }
                message.append("Error of item add. ").append(itemInfo);
                ownException = new RepositoryException(message.toString(), (Throwable)e);
                throw ownException;
            }
            catch (Exception ep) {
                if (ownException == null) break block6;
                throw ownException;
            }
        }
        message.append("Error of item add. ").append(itemInfo);
        throw new JCRInvalidItemStateException(message.toString(), item.getIdentifier(), 1, e);
    }

    public String handleDeleteException(SQLException e, ItemData item) throws RepositoryException, InvalidItemStateException {
        StringBuilder message = new StringBuilder("[");
        message.append(this.containerName).append("] DELETE ").append(item.isNode() ? "NODE. " : "PROPERTY. ");
        String errMessage = e.getMessage();
        String itemInfo = item.getQPath().getAsString() + " " + item.getIdentifier() + (String)(errMessage != null ? ". Cause >>>> " + errMessage : "");
        if (errMessage != null) {
            String umsg = errMessage.toLowerCase().toUpperCase();
            if (umsg.indexOf(this.conn.JCR_FK_ITEM_PARENT) >= 0) {
                message.append("Can not delete parent till childs exists. Item ").append(itemInfo);
                throw new JCRInvalidItemStateException(message.toString(), item.getIdentifier(), 4, e);
            }
            if (umsg.indexOf(this.conn.JCR_FK_VALUE_PROPERTY) >= 0) {
                message.append("[FATAL] Can not delete property item till it contains values. Condition: property ID. ").append(itemInfo);
                throw new RepositoryException(message.toString(), (Throwable)e);
            }
        }
        message.append("Error of item delete ").append(itemInfo);
        throw new RepositoryException(message.toString(), (Throwable)e);
    }

    public String handleUpdateException(SQLException e, ItemData item) throws RepositoryException, InvalidItemStateException {
        String itemInfo;
        StringBuilder message;
        block6: {
            message = new StringBuilder("[");
            message.append(this.containerName).append("] EDIT ").append(item.isNode() ? "NODE. " : "PROPERTY. ");
            String errMessage = e.getMessage();
            itemInfo = item.getQPath().getAsString() + " " + item.getIdentifier() + (String)(errMessage != null ? ". Cause >>>> " + errMessage : "");
            if (errMessage != null) {
                if (errMessage.toLowerCase().toUpperCase().indexOf(this.conn.JCR_FK_VALUE_PROPERTY) >= 0) {
                    message.append("Property is not exists but the value is being created. Condition: property ID. ").append(itemInfo);
                    throw new RepositoryException(message.toString(), (Throwable)e);
                }
                if (errMessage.toLowerCase().toUpperCase().indexOf(this.conn.JCR_PK_ITEM) >= 0) {
                    message.append("Item already exists. Condition: ID. ").append(itemInfo);
                    throw new JCRInvalidItemStateException(message.toString(), item.getIdentifier(), 2, e);
                }
            }
            RepositoryException ownException = null;
            try {
                ItemData me = this.conn.getItemData(item.getIdentifier());
                if (me != null) {
                    message.append("Item already exists. But update errors. ").append(itemInfo);
                    ownException = new RepositoryException(message.toString(), (Throwable)e);
                    throw ownException;
                }
            }
            catch (Exception ep) {
                if (ownException == null) break block6;
                throw ownException;
            }
        }
        message.append("Error of item update. ").append(itemInfo);
        throw new JCRInvalidItemStateException(message.toString(), item.getIdentifier(), 2, e);
    }
}

