/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public abstract class Text {
    public static Text create(byte[] bytes) throws IllegalArgumentException {
        return new Bytes(bytes);
    }

    public static Text create(char[] chars) throws IllegalArgumentException {
        return new Chars(chars);
    }

    public static Text create(String s) throws IllegalArgumentException {
        return new Chars(s.toCharArray());
    }

    public abstract byte[] getBytes();

    public abstract char[] getChars();

    public abstract void appendTo(Appendable var1) throws IOException;

    public abstract void writeTo(Writer var1) throws IOException;

    private static class Chars
    extends Text
    implements CharSequence {
        private int offset;
        private int count;
        private char[] chars;

        private Chars(char[] chars) {
            this.chars = chars;
            this.offset = 0;
            this.count = chars.length;
        }

        private Chars(char[] chars, int offset, int count) {
            this.chars = chars;
            this.offset = offset;
            this.count = count;
        }

        public byte[] getBytes() {
            String s = new String(this.chars, this.offset, this.count);
            try {
                return s.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return s.getBytes();
            }
        }

        public char[] getChars() {
            if (this.offset > 0 || this.count < this.chars.length) {
                char[] tmp = new char[this.count];
                System.arraycopy(this.chars, this.offset, tmp, 0, this.count);
                this.chars = tmp;
                this.offset = 0;
            }
            return this.chars;
        }

        public void writeTo(Writer writer) throws IOException {
            writer.write(this.chars, this.offset, this.count);
        }

        public void appendTo(Appendable appendable) throws IOException {
            appendable.append(this);
        }

        public int length() {
            return this.count;
        }

        public char charAt(int index) {
            return this.chars[index - this.offset];
        }

        public CharSequence subSequence(int start, int end) {
            if (start < 0) {
                throw new ArrayIndexOutOfBoundsException("Start index cannot be negative");
            }
            if (end < 0) {
                throw new ArrayIndexOutOfBoundsException("End index cannot be negative");
            }
            if (start > end) {
                throw new ArrayIndexOutOfBoundsException("Start index cannot be greater than the end index");
            }
            if (end > this.count) {
                throw new ArrayIndexOutOfBoundsException("End index cannot be greater than the sequence length");
            }
            return new Chars(this.chars, this.offset + start, end - start);
        }

        public String toString() {
            return new String(this.chars, this.offset, this.count);
        }
    }

    private static class Bytes
    extends Text {
        private final byte[] bytes;

        private Bytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public char[] getChars() {
            try {
                return new String(this.bytes, "utf-8").toCharArray();
            }
            catch (UnsupportedEncodingException e) {
                return new String(this.bytes).toCharArray();
            }
        }

        public void appendTo(Appendable appendable) throws IOException {
            for (char c : this.getChars()) {
                appendable.append(c);
            }
        }

        public void writeTo(Writer writer) throws IOException {
            for (char c : this.getChars()) {
                writer.append(c);
            }
        }
    }
}

